/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.ChildTableTabPanel;

public class TableWithTabbedChildSplitPane
extends JSplitPane {
    private static final int NO_TAB = -1;
    private static final int DEFAULT_TAB = 0;
    private static final int MINIMUM_BOTTOM_SIZE = 38;
    private static final int MINIMUM_TOP_SIZE = 87;
    private static final int DEFAULT_DIVIDER_LOCATION = 250;
    private ChildTableTabPanel.TabSelectedListener m_tabsList;

    public TableWithTabbedChildSplitPane(Component component, ChildTableTabPanel childTableTabPanel) {
        super(0, component, (Component)((Object)childTableTabPanel));
        TableWithTabbedChildSplitPaneUI tableWithTabbedChildSplitPaneUI = new TableWithTabbedChildSplitPaneUI();
        this.setUI(tableWithTabbedChildSplitPaneUI);
        this.setOneTouchExpandable(true);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        final TableWithTabbedChildSplitPaneUI.TableWithTabbedChildDivider tableWithTabbedChildDivider = tableWithTabbedChildSplitPaneUI.getDivider();
        tableWithTabbedChildDivider.setLocation(0, tableWithTabbedChildDivider.getMinimumLocation());
        this.m_tabsList = new ChildTableTabPanel.TabSelectedListener(){

            @Override
            public void tabSelected() {
                if (tableWithTabbedChildDivider.isTableExpanded()) {
                    tableWithTabbedChildDivider.getContractTableButton().doClick();
                }
            }
        };
        childTableTabPanel.addTabSelectedListener(this.m_tabsList);
        childTableTabPanel.setMinimumSize(new Dimension(0, 0));
        childTableTabPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = componentEvent.getComponent().getSize();
                if (dimension.getHeight() == 0.0) {
                    TableWithTabbedChildSplitPane.this.setDividerLocation(tableWithTabbedChildDivider.getMinimumLocation());
                    TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(-1);
                    tableWithTabbedChildDivider.getContractTableButton().setEnabled(true);
                    tableWithTabbedChildDivider.m_isTableExpanded = true;
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                tableWithTabbedChildDivider.preserveLocation();
            }
        });
        component.setMinimumSize(new Dimension(0, 0));
    }

    @Override
    public TableWithTabbedChildSplitPaneUI getUI() {
        return (TableWithTabbedChildSplitPaneUI)super.getUI();
    }

    private void selectTabWithDefaultIndex(int n) {
        ChildTableTabPanel childTableTabPanel = (ChildTableTabPanel)((Object)this.getBottomComponent());
        childTableTabPanel.removeTabSelectedListener(this.m_tabsList);
        childTableTabPanel.selectDefaultTab(n);
        childTableTabPanel.addTabSelectedListener(this.m_tabsList);
    }

    public class TableWithTabbedChildSplitPaneUI
    extends BasicSplitPaneUI {
        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new TableWithTabbedChildDivider(this);
        }

        @Override
        public TableWithTabbedChildDivider getDivider() {
            return (TableWithTabbedChildDivider)super.getDivider();
        }

        public class TableWithTabbedChildDivider
        extends BasicSplitPaneDivider {
            boolean m_isTableExpanded;
            boolean m_dragging;
            int m_splitLocation;

            TableWithTabbedChildDivider(BasicSplitPaneUI basicSplitPaneUI) {
                super(basicSplitPaneUI);
                this.m_isTableExpanded = true;
                this.m_dragging = false;
                this.m_splitLocation = 250;
            }

            @Override
            protected void oneTouchExpandableChanged() {
                if (!UIManager.getBoolean("SplitPane.supportsOneTouchButtons", this.splitPane.getLocale())) {
                    return;
                }
                if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
                    DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("TableWithTabbedChildSplitPane");
                    this.leftButton = this.createLeftOneTouchButton();
                    dBUIResourceHelper.setName(this.leftButton, "leftButton");
                    if (this.leftButton != null) {
                        this.leftButton.addActionListener(new CustomOneTouchActionHandler(true));
                    }
                    this.rightButton = this.createRightOneTouchButton();
                    dBUIResourceHelper.setName(this.rightButton, "rightButton");
                    if (this.rightButton != null) {
                        this.rightButton.addActionListener(new CustomOneTouchActionHandler(false));
                    }
                    if (this.leftButton != null && this.rightButton != null) {
                        this.add(this.leftButton);
                        this.add(this.rightButton);
                    }
                }
                this.doRevalidate();
            }

            public void preserveLocation() {
                if (this.m_isTableExpanded) {
                    this.splitPane.setDividerLocation(this.getMinimumLocation());
                }
            }

            public int getMinimumLocation() {
                return this.splitPane.getHeight() - 38;
            }

            private int getSplitLocation() {
                return this.m_splitLocation;
            }

            private void setSplitLocation(int n) {
                boolean bl = false;
                int n2 = n;
                if (this.m_dragging) {
                    if (n < 87) {
                        n2 = 87;
                        bl = true;
                    } else if (n > 250 && n < this.getMinimumLocation()) {
                        if (!this.m_isTableExpanded) {
                            n2 = this.getMinimumLocation();
                        } else {
                            n2 = 250;
                            bl = true;
                        }
                    } else if (n >= this.getMinimumLocation()) {
                        n2 = this.getMinimumLocation();
                    } else if (this.m_isTableExpanded) {
                        bl = true;
                    }
                    if (this.m_isTableExpanded && bl) {
                        this.m_isTableExpanded = false;
                        TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(0);
                        this.enableButtons(true, false);
                    } else if (!this.m_isTableExpanded && n2 == this.getMinimumLocation()) {
                        this.m_isTableExpanded = true;
                        TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(-1);
                        this.enableButtons(false, true);
                    }
                    this.m_splitLocation = n2 != this.getMinimumLocation() ? n2 : 250;
                }
                this.m_dragging = false;
                this.splitPane.setDividerLocation(n2);
            }

            @Override
            protected void finishDraggingTo(int n) {
                super.finishDraggingTo(n);
                this.m_dragging = true;
                this.setSplitLocation(n);
            }

            private void doRevalidate() {
                this.invalidate();
                if (this.splitPane != null) {
                    this.splitPane.revalidate();
                }
            }

            private JButton getContractTableButton() {
                return this.leftButton;
            }

            private boolean isTableExpanded() {
                return this.m_isTableExpanded;
            }

            private void enableButtons(boolean bl, boolean bl2) {
                this.leftButton.setEnabled(bl);
                this.leftButton.setEnabled(bl2);
            }

            private class CustomOneTouchActionHandler
            implements ActionListener {
                private final boolean isLeft;

                CustomOneTouchActionHandler(boolean bl) {
                    this.isLeft = bl;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TableWithTabbedChildDivider.this.splitPane.getDividerLocation();
                    int n2 = TableWithTabbedChildDivider.this.getSplitLocation();
                    int n3 = TableWithTabbedChildDivider.this.getMinimumLocation();
                    int n4 = n;
                    if (this.isLeft) {
                        n4 = n2;
                        TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(0);
                        TableWithTabbedChildDivider.this.enableButtons(true, false);
                        TableWithTabbedChildDivider.this.m_isTableExpanded = false;
                    } else {
                        n4 = n3;
                        TableWithTabbedChildDivider.this.m_isTableExpanded = true;
                        TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(-1);
                        TableWithTabbedChildDivider.this.enableButtons(false, true);
                    }
                    TableWithTabbedChildDivider.this.splitPane.setDividerLocation(n4);
                }
            }
        }
    }
}

