/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.mview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.property.PropertyHelper;

public class MViewRefreshOptionsPanel
extends BaseEditorPanel<MaterializedView> {
    private final PropertyEnablingHandler m_peh = new PropertyEnablingHandler();

    public MViewRefreshOptionsPanel() {
        this.m_peh.register("firstRefresh", null);
        this.m_peh.register("interval", null);
        this.m_peh.register("refreshMethod", null);
        this.m_peh.register("keyType", null);
        this.m_peh.register("rollbackSegmentType", null);
        this.m_peh.register("rollbackSegmentName", null);
        this.m_peh.register("usingConstraints", MaterializedView.UsingConstraints.ENFORCED);
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("refreshMode");
        dBUILayoutHelper.add(componentWrapper);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper("firstRefresh");
        dBUILayoutHelper.add(componentWrapper2.getLabel());
        dBUILayoutHelper.indent(componentWrapper2.getLabel());
        dBUILayoutHelper.add(componentWrapper2.getComponent(), 1, 1, true, false);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper3 = this.getOrCreateWrapper("interval");
        dBUILayoutHelper.add(componentWrapper3.getLabel());
        dBUILayoutHelper.indent(componentWrapper3.getLabel());
        dBUILayoutHelper.add(componentWrapper3.getComponent(), 1, 1, true, false);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper4 = this.getOrCreateWrapper("refreshMethod");
        dBUILayoutHelper.add(componentWrapper4);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper5 = this.getOrCreateWrapper("keyType");
        dBUILayoutHelper.add(componentWrapper5);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper6 = this.getOrCreateWrapper("rollbackSegmentType");
        dBUILayoutHelper.add(componentWrapper6);
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper7 = this.getOrCreateWrapper("rollbackSegmentName");
        dBUILayoutHelper.add(componentWrapper7.getLabel());
        dBUILayoutHelper.add((Component)componentWrapper7.getActiveComponent(), 1, 1, true, false);
        dBUILayoutHelper.indent(componentWrapper7.getLabel());
        dBUILayoutHelper.nextRow();
        ComponentWrapper componentWrapper8 = this.getOrCreateWrapper("usingConstraints");
        dBUILayoutHelper.add(componentWrapper8);
        dBUILayoutHelper.nextRowWithGap();
        if (this.getProvider() instanceof Database && this.isEditing()) {
            ComponentWrapper componentWrapper9 = this.getOrCreateWrapper("lastRefreshDate");
            ComponentWrapper componentWrapper10 = this.getOrCreateWrapper("nextRefreshDate");
            ComponentWrapper componentWrapper11 = this.getOrCreateWrapper("staleness");
            DBUILayoutHelper dBUILayoutHelper2 = dBUILayoutHelper.newTitledHelper(UIBundle.get("MVIEW_REFRESH_STATE_TITLE"), 2, 1, true, false);
            dBUILayoutHelper2.add(componentWrapper9);
            dBUILayoutHelper2.nextRow();
            dBUILayoutHelper2.add(componentWrapper10);
            dBUILayoutHelper2.nextRow();
            dBUILayoutHelper2.add(componentWrapper11);
            componentWrapper9.setReadOnly(true);
            componentWrapper10.setReadOnly(true);
            componentWrapper11.setReadOnly(true);
        } else {
            Object var10_11 = null;
            Object var11_13 = null;
            Object var12_15 = null;
        }
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
    }

    @Override
    protected void initialisePanel() {
        this.enableComponents(false);
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"refreshMode", "rollbackSegmentType"}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getOldValue() != propertyChangeEvent.getNewValue()) {
                    MViewRefreshOptionsPanel.this.enableComponents(true);
                }
            }
        };
    }

    private void enableComponents(boolean bl) {
        MaterializedView materializedView = (MaterializedView)this.getUpdatedObject();
        MaterializedView.RefreshMode refreshMode = materializedView.getRefreshMode();
        this.enable(refreshMode != MaterializedView.RefreshMode.NEVER, bl, "refreshMethod", "keyType", "rollbackSegmentType", "usingConstraints");
        this.enable(refreshMode == MaterializedView.RefreshMode.SPECIFY, bl, "firstRefresh", "interval");
        MaterializedView.RollbackSegmentType rollbackSegmentType = materializedView.getRollbackSegmentType();
        this.enable(refreshMode != MaterializedView.RefreshMode.NEVER && rollbackSegmentType != null, bl, "rollbackSegmentName");
    }

    private void enable(boolean bl, boolean bl2, String ... stringArray) {
        for (String string : stringArray) {
            this.m_peh.setPropertyEnabled(string, bl, bl2);
        }
    }

    private final class PropertyEnablingHandler {
        private final List<String> m_props = new ArrayList<String>();
        private final List<Object> m_default = new ArrayList<Object>();
        private final List<Object> m_cached = new ArrayList<Object>();

        private PropertyEnablingHandler() {
        }

        public void register(String string, Object object) {
            if (this.m_props.contains(string)) {
                throw new IllegalArgumentException("Property " + string + " already registered.");
            }
            this.m_props.add(string);
            this.m_default.add(object);
            this.m_cached.add(object);
        }

        public void setPropertyEnabled(String string, boolean bl, boolean bl2) {
            if (!this.m_props.contains(string)) {
                throw new IllegalArgumentException("Property " + string + " not registered.");
            }
            ComponentWrapper componentWrapper = MViewRefreshOptionsPanel.this.getComponentFactory().findComponentWrapper(string);
            if (componentWrapper != null && ((Component)componentWrapper.getActiveComponent()).isEnabled() != bl) {
                componentWrapper.setEnabled(bl);
                if (bl2) {
                    PropertyHelper propertyHelper = MViewRefreshOptionsPanel.this.getPropertyHelper();
                    DBObject dBObject = MViewRefreshOptionsPanel.this.getUpdatedObject();
                    if (bl) {
                        Object object = this.m_cached.get(this.m_props.indexOf(string));
                        propertyHelper.setPropertyValue((Object)dBObject, string, object);
                        componentWrapper.setPropertyValue(object);
                    } else {
                        Object object = propertyHelper.getPropertyValue((Object)dBObject, string);
                        int n = this.m_props.indexOf(string);
                        this.m_cached.set(n, object);
                        propertyHelper.setPropertyValue((Object)dBObject, string, this.m_default.get(n));
                        componentWrapper.setPropertyValue(this.m_default.get(n));
                    }
                }
            }
        }
    }
}

