/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

public abstract class OraclePartitionsHandler {
    static OraclePartitionsHandler create(DBObject dBObject) {
        if (dBObject instanceof TablePartition) {
            dBObject = OraclePartitionsHandler.getOwningTable(dBObject);
        }
        if (dBObject instanceof Table) {
            dBObject = (OracleTablePartitions)dBObject.getProperty("OracleTablePartitions");
        }
        if (dBObject instanceof IndexPartition) {
            dBObject = dBObject.getParent();
        }
        if (dBObject instanceof Index) {
            dBObject = (OracleIndexPartitions)dBObject.getProperty("OracleIndexPartitions");
        }
        if (dBObject instanceof OracleTablePartitions) {
            return new OracleTablePartitionsHandler((OracleTablePartitions)dBObject);
        }
        if (dBObject instanceof OracleIndexPartitions) {
            return new OracleIndexPartitionsHandler((OracleIndexPartitions)dBObject);
        }
        throw new IllegalArgumentException("Cannot retrieve a partioning object from " + dBObject);
    }

    public abstract void setHashQuantity(Integer var1);

    public abstract void setPartitions(DBObject[] var1);

    public abstract Integer getHashQuantity();

    public abstract DBObject[] getPartitions();

    public static Table getOwningTable(DBObject dBObject) {
        if (dBObject instanceof Table || dBObject == null) {
            return (Table)dBObject;
        }
        return OraclePartitionsHandler.getOwningTable(dBObject.getParent());
    }

    private static class OracleIndexPartitionsHandler
    extends OraclePartitionsHandler {
        private final OracleIndexPartitions m_oip;

        private OracleIndexPartitionsHandler(OracleIndexPartitions oracleIndexPartitions) {
            this.m_oip = oracleIndexPartitions;
        }

        @Override
        public Integer getHashQuantity() {
            return this.m_oip.getGlobalHashQuantity();
        }

        @Override
        public void setHashQuantity(Integer n) {
            this.m_oip.setGlobalHashQuantity(n);
        }

        @Override
        public DBObject[] getPartitions() {
            return this.m_oip.getPartitions();
        }

        @Override
        public void setPartitions(DBObject[] dBObjectArray) {
            this.m_oip.setPartitions((IndexPartition[])dBObjectArray);
        }
    }

    private static class OracleTablePartitionsHandler
    extends OraclePartitionsHandler {
        private final OracleTablePartitions m_otp;

        private OracleTablePartitionsHandler(OracleTablePartitions oracleTablePartitions) {
            this.m_otp = oracleTablePartitions;
        }

        @Override
        public Integer getHashQuantity() {
            return this.m_otp.getHashQuantity();
        }

        @Override
        public void setHashQuantity(Integer n) {
            this.m_otp.setHashQuantity(n);
        }

        @Override
        public DBObject[] getPartitions() {
            return this.m_otp.getPartitions();
        }

        @Override
        public void setPartitions(DBObject[] dBObjectArray) {
            this.m_otp.setPartitions((TablePartition[])dBObjectArray);
        }
    }
}

