/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.CardLayout;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.Type;

public class OracleColumnPropertiesPanel
extends ChildObjectEditorPanel<OracleColumnProperties, Relation> {
    private static final String NONE = "NONE";
    private final CardLayout m_layout = new CardLayout();

    public OracleColumnPropertiesPanel() {
        super("OracleColumnPropertiesPanel", null, true);
    }

    @Override
    public void initialiseChildComponents() {
        this.setLayout(this.m_layout);
        JPanel jPanel = new JPanel();
        this.add(jPanel, NONE);
        if (this.isInFlatEditor()) {
            DBUILayoutHelper.makeTransparentForFlatEditor((JComponent)((Object)this));
        }
    }

    @Override
    public void initialisePanel() {
        super.initialisePanel();
        this.handleVisibility();
    }

    private void handleVisibility() {
        Column column = (Column)this.getComponentFactoryUpdatedObject();
        String string = null;
        boolean bl = OracleColumnPropertiesPanel.isXMLTypeColumn(column);
        string = this.changeKey(string, "XMLTypeColumnProperties", bl);
        boolean bl2 = OracleColumnPropertiesPanel.isNestedTableColumn(column);
        string = this.changeKey(string, "nestedTableProperties", bl2);
        boolean bl3 = OracleColumnPropertiesPanel.isLobColumn(column);
        string = this.changeKey(string, "LOBProperties", bl3);
        boolean bl4 = OracleColumnPropertiesPanel.isVarrayColumn(column);
        if ((string = this.changeKey(string, "VAProperties", bl4)) == null) {
            string = NONE;
        }
        this.m_layout.show((Container)((Object)this), string);
    }

    private String changeKey(String string, String string2, boolean bl) {
        if (bl) {
            if (string != null) {
                DBLog.getLogger((Object)this).severe(string2 + " but already have " + string);
            } else {
                string = string2;
                if (this.getComponentFactory().findComponentWrapper(string) == null) {
                    this.createPanel(string);
                }
            }
        }
        return string;
    }

    private void createPanel(String string) {
        JPanel jPanel = new JPanel();
        this.add(jPanel, string);
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel, this.isInFlatEditor());
        dBUILayoutHelper.setMargins(0);
        dBUILayoutHelper.add(this.getOrCreateWrapper(string).getComponent());
        dBUILayoutHelper.layout();
    }

    private static boolean isLobColumn(Column column) {
        return LOBDescriptor.isLOBColumn((Column)column);
    }

    public static boolean isVarrayColumn(Column column) {
        return LOBDescriptor.isVARRAYColumn((Column)column);
    }

    public static boolean isXMLTypeColumn(Column column) {
        boolean bl = false;
        if (column != null) {
            DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
            DataType dataType = null;
            Type type = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
            }
            catch (DBException dBException) {
                DBLog.getLogger(OracleColumnPropertiesPanel.class).warning(dBException.getMessage());
            }
            if (dataType instanceof Type && XMLTypeColumnProperties.isXMLType((DataType)(type = (Type)dataType))) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isNestedTableColumn(Column column) {
        boolean bl = false;
        if (column != null) {
            PlSqlSearch plSqlSearch;
            DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
            DataType dataType = null;
            Type type = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
            }
            catch (DBException dBException) {
                DBLog.getLogger(OracleColumnPropertiesPanel.class).warning(dBException.getMessage());
            }
            if (dataType instanceof Type && (plSqlSearch = new PlSqlSearch("[create [ or replace] ] type ?. [oid ?] {is|as} table of")).matches((type = (Type)dataType).getSource())) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean showColumnProperties(Column column) {
        boolean bl = false;
        if (column != null) {
            bl = OracleColumnPropertiesPanel.isLobColumn(column) || OracleColumnPropertiesPanel.isVarrayColumn(column) || OracleColumnPropertiesPanel.isXMLTypeColumn(column) || OracleColumnPropertiesPanel.isNestedTableColumn(column);
        }
        return bl;
    }
}

