/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.json.JSONStreamsProvider;
import oracle.dbtools.plugin.api.json.JSONToken;

public abstract class JSONParser {
    public static IllegalStateException eof(CharSequence ... expected) {
        return JSONParser.error("EOF", expected);
    }

    public static IllegalStateException error(CharSequence actual, CharSequence ... expected) {
        StringBuilder b = new StringBuilder("Expected one of: <<");
        for (int i = 0; i < expected.length; ++i) {
            b.append(expected[i]);
            if (i >= expected.length - 1) continue;
            b.append(",");
        }
        b.append(">> but got: <<");
        b.append(actual);
        b.append(">>");
        return new IllegalStateException(b.toString());
    }

    public static Iterator<JSONToken> read(InputStream content) throws IOException {
        return JSONParser.read(Text.reader((InputStream)content));
    }

    public static Iterator<JSONToken> read(Reader content) throws IOException {
        return new JSONStreamsProvider().jsonReader(content);
    }
}

