/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.json.JSONParserImpl;
import oracle.dbtools.plugin.api.json.JSONReader;
import oracle.dbtools.plugin.api.json.JSONToken;

public class JSONReaderImpl
extends AbstractIterator<JSONToken>
implements JSONReader {
    private final JSONParserImpl parser;
    private final Readable stream;

    public JSONReaderImpl(Readable stream) {
        this.stream = stream;
        this.parser = new JSONParserImpl(this.reader(stream));
    }

    public void close() throws IOException {
        if (this.stream instanceof Closeable) {
            ((Closeable)((Object)this.stream)).close();
        }
    }

    protected JSONToken advance() {
        return this.parser.next();
    }

    private Reader reader(Readable stream) {
        if (stream instanceof Reader) {
            return (Reader)stream;
        }
        return new ReadableReader(stream);
    }

    private static final class ReadableReader
    extends Reader {
        private final Readable stream;

        private ReadableReader(Readable stream) {
            this.stream = stream;
        }

        @Override
        public void close() throws IOException {
            if (this.stream instanceof Closeable) {
                ((Closeable)((Object)this.stream)).close();
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            CharBuffer buf = CharBuffer.wrap(cbuf, off, len);
            return this.stream.read(buf);
        }
    }
}

