/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

public class JSONValue<T> {
    private final Type type;
    private final Object value;

    public JSONValue(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONValue other = (JSONValue)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JSONValue [type=");
        builder.append((Object)this.type);
        builder.append(", value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }

    public Type type() {
        return this.type;
    }

    public T value() {
        return (T)this.value;
    }

    public static enum Type {
        FALSE,
        NODE,
        NULL,
        NUMBER,
        STRING,
        TRUE;

    }
}

