/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.help.HelpUtils;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.help.AbstractRSSQueryHandler;
import oracle.jdevimpl.help.HelpSearchResult;
import oracle.jdevimpl.help.OTNSearchResult;

public class OTNQueryHandler
extends AbstractRSSQueryHandler {
    private static final String DEFAULT_SEARCH_URL = "http://search.oracle.com/search/feed";
    private static final String OTN_SEARCH_URL_MACRO = "${OTN_SEARCH_URL}";
    private static final String OTN_SEARCH_PARAMS_MACRO = "${OTN_SEARCH_PARAMS}";
    private static final String OTN_SEARCH_KEYWORD_PARAM_MACRO = "${OTN_SEARCH_KEYWORD_PARAM)";
    private static final String DEFAULT_KEYWORK_PARAM = "q=";

    protected String createQueryString(String searchText) {
        String params;
        String keywordParam = HelpUtils.substituteMacros((String)OTN_SEARCH_KEYWORD_PARAM_MACRO);
        if (keywordParam.equals(OTN_SEARCH_KEYWORD_PARAM_MACRO)) {
            keywordParam = DEFAULT_KEYWORK_PARAM;
        }
        if ((params = HelpUtils.substituteMacros((String)OTN_SEARCH_PARAMS_MACRO)).equals(OTN_SEARCH_PARAMS_MACRO)) {
            params = "&output=rss&num=200&group=Technology Network";
        }
        String queryString = keywordParam + searchText + params;
        return this.htmlEncodeString(queryString);
    }

    @Override
    protected List<URL> createSearchURLs(String searchText) {
        ArrayList<URL> urlList = new ArrayList<URL>(1);
        String urlString = HelpUtils.substituteMacros((String)OTN_SEARCH_URL_MACRO);
        if (urlString.equals(OTN_SEARCH_URL_MACRO)) {
            urlString = DEFAULT_SEARCH_URL;
        }
        try {
            URL url = new URL(urlString);
            url = URLFactory.replaceQueryPart((URL)url, (String)this.createQueryString(searchText));
            urlList.add(url);
        }
        catch (MalformedURLException muex) {
            muex.printStackTrace();
        }
        return urlList;
    }

    @Override
    protected HelpSearchResult createSearchResult(String title, String link, String description) {
        return new OTNSearchResult(title, link, description);
    }

    @Override
    protected String getSummaryElement() {
        return "description";
    }
}

