/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.dialogs.RaptorTaskUI;
import oracle.dbtools.raptor.backgroundTask.dialogs.TaskDialog;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.controls.GlassPaneUIBlocker;

public class GlassPaneTaskViewer
extends GlassPaneUIBlocker
implements ITaskViewer,
ActionListener {
    private static final long serialVersionUID = 1L;
    ITaskUI _taskUI;
    JComponent _ui;
    private static int ALPHA = 192;
    private Timer _timer;

    public void addTaskUI(ITaskUI iTaskUI) {
        this.removeAll();
        Component component = iTaskUI.getPanel();
        component.setVisible(false);
        if (component instanceof JComponent) {
            this._ui = (JComponent)component;
            this._ui.setOpaque(false);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)Box.createVerticalBox(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add(component, gridBagConstraints);
    }

    public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        this._taskUI = new RaptorTaskUI(raptorTaskDescriptor){

            @Override
            public void paintComponent(Graphics graphics) {
                Color color = this.getParent().getBackground();
                Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), ALPHA);
                graphics.setColor(color2);
                Rectangle rectangle = graphics.getClipBounds();
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        };
        ((RaptorTaskUI)this._taskUI).setBorder(BorderFactory.createRaisedSoftBevelBorder());
        ((RaptorTaskUI)this._taskUI).setVisible(false);
        raptorTaskDescriptor.addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
                switch (raptorTaskEvent.getTaskDescriptor().getStatus()) {
                    case NEW: {
                        SwingUtilities.invokeLater(() -> {
                            GlassPaneTaskViewer.this.setVisible(true);
                            GlassPaneTaskViewer.this.uiSetVisible(false);
                            GlassPaneTaskViewer.this.getDelayTimer().start();
                        });
                        break;
                    }
                    case FINISHED: 
                    case FAILED: {
                        GlassPaneTaskViewer.this.stopDelayTimer();
                        SwingUtilities.invokeLater(() -> GlassPaneTaskViewer.this.setVisible(false));
                        break;
                    }
                    default: {
                        super.stateChanged(raptorTaskEvent);
                    }
                }
            }
        });
        return this._taskUI;
    }

    public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        return this.createTaskUI(raptorTaskDescriptor);
    }

    public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
        ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
        if (iTaskUI != null) {
            iTaskUI.cancelClicked(raptorTaskDescriptor);
        }
    }

    public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
        ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
        if (iTaskUI != null) {
            iTaskUI.pauseClicked(raptorTaskDescriptor);
        }
    }

    private Timer getDelayTimer() {
        this._timer = new Timer(TaskDialog.DELAY_MS * 2, actionEvent -> SwingUtilities.invokeLater(() -> {
            this.stopDelayTimer();
            this.uiSetVisible(true);
        }));
        return this._timer;
    }

    private void stopDelayTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    private void uiSetVisible(boolean bl) {
        if (this._ui != null) {
            this._ui.setVisible(bl);
        }
    }

    public void removeTaskUI(ITaskUI iTaskUI) {
    }
}

