/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.raptor.utils.SimpleIdeCore;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.ResourceUtils;

public class ShuttlePanel<V>
extends JPanel {
    private static final long serialVersionUID = 2613350618419228420L;
    protected Shuttle shuttle = new Shuttle();
    protected JList lstFrom = null;
    protected JList lstTo = null;
    protected DefaultListModel mdlFrom = null;
    protected DefaultListModel mdlTo = null;
    protected ListPicker pckFrom = null;
    protected ListPicker pckTo = null;
    protected JLabel lblFrom = new JLabel();
    protected JLabel lblTo = new JLabel();
    protected String title;
    protected String fromLabel;
    protected String toLabel;

    public ShuttlePanel(String string, String string2, String string3) {
        try {
            this.title = string;
            this.fromLabel = string2;
            this.toLabel = string3;
            this.initListPickers();
            this.createGUI();
            this.init(Collections.emptyList());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected void initListPickers() {
        this.mdlFrom = new DefaultListModel();
        this.mdlTo = new DefaultListModel();
        this.lstFrom = new JList();
        this.pckFrom = new ListPicker(this.lstFrom);
        this.lstTo = new JList();
        this.pckTo = new ReorderableListPicker(this.lstTo);
    }

    protected void createGUI() throws Exception {
        this.setLayout(new GridBagLayout());
        this.shuttle.setFromPicker((ItemPicker)this.pckFrom);
        this.shuttle.setToPicker((ItemPicker)this.pckTo);
        this.shuttle.add((Component)this.lblFrom, (Object)"FromHeader");
        this.shuttle.add((Component)this.lblTo, (Object)"ToHeader");
        ResourceUtils.resLabel((JLabel)this.lblFrom, (Component)this.lstFrom, (String)this.fromLabel);
        ResourceUtils.resLabel((JLabel)this.lblTo, (Component)this.lstTo, (String)this.toLabel);
        this.lblFrom.setFont(this.lblFrom.getFont().deriveFont(1));
        this.lblTo.setFont(this.lblTo.getFont().deriveFont(1));
        this.add((Component)this.createInstructions(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.shuttle, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected JTextPane createInstructions() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(this.title);
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        return jTextPane;
    }

    public Shuttle getShuttle() {
        return this.shuttle;
    }

    public void init(List<V> list) {
        this.mdlFrom.removeAllElements();
        this.mdlTo.removeAllElements();
        for (V v : list) {
            this.mdlFrom.addElement(v);
        }
        this.lstFrom.setModel(this.mdlFrom);
        this.lstTo.setModel(this.mdlTo);
        this.lstFrom.setSelectedIndex(0);
        this.shuttle.setEnabled(true);
        this.lstFrom.setEnabled(true);
        this.lstTo.setEnabled(true);
        this.shuttle.validate();
    }

    public void setToListSelectionMode(int n) {
        this.lstTo.setSelectionMode(n);
    }

    public void setFromListSelectionMode(int n) {
        this.lstFrom.setSelectionMode(n);
    }

    public List<V> getFromList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mdlFrom.size(); ++i) {
            arrayList.add(this.mdlFrom.get(i));
        }
        return arrayList;
    }

    public List<V> getToList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mdlTo.size(); ++i) {
            arrayList.add(this.mdlTo.get(i));
        }
        return arrayList;
    }

    public void setFromList(List<V> list) {
        this.mdlFrom.removeAllElements();
        for (V v : list) {
            this.mdlFrom.addElement(v);
        }
    }

    public void setToList(List<V> list) {
        this.mdlTo.removeAllElements();
        for (V v : list) {
            this.mdlTo.addElement(v);
        }
    }

    public void setFromListRenderer(ListCellRenderer listCellRenderer) {
        this.lstFrom.setCellRenderer(listCellRenderer);
    }

    public void setToListRenderer(ListCellRenderer listCellRenderer) {
        this.lstTo.setCellRenderer(listCellRenderer);
    }

    public static void main(String[] stringArray) {
        IdeArgs ideArgs = new IdeArgs();
        SimpleIdeCore simpleIdeCore = new SimpleIdeCore(ideArgs, "oracle.ide");
        Ide.startup((IdeCore)simpleIdeCore);
        System.setSecurityManager(null);
        final ShuttlePanel<Locale> shuttlePanel = new ShuttlePanel<Locale>("this is a sample selector", "frommmmmmm", "tooo");
        Locale.getDefault();
        shuttlePanel.setToList(Arrays.asList(Locale.getAvailableLocales()));
        shuttlePanel.setToListSelectionMode(0);
        shuttlePanel.setToListRenderer(new LocaleRenderer());
        Dimension dimension = shuttlePanel.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
        final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog(shuttlePanel, null, (String)"Locales selector", (int)7);
        jEWTDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
            }
        });
        jEWTDialog.setSize(dimension);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)"Locales selector.dialogSize");
        jEWTDialog.setLocationRelativeTo(null);
        shuttlePanel.getShuttle().addShuttleListener(new ShuttleListener(){

            public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
                jEWTDialog.setOKButtonEnabled(shuttlePanel.getToList().size() > 0);
            }

            public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
                jEWTDialog.setOKButtonEnabled(shuttlePanel.getToList().size() > 0);
            }

            public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
                jEWTDialog.setOKButtonEnabled(shuttlePanel.getToList().size() > 0);
            }
        });
        jEWTDialog.setVisible(true);
        List list = shuttlePanel.getToList();
        for (Locale locale : list) {
            System.out.println(locale);
        }
    }

    private static class LocaleRenderer
    extends DefaultListCellRenderer {
        private LocaleRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Locale locale = (Locale)object;
            this.setText(locale.getDisplayName());
            return this;
        }
    }
}

