/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpSystem;

public class SingleRecordViewPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private RaptorGridTable _table;
    private int _currRow = -1;
    private ArrayList<TableCellEditor> _values = new ArrayList();
    private Toolbar _toolbar;
    private JPanel _panel;
    private TaskListener _taskListener;

    public SingleRecordViewPanel(RaptorGridTable raptorGridTable, int n) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_singlerecordgridview_html");
        this._table = raptorGridTable;
        this.jbInit();
        this.navigateTo(n);
        AbstractRaptorGridModel abstractRaptorGridModel = this._table.getGridModel();
        if (abstractRaptorGridModel != null) {
            this._taskListener = new TaskListener();
            abstractRaptorGridModel.addFetchTaskListener((IRaptorTaskListener)this._taskListener);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this._toolbar = new Toolbar();
        this._toolbar.setFloatable(true);
        this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this._panel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this._panel);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void navigateTo(int n) {
        if (n > -1 && n < this._table.getRowCount()) {
            this._currRow = n;
            this._panel.removeAll();
            this._values.clear();
            for (int i = 0; i < this._table.getColumnCount(); ++i) {
                Dimension dimension;
                Object object;
                Serializable serializable = null;
                String string = this._table.getColumnName(i);
                JLabel jLabel = new JLabel(string);
                Object object2 = this._table.getValueAt(this._currRow, i);
                this._panel.add((Component)jLabel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.1, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
                TableCellEditor tableCellEditor = this._table.getCellEditor(this._currRow, i);
                if (!String.valueOf(object2).startsWith("SQLDEV:LINK")) {
                    Serializable serializable2 = serializable = tableCellEditor != null ? tableCellEditor.getTableCellEditorComponent(this._table, object2, false, this._currRow, i) : null;
                }
                if (null == serializable) {
                    object = this._table.getCellRenderer(this._currRow, i);
                    Serializable serializable3 = dimension = null == object ? null : object.getTableCellRendererComponent(this._table, object2, false, false, this._currRow, i);
                    serializable = dimension instanceof JTextComponent ? new JTextField(((JTextComponent)((Object)dimension)).getText()) : (dimension instanceof JLabel ? new JLabel(((JLabel)((Object)dimension)).getText()) : dimension);
                } else {
                    this._values.add(tableCellEditor);
                }
                if (serializable != null) {
                    object = ((Component)serializable).getMinimumSize();
                    dimension = ((Component)serializable).getPreferredSize();
                    int n2 = 20;
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        n2 = graphics.getFontMetrics(((Component)serializable).getFont()).getHeight() + 2;
                    }
                    if (((Dimension)object).height < n2) {
                        ((Dimension)object).height = n2;
                    }
                    ((Component)serializable).setPreferredSize((Dimension)object);
                } else {
                    serializable = new JTextField(object2 != null ? object2.toString() : "");
                }
                this._panel.add((Component)serializable, new GridBagConstraints(1, i, 1, 1, 1.0, 0.1, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
            }
            if (this.getGraphics() != null) {
                this.paintAll(this.getGraphics());
            }
            this._table.setColumnSelectionAllowed(false);
            this._table.setRowSelectionAllowed(true);
            this._table.getSelectionModel().setSelectionInterval(n, n);
            this._table.scrollRectToVisible(this._table.getCellRect(n, 0, true));
        }
    }

    public int getCurrentRow() {
        return this._currRow;
    }

    public void next() {
        this.save();
        this.navigateTo(this._currRow + 1);
    }

    public void prev() {
        this.save();
        this.navigateTo(this._currRow - 1);
    }

    public void first() {
        this.save();
        this.navigateTo(0);
    }

    public void last() {
        if (this._table.allRowsFetched()) {
            this.save();
            this.navigateTo(this._table.getRowCount() - 1);
        } else {
            this.save();
            AbstractRaptorGridModel abstractRaptorGridModel = this._table.getGridModel();
            this._currRow = abstractRaptorGridModel != null ? abstractRaptorGridModel.getTotalRows(false) - 1 : this._table.getRowCount() - 1;
            this._table.getValueAt(this._currRow, 0);
        }
    }

    public void save() {
        if (this._currRow > -1 && this._table.isEditable()) {
            Object object = null;
            for (int i = 0; i < this._values.size(); ++i) {
                TableCellEditor tableCellEditor = this._values.get(i);
                object = tableCellEditor.getCellEditorValue();
                this._table.setValueAt(object, this._currRow, i);
            }
        }
    }

    public JTextComponent findTextComp(Component component) {
        Component[] componentArray;
        int n;
        int n2;
        if (component instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        if (component instanceof Container && (n2 = 0) < (n = (componentArray = ((Container)component).getComponents()).length)) {
            Component component2 = componentArray[n2];
            return this.findTextComp(component2);
        }
        return null;
    }

    public Toolbar getToolBar() {
        return this._toolbar;
    }

    private void updateToolbarActions(boolean bl) {
        if (this.isVisible()) {
            Action[] actionArray;
            for (Action action : actionArray = this._toolbar.getActions()) {
                action.setEnabled(bl);
            }
        }
    }

    void removeTaskListener() {
        AbstractRaptorGridModel abstractRaptorGridModel = this._table.getGridModel();
        if (abstractRaptorGridModel != null && this._taskListener != null) {
            abstractRaptorGridModel.removeFetchTaskListener((IRaptorTaskListener)this._taskListener);
        }
    }

    private class TaskListener
    extends RaptorTaskAdapter {
        private TaskListener() {
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SingleRecordViewPanel.this.updateToolbarActions(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SingleRecordViewPanel.this.updateToolbarActions(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SingleRecordViewPanel.this.updateToolbarActions(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SingleRecordViewPanel.this.updateToolbarActions(true);
                    SingleRecordViewPanel.this.navigateTo(SingleRecordViewPanel.this._currRow);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

