/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.directory.Attribute;
import oracle.dbtools.raptor.utils.LDAPHelper;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.util.Logger;

public class LDAPAlias {
    private String m_ldapServer;
    private String m_urlString;
    private String m_aliasName;
    private TCPTNSEntry m_entry = null;
    private String m_genName;
    private int m_scope;

    public LDAPAlias(String string, String string2, String string3, String string4, int n) {
        this.m_ldapServer = string2;
        this.m_urlString = string3;
        this.m_aliasName = string4;
        this.m_genName = string;
        this.m_scope = n;
    }

    public LDAPAlias(TCPTNSEntry tCPTNSEntry) {
        if (tCPTNSEntry == null) {
            Logger.warn(this.getClass(), (String)"entry==null");
        }
        this.m_entry = tCPTNSEntry;
    }

    public TCPTNSEntry calculateTCPTNSEntry() {
        if (this.m_entry == null) {
            try {
                String string;
                Attribute attribute = LDAPHelper.getAliasDescription(this.m_ldapServer, this.m_aliasName, this.generateEnv(this.m_urlString), new HashSet<String>(), this.m_scope);
                if (attribute != null && attribute.get() != null && (string = attribute.get().toString()) != null) {
                    this.m_entry = new TCPTNSEntry(this.m_genName, string);
                }
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (String)("calculateTCPTNSEntry():" + exception.getMessage()));
            }
            return this.m_entry;
        }
        return this.m_entry;
    }

    private Hashtable<String, String> generateEnv(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        hashtable.put("java.naming.ldap.derefAliases", "never");
        return hashtable;
    }
}

