/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.view;

import oracle.ide.docking.BaseDockableFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.view.View;

public abstract class AbstractDockableFactory
implements BaseDockableFactory {
    protected abstract DockableView getDockableImpl();

    protected abstract ViewId getDefaultViewId();

    protected DockingParam createDockingParam() {
        DockingParam dockingParam = new DockingParam();
        Dockable dockable = this.findWindowToDockWith();
        if (dockable != null) {
            dockingParam.setPosition(dockable, 4, 0);
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable2 = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable2 = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable2, 2, 0);
        }
        return dockingParam;
    }

    protected final Dockable findWindowToDockWith() {
        NavigatorManager navigatorManager = NavigatorManager.getApplicationNavigatorManager();
        if (navigatorManager == null) {
            navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        }
        return navigatorManager != null ? navigatorManager.getNavigatorWindow() : null;
    }

    public final Dockable getDockable(ViewId viewId) {
        DockableView dockableView;
        DockStation dockStation = DockStation.getDockStation();
        if (dockStation.getDockableStatus((Dockable)(dockableView = this.getDockableImpl())) == 0) {
            DockingParam dockingParam = this.createDockingParam();
            dockStation.dock((Dockable)dockableView, dockingParam);
        }
        return dockableView;
    }

    public final View lookupView(ViewId viewId) {
        return viewId != null && viewId.equals((Object)this.getDefaultViewId()) ? this.getDockableImpl() : null;
    }

    public final void install() {
        DockableView dockableView = this.getDockableImpl();
        if (dockableView == null) {
            return;
        }
        DockingParam dockingParam = this.createDockingParam();
        DockStation.getDockStation().dock((Dockable)dockableView, dockingParam);
    }
}

