/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbactions.NbViewController;
import com.oracle.jdeveloper.nbwindowsystem.JDevTopComponent;
import com.oracle.jdeveloper.nbwindowsystem.NbDockableContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.NodeFactory;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.TopComponent;

public final class NbView
extends View {
    private final TopComponent tc;
    private Controller controller;
    private static final Map<TopComponent, WeakReference<View>> cache = new WeakHashMap<TopComponent, WeakReference<View>>(20);
    private Lookup.Result<Node> nodeResult;
    private LookupListener nodeListener;

    public NbView(TopComponent tc) {
        this.tc = tc;
        if (!(tc instanceof JDevTopComponent)) {
            tc.putClientProperty((Object)"print.printable", (Object)Boolean.TRUE);
        }
    }

    NbView(NbDockableContainer tc) {
        super(tc.getViewId());
        this.tc = tc;
    }

    public Component getGUI() {
        if (this.tc instanceof NbDockableContainer) {
            return ((NbDockableContainer)this.tc).getGUI();
        }
        return this.tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static View toView(TopComponent tc) {
        NbEditorContainer ec;
        if (null == tc) {
            return null;
        }
        if (tc instanceof NbDockableContainer) {
            return ((NbDockableContainer)tc).getView();
        }
        if (tc instanceof NbEditorContainer && (ec = (NbEditorContainer)tc).getEditor() != null) {
            return ec.getEditor();
        }
        Map<TopComponent, WeakReference<View>> map = cache;
        synchronized (map) {
            View view;
            WeakReference<View> ref = cache.get(tc);
            View view2 = view = ref != null ? (View)ref.get() : null;
            if (view == null) {
                view = new NbView(tc);
                cache.put(tc, new WeakReference<View>(view));
            }
            return view;
        }
    }

    private void watchSelection(boolean watch) {
        if (watch && this.nodeResult == null && this.nodeListener == null) {
            this.nodeResult = this.tc.getLookup().lookupResult(Node.class);
            this.nodeListener = new LookupListener(){

                public void resultChanged(LookupEvent le) {
                    NbView.this.fireViewSelectionChanged(new ViewSelectionEvent((View)NbView.this));
                }
            };
            this.nodeResult.addLookupListener(this.nodeListener);
        } else if (!watch && this.nodeResult != null && this.nodeListener != null) {
            this.nodeResult.removeLookupListener(this.nodeListener);
            this.nodeResult = null;
            this.nodeListener = null;
        }
    }

    public void activate() {
        this.tc.requestActive();
        this.watchSelection(true);
    }

    public void deactivate() {
        this.watchSelection(false);
    }

    public Context getContext(EventObject event) {
        Context ctx = super.getContext(event);
        Lookup lookup = this.tc.getLookup();
        ctx.setProperty(Lookup.class.getName(), (Object)lookup);
        DataObject dobj = (DataObject)lookup.lookup(DataObject.class);
        if (dobj != null) {
            try {
                ctx.setNode(NodeFactory.findOrCreate((URL)dobj.getPrimaryFile().getURL()));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return ctx;
    }

    public Controller getController() {
        if (this.controller == null) {
            this.controller = NbViewController.createController((View)this);
        }
        return this.controller;
    }

    public HelpInfo getHelpInfo() {
        HelpCtx ctx;
        if (!(this.tc instanceof JDevTopComponent) && null != (ctx = this.tc.getHelpCtx()) && !HelpCtx.DEFAULT_HELP.equals((Object)ctx)) {
            return new HelpInfo(ctx.getHelpID());
        }
        return super.getHelpInfo();
    }

    public void close() {
        this.tc.close();
    }

    public String getTabName() {
        String res = this.tc.getDisplayName();
        if (null == res) {
            res = this.tc.getName();
        }
        return res;
    }

    public boolean isVisible() {
        return this.tc.isVisible();
    }

    public void show() {
        if (!this.tc.isOpened()) {
            this.tc.open();
        }
        this.tc.requestVisible();
    }

    public void updateTitle(Object obj) {
        if (null != obj) {
            this.tc.setDisplayName(obj.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NbView other = (NbView)((Object)obj);
        return this.tc == other.tc || this.tc != null && this.tc.equals(other.tc);
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (this.tc != null ? this.tc.hashCode() : 0);
        return hash;
    }
}

