/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import com.oracle.jdeveloper.nbwindowsystem.plaf.OracleEditorTabCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Themes;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ScrollingTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;

public final class OracleEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static Map<Integer, String[]> buttonIconPaths;
    static final String IMAGE_PREFIX = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/";
    private TabControlButton btnScrollLeft;
    private TabControlButton btnScrollRight;
    private TabControlButton btnDropDown;
    private DefaultTabLayoutModel wrappedModel;
    private final ChangeListener modelListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            OracleEditorTabDisplayerUI.this.displayer.invalidate();
            OracleEditorTabDisplayerUI.this.displayer.revalidate();
            OracleEditorTabDisplayerUI.this.displayer.repaint();
        }
    };

    public OracleEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    protected void install() {
        super.install();
        this.displayer.getModel().addChangeListener(this.modelListener);
    }

    protected void uninstall() {
        this.displayer.getModel().removeChangeListener(this.modelListener);
        super.uninstall();
    }

    protected TabLayoutModel createLayoutModel() {
        this.wrappedModel = new DefaultTabLayoutModel(this.displayer.getModel(), (JComponent)this.displayer);
        return new ScrollingTabLayoutModel((TabLayoutModel)this.wrappedModel, this.selectionModel, this.displayer.getModel());
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new OracleEditorTabCellRenderer();
    }

    public static ComponentUI createUI(JComponent c) {
        return new OracleEditorTabDisplayerUI((TabDisplayer)c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(80, 24);
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    private boolean mustShowScrollButtons() {
        TabDataModel dataModel = this.displayer.getModel();
        if (dataModel.size() == 0) {
            return false;
        }
        int realWidth = this.wrappedModel.getX(dataModel.size() - 1) + this.wrappedModel.getW(dataModel.size() - 1);
        int displayerWidth = this.displayer.getWidth();
        return displayerWidth > 0 && realWidth >= displayerWidth - 6 - 16;
    }

    public void makeTabVisible(int index) {
        super.makeTabVisible(index);
        if (!this.mustShowScrollButtons()) {
            this.scroll().setOffset(-1);
        }
    }

    public Insets getTabAreaInsets() {
        int buttonCount = this.mustShowScrollButtons() ? 3 : 1;
        return new Insets(0, 0, 0, buttonCount * 22);
    }

    protected void installControlButtons() {
        Action a;
        if (null == this.btnScrollLeft) {
            a = this.scroll().getBackwardAction();
            a.putValue("control", this.displayer);
            this.btnScrollLeft = TabControlButtonFactory.createScrollLeftButton((TabDisplayer)this.displayer, (Action)a, (boolean)false);
        }
        this.displayer.add((Component)this.btnScrollLeft);
        if (null == this.btnScrollRight) {
            a = this.scroll().getForwardAction();
            a.putValue("control", this.displayer);
            this.btnScrollRight = TabControlButtonFactory.createScrollRightButton((TabDisplayer)this.displayer, (Action)a, (boolean)false);
        }
        this.displayer.add((Component)this.btnScrollRight);
        if (null == this.btnDropDown) {
            this.btnDropDown = TabControlButtonFactory.createDropDownButton((TabDisplayer)this.displayer, (boolean)false);
        }
        this.displayer.add((Component)this.btnDropDown);
        this.displayer.setLayout(this.createLayout());
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 24;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = Math.max(fm.getHeight() + 6, 22) + ins.top + ins.bottom;
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    protected int createRepaintPolicy() {
        return 429;
    }

    protected void paintAfterTabs(Graphics g) {
    }

    protected Component getControlButtons() {
        return null;
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] iconPaths = new String[4];
            iconPaths[0] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/scroll_left_enabled.png";
            iconPaths[2] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/scroll_left_disabled.png";
            iconPaths[3] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/scroll_left_rollover.png";
            iconPaths[1] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/scroll_left_pressed.png";
            buttonIconPaths.put(9, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/scroll_right_enabled.png";
            iconPaths[2] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/scroll_right_disabled.png";
            iconPaths[3] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/scroll_right_rollover.png";
            iconPaths[1] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/scroll_right_pressed.png";
            buttonIconPaths.put(10, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/popup_enabled.png";
            iconPaths[2] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/popup_disabled.png";
            iconPaths[3] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/popup_rollover.png";
            iconPaths[1] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/popup_pressed.png";
            buttonIconPaths.put(8, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/maximize_enabled.png";
            iconPaths[2] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/maximize_enabled.png";
            iconPaths[3] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/maximize_rollover.png";
            iconPaths[1] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/maximize_pressed.png";
            buttonIconPaths.put(3, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_enabled.png";
            iconPaths[2] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_enabled.png";
            iconPaths[3] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_rollover.png";
            iconPaths[1] = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_pressed.png";
            buttonIconPaths.put(4, iconPaths);
        }
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon res = null;
        OracleEditorTabDisplayerUI.initIcons();
        String[] paths = buttonIconPaths.get(buttonId);
        if (null != paths && buttonState >= 0 && buttonState < paths.length) {
            res = TabControlButtonFactory.getIcon((String)paths[buttonState]);
        }
        return res;
    }

    protected Rectangle getControlButtonsRectangle(Container parent) {
        return new Rectangle();
    }

    public void paintBackground(Graphics g) {
        Painter painter = Themes.getActiveTheme().getStateProperties("mainwindow", "normal").getPainter("bg");
        if (null != painter) {
            painter.paint(g, 0, 0, this.displayer.getWidth(), this.displayer.getHeight());
        } else {
            super.paintBackground(g);
        }
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = parent.getHeight();
            int buttonY = height - 16 - 3;
            OracleEditorTabDisplayerUI.this.btnDropDown.setBounds(width - 16, buttonY, 16, 16);
            int padding = 22;
            boolean showButtons = OracleEditorTabDisplayerUI.this.mustShowScrollButtons();
            if (showButtons) {
                OracleEditorTabDisplayerUI.this.btnScrollLeft.setBounds(width - 16 - 22 - 22, buttonY, 16, 16);
                OracleEditorTabDisplayerUI.this.btnScrollRight.setBounds(width - 22 - 16, buttonY, 16, 16);
                padding += 44;
            } else {
                OracleEditorTabDisplayerUI.this.btnScrollLeft.setBounds(-100, buttonY, 16, 16);
                OracleEditorTabDisplayerUI.this.btnScrollRight.setBounds(-100, buttonY, 16, 16);
            }
            OracleEditorTabDisplayerUI.this.scroll().setWidth(width - padding);
            if (!showButtons) {
                OracleEditorTabDisplayerUI.this.scroll().setOffset(-1);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return OracleEditorTabDisplayerUI.this.getMinimumSize((JComponent)parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return OracleEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

