/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.SlidingButtonUI;
import org.openide.util.ImageUtilities;

public class OracleSlidingButtonUI
extends SlidingButtonUI {
    private static final OracleSlidingButtonUI INSTANCE = new OracleSlidingButtonUI();
    private static final String IMG_PREFIX = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/";
    private static final Image imgLeft = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/default_left.png");
    private static final Image imgLeftRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/default_left_rounded.png");
    private static final Image imgMiddle = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/default_middle.png");
    private static final Image imgRight = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/default_right.png");
    private static final Image imgRightRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/default_right_rounded.png");
    private static final Image imgPressedLeft = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/pressed_left.png");
    private static final Image imgPressedLeftRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/pressed_left_rounded.png");
    private static final Image imgPressedMiddle = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/pressed_middle.png");
    private static final Image imgPressedRight = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/pressed_right.png");
    private static final Image imgPressedRightRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/pressed_right_rounded.png");
    private static final Image imgRollOverLeft = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/rollover_left.png");
    private static final Image imgRollOverLeftRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/rollover_left_rounded.png");
    private static final Image imgRollOverMiddle = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/rollover_middle.png");
    private static final Image imgRollOverRight = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/rollover_right.png");
    private static final Image imgRollOverRightRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/rollover_right_rounded.png");
    private static final String IMG_BOTTOM_PREFIX = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/";
    private static final Image imgBottomLeft = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/default_left.png");
    private static final Image imgBottomLeftRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/default_left_rounded.png");
    private static final Image imgBottomMiddle = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/default_middle.png");
    private static final Image imgBottomRight = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/default_right.png");
    private static final Image imgBottomRightRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/default_right_rounded.png");
    private static final Image imgBottomPressedLeft = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/pressed_left.png");
    private static final Image imgBottomPressedLeftRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/pressed_left_rounded.png");
    private static final Image imgBottomPressedMiddle = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/pressed_middle.png");
    private static final Image imgBottomPressedRight = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/pressed_right.png");
    private static final Image imgBottomPressedRightRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/pressed_right_rounded.png");
    private static final Image imgBottomRollOverLeft = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/rollover_left.png");
    private static final Image imgBottomRollOverLeftRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/rollover_left_rounded.png");
    private static final Image imgBottomRollOverMiddle = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/rollover_middle.png");
    private static final Image imgBottomRollOverRight = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/rollover_right.png");
    private static final Image imgBottomRollOverRightRounded = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/slides/bottom/rollover_right_rounded.png");
    private static Map<RenderingHints.Key, Object> hintsMap = null;

    private OracleSlidingButtonUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return INSTANCE;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
    }

    private static Map getHints() {
        if (hintsMap == null) {
            hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            if (hintsMap == null) {
                hintsMap = new HashMap<RenderingHints.Key, Object>();
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return hintsMap;
    }

    public static void setupAntialiasing(Graphics g) {
        ((Graphics2D)g).addRenderingHints(OracleSlidingButtonUI.getHints());
    }

    public void paint(Graphics g, JComponent c) {
        OracleSlidingButtonUI.setupAntialiasing(g);
        SlidingButton sb = (SlidingButton)c;
        OracleSlidingButtonUI.paintBackgroundAndBorder((Graphics2D)g, (AbstractButton)sb, sb.getOrientation());
        super.paint(g, c);
    }

    protected void paintBackground(Graphics2D g, AbstractButton b) {
    }

    protected void paintButtonPressed(Graphics g, AbstractButton button) {
        SlidingButton sb = (SlidingButton)button;
        int orientation = sb.getOrientation();
        OracleSlidingButtonUI.paintBackgroundAndBorder((Graphics2D)g, (AbstractButton)((SlidingButton)button), orientation);
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        if (b.getModel().isSelected()) {
            b.setForeground(Color.white);
        } else {
            b.setForeground(Color.black);
        }
        super.paintText(g, b, textRect, text);
    }

    static void paintBackgroundAndBorder(Graphics2D g2d, AbstractButton b, int orientation) {
        AffineTransform trans = g2d.getTransform();
        Image right = null;
        Image left = null;
        Image mid = null;
        boolean firstButton = OracleSlidingButtonUI.isFirst(b);
        boolean lastButton = OracleSlidingButtonUI.isLast(b);
        boolean rollover = b.getModel().isRollover() && !b.getModel().isArmed() && !b.getModel().isPressed() && !b.getModel().isSelected();
        ButtonModel model = b.getModel();
        Rectangle rect = OracleSlidingButtonUI.getButtonRect(g2d, b, orientation);
        if (!(model.isArmed() || model.isPressed() || model.isRollover() || model.isSelected())) {
            mid = imgMiddle;
            if (orientation == 4 || orientation == 1) {
                left = firstButton ? imgLeftRounded : imgLeft;
                right = lastButton ? imgRightRounded : imgRight;
            } else if (orientation == 3) {
                left = firstButton ? imgBottomLeftRounded : imgBottomLeft;
                right = lastButton ? imgBottomRightRounded : imgBottomRight;
                mid = imgBottomMiddle;
            } else {
                left = lastButton ? imgLeftRounded : imgLeft;
                right = firstButton ? imgRightRounded : imgRight;
            }
        } else {
            Image image = mid = rollover ? imgRollOverMiddle : imgPressedMiddle;
            if (orientation == 4 || orientation == 1) {
                Image image2 = firstButton ? (rollover ? imgRollOverLeftRounded : imgPressedLeftRounded) : (left = rollover ? imgRollOverLeft : imgPressedLeft);
                right = lastButton ? (rollover ? imgRollOverRightRounded : imgPressedRightRounded) : (rollover ? imgRollOverRight : imgPressedRight);
            } else if (orientation == 3) {
                Image image3 = firstButton ? (rollover ? imgBottomRollOverLeftRounded : imgBottomPressedLeftRounded) : (left = rollover ? imgBottomRollOverLeft : imgBottomPressedLeft);
                right = lastButton ? (rollover ? imgBottomRollOverRightRounded : imgBottomPressedRightRounded) : (rollover ? imgBottomRollOverRight : imgBottomPressedRight);
                mid = rollover ? imgBottomRollOverMiddle : imgBottomPressedMiddle;
            } else {
                Image image4 = lastButton ? (rollover ? imgRollOverLeftRounded : imgPressedLeftRounded) : (left = rollover ? imgRollOverLeft : imgPressedLeft);
                right = firstButton ? (rollover ? imgRollOverRightRounded : imgPressedRightRounded) : (rollover ? imgRollOverRight : imgPressedRight);
            }
        }
        OracleSlidingButtonUI.paintBackground(g2d, rect, left, mid, right);
        g2d.setTransform(trans);
    }

    private static void paintBackground(Graphics g, Rectangle rect, Image left, Image mid, Image right) {
        int width = rect.width;
        int height = rect.height;
        int x = rect.x;
        int y = rect.y;
        int leftWidth = left.getWidth(null);
        int rightWidth = right.getWidth(null);
        g.drawImage(left, x, y, leftWidth, height, null);
        g.drawImage(mid, x + leftWidth, y, width - leftWidth - rightWidth, height, null);
        g.drawImage(right, width - rightWidth, 0, rightWidth, height, null);
    }

    private static Rectangle getButtonRect(Graphics2D g2d, AbstractButton b, int orientation) {
        Rectangle rect = new Rectangle(0, 0, b.getWidth(), b.getHeight());
        switch (orientation) {
            case 2: {
                g2d.rotate(-1.5707963267948966);
                g2d.translate(-b.getHeight(), 0);
                rect.width = b.getHeight();
                rect.height = b.getWidth();
                break;
            }
            case 1: {
                g2d.rotate(1.5707963267948966);
                g2d.translate(0, -b.getWidth());
                rect.width = b.getHeight();
                rect.height = b.getWidth();
            }
        }
        return rect;
    }

    private static boolean isFirst(AbstractButton b) {
        Container parent = b.getParent();
        if (!(parent instanceof Container)) {
            return false;
        }
        for (Component c : parent.getComponents()) {
            if (!(c instanceof AbstractButton)) continue;
            return c.equals(b);
        }
        return false;
    }

    private static boolean isLast(AbstractButton b) {
        Container parent = b.getParent();
        if (!(parent instanceof Container)) {
            return false;
        }
        Component[] children = parent.getComponents();
        for (int i = children.length - 1; i >= 0; --i) {
            if (!(children[i] instanceof AbstractButton)) continue;
            return children[i].equals(b);
        }
        return false;
    }
}

