/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.net.URL;
import java.sql.Connection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerAddin;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.editors.graphical.AbstractGraphicalEditor;
import oracle.dbtools.scheduler.editors.graphical.GraphicalEditorToolbarActions;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorController;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.util.credential.GraphicalEditorInterface;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;

public class GraphicalEditor
extends AbstractGraphicalEditor
implements GraphicalEditorInterface {
    boolean refreshEnabled = false;
    static int number = 0;
    int idNum = number++;
    String connectionName = null;
    JComponent gui = null;
    private mxGraphComponent graphComponent;
    private GraphicalEditorController graphicalEditorController;
    private EditorController editorController = new EditorController();
    Map<URL, GraphEngineModel> modelMap = new HashMap<URL, GraphEngineModel>();
    ViewerNode viewerNode = null;

    public GraphicalEditor() {
        this.setEditorAttribute("ObjectActionController.IGNORE_REFRESH", Boolean.TRUE);
    }

    public void open() throws OpenAbortedException {
        GraphEngineModel graphEngineModel = this.getModel();
        if (graphEngineModel != null) {
            this.setPinEnabled(graphEngineModel.isEnablePin());
            this.setRefreshEnabled(graphEngineModel.isEnablePin());
        }
        this.getGUI();
    }

    protected JComponent createViewerUI() {
        if (this.gui == null) {
            this.graphicalEditorController = new GraphicalEditorController(this);
            GraphicalEditorToolbarActions graphicalEditorToolbarActions = new GraphicalEditorToolbarActions();
            Toolbar toolbar = this.getToolbar();
            ZoomActionController zoomActionController = new ZoomActionController();
            graphicalEditorToolbarActions.initToolBar((View)this, toolbar, this.graphicalEditorController.getJGraphXComponent().getGraph().getView(), this.isRefreshEnabled() ? new RefreshController() : null, new DefaultActionController(), this.graphicalEditorController.getReadOnlyModeActionController(), new LayoutActionController(), new SelectModeActionController(), new PanModeActionController(), null, zoomActionController, zoomActionController, zoomActionController);
            this.graphComponent = this.graphicalEditorController.getJGraphXComponent();
            this.graphComponent.setImportEnabled(true);
            this.graphComponent.setHorizontalScrollBarPolicy(30);
            this.graphComponent.setVerticalScrollBarPolicy(20);
            this.gui = this.graphComponent;
        }
        return this.gui;
    }

    protected void updateContent() {
        GraphEngineModel graphEngineModel = this.getModel();
        if (graphEngineModel != null) {
            this.graphicalEditorController.setModel(graphEngineModel);
            this.graphicalEditorController.importContextNode(this.getContext(), null, null);
        }
    }

    protected static Connection getConnection(String string) {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string, false);
        }
        catch (Exception exception) {
            connection = null;
        }
        return connection;
    }

    GraphEngineModel getModel() {
        GraphEngineModel graphEngineModel = null;
        Context context = this.getContext();
        Node node = context.getNode();
        if (node instanceof ViewerNode) {
            this.viewerNode = (ViewerNode)node;
            DBObject dBObject = this.viewerNode.getDBObject();
            this.connectionName = dBObject.getConnectionName();
            graphEngineModel = this.modelMap.get(this.viewerNode.getURL());
            if (graphEngineModel == null) {
                graphEngineModel = SchedulerAddin.getGraphEngineModel(dBObject.getObjectType());
                this.modelMap.put(this.viewerNode.getURL(), graphEngineModel);
            }
            if (graphEngineModel != null) {
                graphEngineModel.setNode((Node)this.viewerNode);
            }
        }
        return graphEngineModel;
    }

    protected void updateContent(boolean bl) {
        this.updateContent();
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            super.getToolbar();
        }
        return this._toolbar;
    }

    public void addMenuButton() {
    }

    public void close() {
        super.close();
        this.graphicalEditorController.close();
    }

    public Controller getController() {
        return this.editorController;
    }

    protected Element[] getSelectionFromUI() {
        return this.graphicalEditorController.getSelection();
    }

    public Component getGUI() {
        return this.createViewerUI();
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == ViewerNode.RELATION_NODE_CHANGED_MESSAGE_ID) {
            GraphicalEditorController graphicalEditorController = this.getGraphicalEditorController();
            graphicalEditorController.clearAll();
            graphicalEditorController.importContextNode(this.getContext(), null, null);
        } else if (updateMessage.getMessageID() == ViewerNode.RELATION_NODE_MODIFIED_MESSAGE_ID) {
            GraphicalEditorController graphicalEditorController = this.getGraphicalEditorController();
            graphicalEditorController.clearAll();
            graphicalEditorController.importContextNode(this.getContext(), null, null);
        } else if (updateMessage.getMessageID() == UpdateMessage.OBJECT_RENAMED) {
            // empty if block
        }
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    public void editorHidden() {
        super.editorHidden();
    }

    public void editorShown() {
        super.editorShown();
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
    }

    public Object getEditorAttribute(String string) {
        if (string.equals("scrollable")) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public GraphicalEditorController getGraphicalEditorController() {
        return this.graphicalEditorController;
    }

    @Override
    public Object getPrintable() {
        return this.gui;
    }

    @Override
    protected void cleanUp() {
    }

    public void setRefreshEnabled(boolean bl) {
        this.refreshEnabled = bl;
    }

    public boolean isRefreshEnabled() {
        return this.refreshEnabled;
    }

    private class ZoomActionController
    implements Controller {
        private ZoomActionController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            EventObject eventObject;
            if (ideAction.getCommandId() == GraphicalEditorToolbarActions.ZOOM_IN_CMD_ID) {
                GraphicalEditor.this.graphicalEditorController.getJGraphXComponent().zoomIn();
            } else if (ideAction.getCommandId() == GraphicalEditorToolbarActions.ZOOM_OUT_CMD_ID) {
                GraphicalEditor.this.graphicalEditorController.getJGraphXComponent().zoomOut();
            } else if (ideAction.getCommandId() == GraphicalEditorToolbarActions.ZOOM_CMD_ID && (eventObject = context.getEvent()) != null && eventObject.getSource() instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)eventObject.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (string.equals(SchedulerArb.getString("GRAPHICALEDITOR_ZOOM_PAGE_LABEL"))) {
                    mxRectangle mxRectangle2 = GraphicalEditor.this.graphComponent.getGraph().getGraphBounds();
                    mxPoint mxPoint2 = GraphicalEditor.this.graphComponent.getGraph().getView().getTranslate();
                    Dimension dimension = GraphicalEditor.this.graphComponent.getSize();
                    double d = GraphicalEditor.this.graphComponent.getGraph().getView().getScale();
                    double d2 = dimension.getWidth() / dimension.getHeight();
                    double d3 = mxRectangle2.getWidth() / mxRectangle2.getHeight();
                    double d4 = 1.0;
                    if (d2 > d3) {
                        d4 = dimension.getHeight() / (mxRectangle2.getHeight() / d);
                        mxPoint2.setY(mxPoint2.getY() - mxRectangle2.getY() / d);
                    } else {
                        d4 = dimension.getWidth() / (mxRectangle2.getWidth() / d);
                        mxPoint2.setX(mxPoint2.getX() - mxRectangle2.getX() / d);
                    }
                    GraphicalEditor.this.graphComponent.getGraph().getView().scaleAndTranslate(d4, mxPoint2.getX(), mxPoint2.getY());
                } else {
                    try {
                        string = string.replace("%", "");
                        GraphicalEditor.this.graphComponent.zoomTo(Double.parseDouble(string) / 100.0, GraphicalEditor.this.graphComponent.isCenterZoom());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(true);
            return true;
        }
    }

    private class LayoutActionController
    implements Controller {
        private LayoutActionController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            GraphicalEditor.this.graphicalEditorController.layout();
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(true);
            return true;
        }
    }

    private class PanModeActionController
    implements Controller {
        private PanModeActionController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            boolean bl = ideAction.getState();
            GraphicalEditor.this.graphicalEditorController.setPanning(bl);
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(true);
            ideAction.setState(GraphicalEditor.this.graphicalEditorController.isPanning());
            return true;
        }
    }

    private class SelectModeActionController
    implements Controller {
        private SelectModeActionController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            boolean bl = ideAction.getState();
            GraphicalEditor.this.graphicalEditorController.setPanning(!bl);
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(true);
            ideAction.setState(!GraphicalEditor.this.graphicalEditorController.isPanning());
            return true;
        }
    }

    private class DefaultActionController
    implements Controller {
        private DefaultActionController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            Element[] elementArray = context.getSelection();
            if (n == GraphicalEditorToolbarActions.DEFAULT_CMD_ID && elementArray != null && elementArray.length == 1 && elementArray[0] instanceof ObjectNode) {
                context.getView().getGUI().requestFocusInWindow();
                DBObject dBObject = new DBObject(elementArray[0]);
                JPopupMenu jPopupMenu = XMLBasedObjectAction.getInstance().getMenu(dBObject);
                XMLBasedObjectAction.getInstance().checkActionVersions(dBObject, false);
                if (jPopupMenu.getComponentCount() > 0) {
                    Component component = null;
                    if (ideAction.getValue("BUTTON") != null) {
                        component = (Component)ideAction.getValue("BUTTON");
                    } else if (context.getEvent() != null && context.getEvent().getSource() != null) {
                        component = (Component)context.getEvent().getSource();
                    }
                    context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
                    this.updateMenu(jPopupMenu, context);
                    ContextMenu contextMenu = new ContextMenu();
                    Context context2 = EditorManager.getEditorManager().getCurrentEditor().getContext();
                    contextMenu.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance());
                    contextMenu.prepareShow(context2);
                    contextMenu.sortContainer((Container)jPopupMenu);
                    for (Component component2 : jPopupMenu.getComponents()) {
                        contextMenu.add(component2);
                    }
                    jPopupMenu = (JPopupMenu)contextMenu.getGUI(true);
                    jPopupMenu.show(component, 0, 0);
                }
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(false);
            View view = context.getView();
            Element[] elementArray = view.getSelection();
            if (elementArray != null && elementArray.length == 1) {
                ideAction.setEnabled(elementArray[0] instanceof ObjectNode);
            }
            return true;
        }

        private void updateMenu(JPopupMenu jPopupMenu, Context context) {
            int n = jPopupMenu.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = jPopupMenu.getComponent(i);
                if (component instanceof JMenu) {
                    this.updateMenu(((JMenu)component).getPopupMenu(), context);
                    continue;
                }
                if (!(component instanceof JMenuItem)) continue;
                IdeAction ideAction = (IdeAction)((JMenuItem)component).getAction();
                ideAction.updateAction(context);
            }
        }
    }

    private class RefreshController
    implements Controller {
        private RefreshController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            GraphicalEditorController graphicalEditorController = GraphicalEditor.this.getGraphicalEditorController();
            graphicalEditorController.refresh();
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return true;
        }
    }

    private class EditorController
    implements Controller {
        private EditorController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (IDBEditor.CONN_CLOSED_CMD_ID == ideAction.getCommandId()) {
                IdeAction ideAction2 = IdeAction.get((int)48);
                return EditorManager.getEditorManager().handleEvent(ideAction2, context);
            }
            return EditorManager.getEditorManager().handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (IDBEditor.CONN_CLOSED_CMD_ID == ideAction.getCommandId()) {
                return true;
            }
            return EditorManager.getEditorManager().update(ideAction, context);
        }
    }
}

