/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.controller;

import com.mxgraph.model.mxGraphModel;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.handler.mxGraphHandler;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import javax.swing.TransferHandler;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorController;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorGraphHandler;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorMxConnectionHandler;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorTransferHandler;

public class GraphicalEditorGraphComponent
extends mxGraphComponent {
    private transient GraphicalEditorController controller;
    private transient mxRubberband rubberband;

    public GraphicalEditorGraphComponent(GraphicalEditorController graphicalEditorController, mxGraph mxGraph2) {
        super(mxGraph2);
        this.getViewport().setOpaque(false);
        this.setBackground(Color.WHITE);
        this.controller = graphicalEditorController;
        super.createHandlers();
        this.extraHanlders();
        this.setToolTips(true);
    }

    protected void createHandlers() {
    }

    protected TransferHandler createTransferHandler() {
        return new GraphicalEditorTransferHandler(this.controller);
    }

    protected mxGraphHandler createGraphHandler() {
        return new GraphicalEditorGraphHandler(this.controller, this);
    }

    protected mxConnectionHandler createConnectionHandler() {
        return new GraphicalEditorMxConnectionHandler(this, this.controller);
    }

    protected void installDoubleClickHandler() {
        this.graphControl.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Object object;
                if (!mouseEvent.isConsumed() && GraphicalEditorGraphComponent.this.isEditEvent(mouseEvent) && (object = GraphicalEditorGraphComponent.this.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false)) != null && GraphicalEditorGraphComponent.this.getGraph().isCellEditable(object)) {
                    GraphicalEditorGraphComponent.this.controller.openEditor(object);
                }
            }
        });
    }

    public Object[] getImportableCells(Object[] objectArray) {
        return mxGraphModel.filterCells((Object[])objectArray, (mxGraphModel.Filter)new mxGraphModel.Filter(){

            public boolean filter(Object object) {
                return GraphicalEditorGraphComponent.this.canImportCell(object);
            }
        });
    }

    public boolean canImportCell(Object object) {
        return this.isImportEnabled();
    }

    public Object[] importCells(Object[] objectArray, double d, double d2, Object object, Point point) {
        return super.importCells(objectArray, d, d2, object, point);
    }

    public boolean isPanningEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? this.controller.isPanning() || super.isPanningEvent(mouseEvent) : false;
    }

    private void extraHanlders() {
        this.rubberband = new mxRubberband((mxGraphComponent)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Dimension dimension = this.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(((Graphics2D)graphics).getBackground());
        int n2 = 0;
        double d = this.getPageScale();
        try {
            this.setPageScale(1.0);
            n2 = super.print((Graphics)graphics2D, pageFormat, n);
        }
        finally {
            this.setPageScale(d);
            graphics2D.dispose();
        }
        graphics.drawImage(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        return n2;
    }

    public void print(Graphics graphics) {
        super.print(graphics);
    }
}

