/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.chain;

import java.sql.Connection;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;

public class ChainDropAction
extends ActionDialog {
    private static final String CHAIN_NAME = "name";
    private static final String FORCE = "force";
    private static final String DROP_MSG = "msg";
    private String chainName;
    private boolean force = false;

    public ChainDropAction() {
        this.setScriptEditingEnabled(false);
    }

    protected List<ActionControl> createControls(Connection connection) {
        try {
            String string = this.getObjectName();
            this.chainName = "\"" + string + "\"";
        }
        catch (Exception exception) {
            return null;
        }
        try {
            String string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
            if (ChainDropAction.checkNull(string) != null) {
                this.chainName = "\"" + string + "\"." + this.chainName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(CHAIN_NAME, SchedulerArb.getString("CHAIN_DROP_NAME_LABEL"), this.chainName);
        LabelActionControl labelActionControl = new LabelActionControl(DROP_MSG, SchedulerArb.getString("CHAIN_DROP_LABEL"));
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(FORCE, SchedulerArb.getString("CHAIN_DROP_FORCE_LABEL"), this.force);
        Vector<ActionControl> vector = new Vector<ActionControl>();
        textBoxActionControl.setEditable(false);
        vector.add((ActionControl)textBoxActionControl);
        vector.add((ActionControl)booleanCheckBoxActionControl);
        vector.add((ActionControl)labelActionControl);
        return vector;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(FORCE);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(CHAIN_NAME, this.chainName);
        treeMap.put(FORCE, string2);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", treeMap);
        String string3 = null;
        string3 = dBMSSchedulerCodeGenerator.generate(string, "CHAIN_DROP", treeMap2);
        return string3;
    }

    protected String getTitle() {
        return SchedulerArb.getString("CHAIN_DROP_ACTION_TITLE");
    }

    public static String checkNull(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static String checkQuotes(String string) {
        if ((string = ChainDropAction.checkNull(string)) != null && string.length() > 0) {
            string = string.replace("'", "''");
        }
        return string;
    }
}

