/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval;

import oracle.dbtools.common.utils.Version;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalContext;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalController;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalFactory;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByDateClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByDayClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByHourClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByMinuteClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByMonthClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByMonthDayClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByPeriodClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.BySecondClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.BySetPosClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.BySubPeriodClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByTimeClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByWeekNoClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByYearDayClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.CombinedScheduleClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.EmbeddedScheduleClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ExtendedFreqClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.FreqClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.IntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.PeriodClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.PeriodsClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.RepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;

public class RepeatIntervalFactoryImpl
implements RepeatIntervalFactory {
    protected final RepeatIntervalContext context;

    public RepeatIntervalFactoryImpl(RepeatIntervalContext repeatIntervalContext) {
        this.context = repeatIntervalContext;
    }

    @Override
    public RepeatIntervalContext getContext() {
        return this.context;
    }

    @Override
    public RepeatIntervalModel getRepeatIntervalModel() {
        return new RepeatIntervalModel(this.context);
    }

    @Override
    public RepeatIntervalController getRepeatIntervalController(RepeatIntervalModel repeatIntervalModel) {
        return new RepeatIntervalController(this.context, repeatIntervalModel);
    }

    @Override
    public RepeatIntervalClause[] getRepeatIntervalClauses(RepeatIntervalModel repeatIntervalModel) {
        Version version = this.context.getVersion();
        int[] nArray = version.toIntArray();
        if (nArray[0] == 10 && nArray[1] <= 1) {
            RepeatIntervalClause[] repeatIntervalClauseArray = new RepeatIntervalClause[]{new FreqClause(repeatIntervalModel), new IntervalClause(repeatIntervalModel), new ByYearDayClause(repeatIntervalModel), new ByWeekNoClause(repeatIntervalModel), new ByMonthClause(repeatIntervalModel), new ByMonthDayClause(repeatIntervalModel), new ByDayClause(repeatIntervalModel), new ByHourClause(repeatIntervalModel), new ByMinuteClause(repeatIntervalModel), new BySecondClause(repeatIntervalModel)};
            return repeatIntervalClauseArray;
        }
        if (nArray[0] < 12) {
            RepeatIntervalClause[] repeatIntervalClauseArray = new RepeatIntervalClause[]{new ExtendedFreqClause(repeatIntervalModel), new IntervalClause(repeatIntervalModel), new BySetPosClause(repeatIntervalModel), new CombinedScheduleClause(repeatIntervalModel), new ByDateClause(repeatIntervalModel), new ByYearDayClause(repeatIntervalModel), new ByWeekNoClause(repeatIntervalModel), new ByMonthClause(repeatIntervalModel), new ByMonthDayClause(repeatIntervalModel), new ByDayClause(repeatIntervalModel), new ByHourClause(repeatIntervalModel), new ByMinuteClause(repeatIntervalModel), new BySecondClause(repeatIntervalModel), new PeriodsClause(repeatIntervalModel), new ByPeriodClause(repeatIntervalModel), new EmbeddedScheduleClause(repeatIntervalModel)};
            return repeatIntervalClauseArray;
        }
        RepeatIntervalClause[] repeatIntervalClauseArray = new RepeatIntervalClause[]{new ExtendedFreqClause(repeatIntervalModel), new IntervalClause(repeatIntervalModel), new BySetPosClause(repeatIntervalModel), new CombinedScheduleClause(repeatIntervalModel), new ByDateClause(repeatIntervalModel), new ByTimeClause(repeatIntervalModel), new ByYearDayClause(repeatIntervalModel), new ByWeekNoClause(repeatIntervalModel), new ByMonthClause(repeatIntervalModel), new ByMonthDayClause(repeatIntervalModel), new ByDayClause(repeatIntervalModel), new ByHourClause(repeatIntervalModel), new ByMinuteClause(repeatIntervalModel), new BySecondClause(repeatIntervalModel), new PeriodClause(repeatIntervalModel), new PeriodsClause(repeatIntervalModel), new ByPeriodClause(repeatIntervalModel), new BySubPeriodClause(repeatIntervalModel), new EmbeddedScheduleClause(repeatIntervalModel)};
        return repeatIntervalClauseArray;
    }
}

