/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.groups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.dbtools.scheduler.panels.groups.MemberListActionDialogTab;

public abstract class GroupCreateAction
extends ActionDialogBase {
    public static final String SCHEMA = "schema";
    public static final String INCLUDE_SCHEMA = "include_schema";
    public static final String GROUP_NAME = "group_name";
    public static final String GROUP_TYPE = "group_type";
    public static final String MEMBER = "member";
    public static final String OLD_MEMBER_NAME = "old_member_name";
    public static final String COMMENTS = "comments";
    public static final String ENABLED = "enabled";
    public static final String OWNER = "owner";
    Connection conn;
    String schemaName;
    String member = null;
    String group_name = null;
    Boolean enabled = Boolean.TRUE;
    String comments = null;
    NameBoxActionControl group_nameCtl = null;
    MemberListActionDialogTab memberTab = null;
    ActionControl enabledCtl = null;
    ActionControl commentsCtl = null;

    public GroupCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    protected abstract String getType();

    @Override
    protected abstract String getObjectType();

    protected abstract boolean isSchemaIncluded();

    protected abstract String getMemberListQuery();

    protected String getSchema() {
        return this.schemaName;
    }

    protected Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string3 = dBMSSchedulerCodeGenerator.generate(string2, string, null);
        return RaptorQueryUtils.promoteToDba((String)string3, (Connection)connection);
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        Vector<ActionDialogTab> vector = new Vector<ActionDialogTab>();
        this.memberTab = new MemberListActionDialogTab(MEMBER, SchedulerArb.get("GROUP_MEMBER_LIST_TAB_TITLE"), this.member, this.getMemberListQuery(), this.getType());
        vector.add(this.memberTab);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        String string;
        Operation operation = this.getOperation();
        this.conn = connection;
        try {
            string = this.getObjectName();
        }
        catch (Exception exception) {
            string = "null";
        }
        try {
            this.schemaName = this.getDBObjectSchemaName();
            if (this.schemaName == null) {
                this.schemaName = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception exception) {
            this.schemaName = "null";
        }
        if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
            object = null;
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("OBJECT_NAME", string);
                hashMap.put("OBJECT_OWNER", this.getSchema());
                hashMap.put("INCLUDE_SCHEMA", this.isSchemaIncluded());
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "GROUP_DATA"), hashMap);
                if (object != null) {
                    if (object.next()) {
                        this.group_name = object.getString("GROUP_NAME");
                        this.enabled = object.getString("ENABLED") == null ? null : Boolean.valueOf(object.getString("ENABLED").equalsIgnoreCase("true"));
                        this.comments = object.getString("COMMENTS");
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                }
                if ((object = dBUtil.executeOracleQuery(this.getQuery(connection, "GROUP_MEMBER_DATA"), hashMap)) != null) {
                    Object object2 = "";
                    while (object.next()) {
                        object2 = (String)object2 + object.getString("MEMBER_NAME") + ",";
                    }
                    this.member = ((String)object2).substring(0, ((String)object2).length() - 1);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
        switch (operation) {
            case UPDATE: {
                object = ObjectNameValidator.displayName(this.group_name);
                this.group_nameCtl = new NameBoxActionControl(GROUP_NAME, SchedulerArb.getString("GROUP_GROUP_NAME_LABEL"), (String)object);
                this.group_nameCtl.setEditable(false);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("GROUP_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("GROUP_COMMENTS_LABEL"), this.comments);
                break;
            }
            case CREATE_LIKE: {
                this.group_nameCtl = new NameBoxActionControl(GROUP_NAME, SchedulerArb.getString("GROUP_GROUP_NAME_LABEL"), "");
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("GROUP_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("DB_DESTINATION_COMMENTS_LABEL"), this.comments);
                break;
            }
            case CREATE_NEW: {
                this.group_nameCtl = new NameBoxActionControl(GROUP_NAME, SchedulerArb.getString("GROUP_GROUP_NAME_LABEL"), this.group_name);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("GROUP_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("GROUP_COMMENTS_LABEL"), this.comments);
            }
        }
        object = new ArrayList();
        ((ArrayList)object).add(this.group_nameCtl);
        ((ArrayList)object).add(this.enabledCtl);
        ((ArrayList)object).add(this.commentsCtl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        Object object;
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(GROUP_NAME);
        String string3 = ((ActionDialog.Lookup)values.getTabLookup(MEMBER)).get(MEMBER);
        Boolean bl = values.get(ENABLED) == null ? Boolean.FALSE.booleanValue() : values.get(ENABLED).equalsIgnoreCase("true");
        String string4 = values.get(COMMENTS);
        if (string2 != null && string2 != null) {
            string2 = ObjectNameValidator.validateName(string2);
            string2 = string2.trim();
            object = new IdentifierImpl(string2);
            string2 = ((IdentifierImpl)object).getId();
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        object = new TreeMap<String, String>();
        object.put(SCHEMA, this.getSchema());
        object.put(OWNER, new IdentifierImpl(this.getSchema()).getId(true));
        object.put(INCLUDE_SCHEMA, this.isSchemaIncluded());
        object.put(GROUP_NAME, new IdentifierImpl(string2).getId(true));
        object.put(GROUP_TYPE, this.getType());
        object.put(MEMBER, string3);
        object.put(ENABLED, bl);
        object.put(COMMENTS, string4);
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(GROUP_NAME, GroupCreateAction.equals(string2, this.group_name) == false);
        treeMap.put(MEMBER, GroupCreateAction.equals(string3, this.member) == false);
        treeMap.put(ENABLED, GroupCreateAction.equals(bl, this.enabled) == false);
        treeMap.put(COMMENTS, GroupCreateAction.equals(string4, this.comments) == false);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", object);
        treeMap2.put("changes", treeMap);
        String string5 = null;
        switch (operation) {
            case UPDATE: {
                object.put(OLD_MEMBER_NAME, this.member);
                string5 = dBMSSchedulerCodeGenerator.generate(string, "GROUP_UPDATE", treeMap2);
                break;
            }
            case CREATE_LIKE: {
                string5 = dBMSSchedulerCodeGenerator.generate(string, "GROUP_CREATE", treeMap2);
                break;
            }
            case CREATE_NEW: {
                string5 = dBMSSchedulerCodeGenerator.generate(string, "GROUP_CREATE", treeMap2);
            }
        }
        return string5;
    }

    protected static Boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    protected boolean isCloseOnError() {
        return false;
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    protected class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return GroupCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("type", GroupCreateAction.this.getType());
            String string = dBMSSchedulerCodeGenerator.generate(GroupCreateAction.this.getDBObject().getDBVersion(), "GROUP_LIST", hashtable);
            return RaptorQueryUtils.promoteToDba((String)string, (Connection)GroupCreateAction.this.getDBObject().getConnection());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector;
            block9: {
                vector = new Vector<String>();
                Connection connection = GroupCreateAction.this.getDBObject().getConnection();
                LockManager.lock((Connection)connection);
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                    if (resultSet == null) break block9;
                    try {
                        while (resultSet.next()) {
                            String string = resultSet.getString("OWNER") + "." + resultSet.getString("GROUP_NAME");
                            vector.add(string);
                        }
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                catch (Throwable throwable) {
                    throw new TaskException(throwable);
                }
                finally {
                    LockManager.unlock((Connection)connection);
                }
            }
            return vector;
        }
    }

    protected static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

        private static final long serialVersionUID = 1L;
    }
}

