/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.jobclass;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;

public class JobClassCreateAction
extends ActionDialogBase {
    public static final String NAME = "name";
    public static final String COMMENTS = "comments";
    public static final String LOGGING_LEVEL = "logging_level";
    public static final String LOG_HISTORY = "log_history";
    public static final String RESOURCE_CONSUMER_GROUP = "resource_consumer_group";
    public static final String SERVICE = "service";
    public static final String NAME_VALID_MSG = "namevalidmsg";
    public static final String LOG_HISTORY_VALID_MSG = "log_historyvalidmsg";
    public static final String RESOURCE_CONSUMER_GROUP_LIST = "ResourceConsumerGroupList";
    public static final String SERVICE_NAME_LIST = "ServiceNameList";
    String job_class_name = null;
    String resource_consumer_group = null;
    String service = null;
    int log_history = 0;
    String comments = null;
    String logging_level = null;
    Map<String, String> localToLogLevelMap = new Hashtable<String, String>(){
        {
            this.put(SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"), "FULL");
            this.put(SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"), "RUNS");
            this.put(SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FAILED_RUNS"), "FAILED_RUNS");
            this.put(SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF"), "OFF");
        }
    };
    Map<String, String> LogLevelTolocalMap = new Hashtable<String, String>(){
        {
            this.put("FULL", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"));
            this.put("RUNS", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"));
            this.put("FAILED_RUNS", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FAILED_RUNS"));
            this.put("OFF", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF"));
        }
    };

    public JobClassCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    protected String getTitle() {
        String string;
        Operation operation = this.getOperation();
        if (operation == null) {
            operation = Operation.CREATE_NEW;
        }
        switch (operation) {
            case UPDATE: {
                string = SchedulerArb.getString("JOBCLASSUPDATEDIALOG_TITLE");
                break;
            }
            case CREATE_LIKE: {
                string = SchedulerArb.getString("JOBCLASSCREATELIKEDIALOG_TITLE");
                break;
            }
            default: {
                string = SchedulerArb.getString("JOBCLASSCREATEDIALOG_TITLE");
            }
        }
        return string;
    }

    protected boolean isCloseOnError() {
        return false;
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHJOBCLASS";
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string3 = dBMSSchedulerCodeGenerator.generate(string2, string, null);
        return RaptorQueryUtils.promoteToDba((String)string3, (Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        Object object2;
        Operation operation;
        String[] stringArray;
        block21: {
            String string;
            boolean bl = false;
            try {
                bl = connection.getMetaData().getDatabaseMajorVersion() >= 11;
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            stringArray = bl ? new String[]{SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FAILED_RUNS"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF")} : new String[]{SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"), SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF")};
            operation = this.getOperation();
            try {
                string = this.getObjectName();
            }
            catch (Exception exception) {
                string = "null";
            }
            if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
                object2 = null;
                try {
                    textBoxActionControl = new HashMap();
                    textBoxActionControl.put("OBJECT_NAME", string);
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object2 = dBUtil.executeOracleQuery(this.getQuery(connection, "JOB_CLASS_DATA"), textBoxActionControl);
                    if (object2 != null && object2.next()) {
                        this.job_class_name = object2.getString("JOB_CLASS_NAME");
                        this.resource_consumer_group = object2.getString("RESOURCE_CONSUMER_GROUP");
                        this.service = object2.getString("SERVICE");
                        this.logging_level = object2.getString("LOGGING_LEVEL");
                        this.log_history = object2.getInt("LOG_HISTORY");
                        this.comments = object2.getString("COMMENTS");
                    }
                    DBUtil.closeResultSet((ResultSet)object2);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    break block21;
                }
                finally {
                    DBUtil.closeResultSet(object2);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        object2 = null;
        textBoxActionControl = null;
        dBUtil = null;
        SpinnerActionControl spinnerActionControl = null;
        TextBoxActionControl textBoxActionControl2 = null;
        ComboBoxActionControl comboBoxActionControl = null;
        switch (operation) {
            case UPDATE: {
                object = ObjectNameValidator.displayName(this.job_class_name);
                object2 = new NameBoxActionControl(NAME, SchedulerArb.getString("JOBCLASSPANEL_NAME_LABEL"), (String)object);
                object2.setEditable(false);
                textBoxActionControl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("JOBCLASSPANEL_DESC_LABEL"), this.comments);
                dBUtil = new SqlComboBoxActionControl(SERVICE, SchedulerArb.getString("JOBCLASSPANEL_SVCNAME_LABEL"), connection, this.getQuery(connection, "SERVICE_LIST_WITH_NULL"), this.service);
                spinnerActionControl = new SpinnerActionControl(LOG_HISTORY, SchedulerArb.getString("JOBCLASSPANEL_LOGRET_LABEL"), Integer.valueOf(this.log_history), Integer.valueOf(0), Integer.valueOf(1000000), Integer.valueOf(1));
                textBoxActionControl2 = new SqlComboBoxActionControl(RESOURCE_CONSUMER_GROUP, SchedulerArb.getString("JOBCLASSPANEL_RESCONGRP_LABEL"), connection, this.getQuery(connection, "RESOURCE_CONSUMER_GROUP_LIST_WITH_NULL"), this.resource_consumer_group);
                comboBoxActionControl = new ComboBoxActionControl(LOGGING_LEVEL, SchedulerArb.getString("JOBCLASSPANEL_LOGLEV_LABEL"), stringArray, this.getLocalLoggingLevel(this.logging_level));
                break;
            }
            case CREATE_LIKE: {
                object2 = new NameBoxActionControl(NAME, SchedulerArb.getString("JOBCLASSPANEL_NAME_LABEL"), "");
                textBoxActionControl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("JOBCLASSPANEL_DESC_LABEL"), this.comments);
                dBUtil = new SqlComboBoxActionControl(SERVICE, SchedulerArb.getString("JOBCLASSPANEL_SVCNAME_LABEL"), connection, this.getQuery(connection, "SERVICE_LIST_WITH_NULL"), this.service);
                spinnerActionControl = new SpinnerActionControl(LOG_HISTORY, SchedulerArb.getString("JOBCLASSPANEL_LOGRET_LABEL"), Integer.valueOf(this.log_history), Integer.valueOf(0), Integer.valueOf(1000000), Integer.valueOf(1));
                textBoxActionControl2 = new SqlComboBoxActionControl(RESOURCE_CONSUMER_GROUP, SchedulerArb.getString("JOBCLASSPANEL_RESCONGRP_LABEL"), connection, this.getQuery(connection, "RESOURCE_CONSUMER_GROUP_LIST_WITH_NULL"), this.resource_consumer_group);
                comboBoxActionControl = new ComboBoxActionControl(LOGGING_LEVEL, SchedulerArb.getString("JOBCLASSPANEL_LOGLEV_LABEL"), stringArray, this.getLocalLoggingLevel(this.logging_level));
                break;
            }
            case CREATE_NEW: {
                object2 = new NameBoxActionControl(NAME, SchedulerArb.getString("JOBCLASSPANEL_NAME_LABEL"), this.job_class_name);
                textBoxActionControl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("JOBCLASSPANEL_DESC_LABEL"), this.comments);
                try {
                    dBUtil = new SqlComboBoxActionControl(SERVICE, SchedulerArb.getString("JOBCLASSPANEL_SVCNAME_LABEL"), connection, this.getQuery(connection, "SERVICE_LIST_WITH_NULL"), this.service);
                }
                catch (Exception exception) {
                    dBUtil = new TextBoxActionControl(SERVICE, SchedulerArb.getString("JOBCLASSPANEL_SVCNAME_LABEL"), this.service);
                }
                spinnerActionControl = new SpinnerActionControl(LOG_HISTORY, SchedulerArb.getString("JOBCLASSPANEL_LOGRET_LABEL"), Integer.valueOf(this.log_history), Integer.valueOf(0), Integer.valueOf(1000000), Integer.valueOf(1));
                try {
                    textBoxActionControl2 = new SqlComboBoxActionControl(RESOURCE_CONSUMER_GROUP, SchedulerArb.getString("JOBCLASSPANEL_RESCONGRP_LABEL"), connection, this.getQuery(connection, "RESOURCE_CONSUMER_GROUP_LIST_WITH_NULL"), this.resource_consumer_group);
                }
                catch (Exception exception) {
                    textBoxActionControl2 = new TextBoxActionControl(RESOURCE_CONSUMER_GROUP, SchedulerArb.getString("JOBCLASSPANEL_RESCONGRP_LABEL"), this.resource_consumer_group);
                }
                comboBoxActionControl = new ComboBoxActionControl(LOGGING_LEVEL, SchedulerArb.getString("JOBCLASSPANEL_LOGLEV_LABEL"), stringArray, this.getLocalLoggingLevel(this.logging_level));
            }
        }
        object = new ArrayList();
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(comboBoxActionControl);
        ((ArrayList)object).add(spinnerActionControl);
        ((ArrayList)object).add(dBUtil);
        if (!DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)connection), (String)"xe")) {
            ((ArrayList)object).add(textBoxActionControl2);
        }
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        Object object;
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(NAME);
        string2 = ObjectNameValidator.validateName(string2);
        String string3 = values.get(COMMENTS);
        String string4 = values.get(SERVICE);
        String string5 = values.get(LOG_HISTORY);
        String string6 = values.get(RESOURCE_CONSUMER_GROUP);
        String string7 = this.localToLogLevelMap.get(values.get(LOGGING_LEVEL));
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string2 != null) {
            string2 = string2.trim();
            object = new IdentifierImpl(string2);
            string2 = ((IdentifierImpl)object).getId();
        }
        if (string4 != null && (string4.length() == 0 || string4.equals("null"))) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string6 != null && (string6.length() == 0 || string6.equals("null"))) {
            string6 = null;
        }
        if (string7 != null && string7.length() == 0) {
            string7 = null;
        }
        object = new TreeMap();
        object.put(NAME, string2);
        object.put(SERVICE, string4);
        object.put(LOG_HISTORY, string5);
        object.put(RESOURCE_CONSUMER_GROUP, string6);
        object.put(LOGGING_LEVEL, string7);
        object.put(COMMENTS, string3);
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(NAME, JobClassCreateAction.equals(string2, this.job_class_name) == false);
        treeMap.put(SERVICE, JobClassCreateAction.equals(string4, this.service) == false);
        treeMap.put(LOG_HISTORY, JobClassCreateAction.equals(string5, this.log_history) == false);
        treeMap.put(LOGGING_LEVEL, JobClassCreateAction.equals(string7, this.logging_level) == false);
        treeMap.put(RESOURCE_CONSUMER_GROUP, JobClassCreateAction.equals(string6, this.resource_consumer_group) == false);
        treeMap.put(COMMENTS, JobClassCreateAction.equals(string3, this.comments) == false);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("schema", "SYS");
        treeMap2.put("model", object);
        treeMap2.put("changes", treeMap);
        String string8 = null;
        switch (operation) {
            case UPDATE: {
                string8 = dBMSSchedulerCodeGenerator.generate(string, "JOB_CLASS_UPDATE", treeMap2);
                break;
            }
            case CREATE_LIKE: {
                string8 = dBMSSchedulerCodeGenerator.generate(string, "JOB_CLASS_CREATE_LIKE", treeMap2);
                break;
            }
            case CREATE_NEW: {
                string8 = dBMSSchedulerCodeGenerator.generate(string, "JOB_CLASS_CREATE", treeMap2);
            }
        }
        return string8;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return Boolean.TRUE;
        }
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    public boolean isEnabled(Context context) {
        Version version = DBUtil.ORACLE10g_VERSION;
        return RaptorVersionTracker.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newJobClassDialog_html");
    }

    private String getLocalLoggingLevel(String string) {
        if (string != null) {
            return this.LogLevelTolocalMap.get(string);
        }
        return null;
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return JobClassCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(JobClassCreateAction.this.getDBObject().getDBVersion(), "JOB_CLASS_LIST", null);
            return RaptorQueryUtils.promoteToDba((String)string, (Connection)JobClassCreateAction.this.getDBObject().getConnection());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = JobClassCreateAction.this.getDBObject().getConnection();
            LockManager.lock((Connection)connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("JOB_CLASS_NAME");
                        vector.add(string);
                    }
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            catch (Throwable throwable) {
                throw new TaskException(throwable);
            }
            finally {
                LockManager.unlock((Connection)connection);
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

