/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.olap.app.ui.MultiLineTextArea;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.AllMessageTable;
import oracle.olapdv.app.AllMessageTableCellEditor;
import oracle.olapdv.app.AllReportViewer;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.MessageDO;
import oracle.olapdv.olap.model.ValidateModelDO;

public class AllReportPanel
extends JPanel
implements ListSelectionListener {
    private final int ALL_DATA_REPORT_COUNT = 9;
    private DefaultTableModel m_tableModel;
    private AllMessageTable m_table;
    private Component m_parentComponent;
    private AllReportViewer m_allReportViewer;
    private AllReportPanel m_allReportPanel;
    private ValidateModelDO m_validateModelDO;
    private int m_lastRow;
    private int m_lastColumn;
    private JComboBox m_dimensionFilterComboBox;
    private DefaultComboBoxModel m_dimensionFilterComboBoxModel;
    private String m_selectedDimension;
    private boolean m_isInitializing;
    private MultiLineTextArea messageArea;

    public AllReportPanel(Component component, AllReportViewer allReportViewer, ValidateModelDO validateModelDO) {
        this.m_parentComponent = component;
        this.m_allReportViewer = allReportViewer;
        this.m_validateModelDO = validateModelDO;
        this.m_allReportPanel = this;
        this.jbinit();
    }

    public void setModelDO(ValidateModelDO validateModelDO) {
        this.m_validateModelDO = validateModelDO;
    }

    private void jbinit() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        ++gridBagConstraints.gridy;
        this.messageArea = new MultiLineTextArea(OLAPDVArb.getString("NO_VALIDATE_REPORT_DATA_AVAILABLE"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel.add((Component)this.messageArea, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(OLAPDVArb.getString("REPORT_FILTER") + " ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.m_dimensionFilterComboBoxModel = new DefaultComboBoxModel();
        this.m_dimensionFilterComboBoxModel.addElement(OLAPDVArb.getString("ALL_DIMENSIONS"));
        this.m_dimensionFilterComboBox = new JComboBox(this.m_dimensionFilterComboBoxModel);
        this.m_dimensionFilterComboBox.setSelectedIndex(0);
        jPanel.add((Component)this.m_dimensionFilterComboBox, gridBagConstraints);
        jLabel.setLabelFor(this.m_dimensionFilterComboBox);
        jLabel.setDisplayedMnemonic(70);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        Object[][] objectArray = new Object[5][3];
        Object[] objectArray2 = this.getColumnNames();
        this.m_tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table = new AllMessageTable(this.m_tableModel);
        this.setColumnWidths();
        this.m_table.setSelectionMode(0);
        this.m_table.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setBackground(Color.WHITE);
        int n = this.m_table.getRowHeight();
        this.m_table.setRowHeight(n * 4);
        AllMessageTableCellEditor allMessageTableCellEditor = new AllMessageTableCellEditor(this);
        this.m_table.setDefaultEditor(Object.class, allMessageTableCellEditor);
        allMessageTableCellEditor.setReportTable(this.m_table);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.m_lastRow = -1;
        this.m_lastColumn = -1;
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.m_dimensionFilterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AllReportPanel.this.m_isInitializing) {
                    AllReportPanel.this.m_selectedDimension = (String)AllReportPanel.this.m_dimensionFilterComboBox.getSelectedItem();
                    AllReportPanel.this.refreshMessagesInTable();
                    AllReportPanel.this.m_validateModelDO.setMessageDimensionFilter(AllReportPanel.this.m_selectedDimension);
                }
            }
        });
        jTabbedPane.add(OLAPDVArb.getString("REPORT_ALL_MESSAGES"), jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)jTabbedPane, gridBagConstraints);
    }

    public JTable getJTable() {
        return this.m_table;
    }

    public void refreshMessageData() {
        this.m_isInitializing = true;
        this.m_dimensionFilterComboBoxModel.removeAllElements();
        this.m_dimensionFilterComboBoxModel.addElement(OLAPDVArb.getString("ALL_DIMENSIONS"));
        ArrayList<DimensionDO> arrayList = this.m_validateModelDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            this.m_dimensionFilterComboBoxModel.addElement(dimensionDO.getName());
        }
        this.m_selectedDimension = this.m_validateModelDO.getMessageDimensionFilter();
        if (this.m_selectedDimension.equalsIgnoreCase(OLAPDVArb.getString("ALL_DIMENSIONS"))) {
            this.m_dimensionFilterComboBox.setSelectedIndex(0);
        } else {
            int n = 1;
            boolean bl = false;
            for (DimensionDO dimensionDO : arrayList) {
                String string = dimensionDO.getName();
                if (string.equalsIgnoreCase(this.m_selectedDimension)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.m_dimensionFilterComboBox.setSelectedIndex(n);
            } else {
                this.m_dimensionFilterComboBox.setSelectedIndex(0);
                this.m_selectedDimension = OLAPDVArb.getString("ALL_DIMENSIONS");
            }
        }
        this.refreshMessagesInTable();
        this.m_isInitializing = false;
    }

    public void refreshMessagesInTable() {
        Object[][] objectArray = this.getMessages();
        Object[] objectArray2 = this.getColumnNames();
        this.m_tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table.setModel(this.m_tableModel);
        this.m_lastRow = -1;
        this.m_lastColumn = -1;
        this.setColumnWidths();
        this.m_table.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.m_table.getSelectedRow();
        int n2 = this.m_table.getSelectedColumn();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (n == this.m_lastRow && n2 == this.m_lastColumn) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (n >= this.m_table.getRowCount()) {
            this.m_table.editCellAt(this.m_table.getRowCount() - 1, 3);
            return;
        }
        this.m_table.editCellAt(n, 3);
    }

    private Object[][] getMessages() {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!this.m_validateModelDO.hasValidationReportsEverBeenRun()) {
            this.messageArea.setVisible(true);
        } else {
            this.messageArea.setVisible(false);
        }
        MessageDO messageDO = new MessageDO();
        MessageDO messageDO2 = this.m_validateModelDO.getMetadataValidationMessages();
        Object[][] objectArray = messageDO2.getMessages();
        for (Object[] object2 : objectArray) {
            if (!this.m_selectedDimension.equalsIgnoreCase(OLAPDVArb.getString("ALL_DIMENSIONS")) && !this.m_selectedDimension.equalsIgnoreCase((String)(object = (String)object2[1]))) continue;
            messageDO.addAllReportMessage((String)object2[0], (String)object2[1], OLAPDVArb.getString("METADATA_AND_MAPPING_REPORT"), (String)object2[2]);
        }
        ArrayList<DimensionDO> arrayList = this.m_validateModelDO.getDimensionDOs();
        String[] stringArray = new String[]{"Members With Multiple Parents", "Distinct Members", "Distinct Members And Descriptions", "Duplicate Members Across Levels", "Rows With Null Members", "Members With Null Descriptions", "Members With Multiple Descriptions", "Descriptions With Multiple Members", "Descriptions With Multiple Parent Descriptions"};
        for (int i = 0; i < 9; ++i) {
            String string = stringArray[i];
            object = arrayList.iterator();
            while (object.hasNext()) {
                DimensionDO dimensionDO = (DimensionDO)object.next();
                ArrayList<HierarchyDO> arrayList2 = dimensionDO.getHierarchyDOs();
                for (HierarchyDO hierarchyDO : arrayList2) {
                    ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                    boolean bl = true;
                    for (LevelDO levelDO : arrayList3) {
                        int n5;
                        String string2 = dimensionDO.getName();
                        String string3 = hierarchyDO.getName();
                        String string4 = levelDO.getName();
                        if (!this.m_selectedDimension.equalsIgnoreCase(OLAPDVArb.getString("ALL_DIMENSIONS")) && !this.m_selectedDimension.equalsIgnoreCase(string2)) continue;
                        if (string.equalsIgnoreCase("Distinct Members")) {
                            n = levelDO.getValidateReport("Distinct Members");
                            if (levelDO.getDepth() > 1) {
                                LevelDO levelDO2 = levelDO.getParentLevelDO();
                                n2 = levelDO2.getValidateReport("Distinct Members");
                            }
                            if (bl) {
                                bl = false;
                                n3 = n;
                                if (n == -1 || n == 1) continue;
                                messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Distinct Members", OLAPDVArb.format("DV_0001", string4, string2, string3));
                                continue;
                            }
                            if (n3 != -1 && n != -1 && n < n3) {
                                if (hierarchyDO.isLevelALeaf(levelDO)) {
                                    messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Distinct Members", OLAPDVArb.format("DV_0002", string4, string2, string3));
                                } else {
                                    messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Distinct Members", OLAPDVArb.format("DV_0003", string4, string2, string3));
                                }
                            }
                            n3 = n;
                            continue;
                        }
                        if (string.equalsIgnoreCase("Distinct Members And Descriptions")) {
                            n = levelDO.getValidateReport("Distinct Members");
                            n4 = levelDO.getValidateReport("Distinct Members And Descriptions");
                            if (n4 == n || n < 1 || n4 < 0) continue;
                            messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Distinct Members And Descriptions", OLAPDVArb.format("DV_0004", string4, string2, string3));
                            continue;
                        }
                        if (string.equalsIgnoreCase("Duplicate Members Across Levels")) {
                            n = levelDO.getValidateReport("Duplicate Members Across Levels");
                            if (n <= 0) continue;
                            messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Duplicate Members Across Levels", OLAPDVArb.format("DV_0005", string4, string2, string3, n));
                            continue;
                        }
                        if (string.equalsIgnoreCase("Rows With Null Members")) {
                            int n6 = levelDO.getValidateReport("Rows With Null Members");
                            if (n6 <= 0) continue;
                            if (hierarchyDO.isLevelALeaf(levelDO)) {
                                messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Rows With Null Members", OLAPDVArb.format("DV_0006", string4, string2, string3));
                                continue;
                            }
                            messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Rows With Null Members", OLAPDVArb.format("DV_0007", string4, string2, string3));
                            continue;
                        }
                        if (string.equalsIgnoreCase("Members With Null Descriptions")) {
                            n = levelDO.getValidateReport("Distinct Members");
                            int n7 = levelDO.getValidateReport("Members With Null Descriptions");
                            if (n <= 0 || n7 <= 0) continue;
                            messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Members With Null Descriptions", OLAPDVArb.format("DV_0008", string4, string2, string3, n7));
                            continue;
                        }
                        if (string.equalsIgnoreCase("Members With Multiple Parents")) {
                            int n8 = levelDO.getValidateReport("Members With Multiple Parents");
                            if (n8 <= 0) continue;
                            messageDO.addAllReportMessage(OLAPDVArb.getString("ERROR_TITLE"), string2, "Members With Multiple Parents", OLAPDVArb.format("DV_0009", string4, string2, string3, n8));
                            continue;
                        }
                        if (string.equalsIgnoreCase("Members With Multiple Descriptions")) {
                            int n9 = levelDO.getValidateReport("Members With Multiple Descriptions");
                            if (n9 <= 0) continue;
                            messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Members With Multiple Descriptions", OLAPDVArb.format("DV_0010", string4, string2, string3, n9));
                            continue;
                        }
                        if (string.equalsIgnoreCase("Descriptions With Multiple Parent Descriptions")) {
                            int n10 = levelDO.getValidateReport("Descriptions With Multiple Parent Descriptions");
                            if (n10 <= 0) continue;
                            messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Descriptions With Multiple Parent Descriptions", OLAPDVArb.format("DV_0011", string4, string2, string3, n10));
                            continue;
                        }
                        if (!string.equalsIgnoreCase("Descriptions With Multiple Members") || (n5 = levelDO.getValidateReport("Descriptions With Multiple Members")) <= 0) continue;
                        messageDO.addAllReportMessage(OLAPDVArb.getString("WARNING_TITLE"), string2, "Descriptions With Multiple Members", OLAPDVArb.format("DV_0012", string4, string2, string3, n5));
                    }
                }
            }
        }
        return messageDO.getAllReportMessages();
    }

    private String[] getColumnNames() {
        String[] stringArray = new String[]{OLAPDVArb.getString("SEVERITY_COLUMN_LABEL"), OLAPDVArb.getString("DIMENSION_COLUMN_LABEL"), OLAPDVArb.getString("VALIDATION_REPORT_COLUMN_LABEL"), OLAPDVArb.getString("MESSAGE_COLUMN_LABEL")};
        return stringArray;
    }

    private void setColumnWidths() {
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(95);
        this.m_table.getColumnModel().getColumn(2).setPreferredWidth(225);
        this.m_table.getColumnModel().getColumn(3).setPreferredWidth(510);
    }
}

