/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.olap.model;

import java.util.ArrayList;
import oracle.olapdv.olap.model.DataObject;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateReportDO;

public class LevelDO
extends DataObject {
    private DimensionDO m_dimensionDO;
    private HierarchyDO m_hierarchyDO;
    private LevelMapDO m_levelMapDO = null;
    private ValidateReportDO m_validateReportDO = new ValidateReportDO();
    private int m_depth;
    private String m_modelName;
    private String m_owningDimensionName;
    private String m_owningHierarchyName;
    private ValidStates validState;

    public LevelDO(String string) {
        super(string);
    }

    public void setModelName(String string) {
        this.m_modelName = string;
    }

    public String getModelName() {
        return this.m_modelName;
    }

    public LevelDO(HierarchyDO hierarchyDO, String string) {
        super(string);
        this.m_hierarchyDO = hierarchyDO;
    }

    public void setHierarchyDO(HierarchyDO hierarchyDO) {
        this.m_hierarchyDO = hierarchyDO;
    }

    public HierarchyDO getHierarchyDO() {
        return this.m_hierarchyDO;
    }

    public LevelDO getParentLevelDO() {
        LevelDO levelDO = null;
        if (this.getDepth() > 1) {
            int n = this.getDepth() - 1;
            for (LevelDO levelDO2 : this.m_hierarchyDO.getLevelDOs()) {
                if (levelDO2.getDepth() != n) continue;
                levelDO = levelDO2;
                break;
            }
        }
        return levelDO;
    }

    public LevelDO(String string, HierarchyDO hierarchyDO) {
        super(string);
        this.m_hierarchyDO = hierarchyDO;
    }

    public LevelMapDO getLevelMapDO() {
        if (this.m_levelMapDO == null) {
            this.m_levelMapDO = new LevelMapDO(2);
        }
        return this.m_levelMapDO;
    }

    public void setLevelMapDO(LevelMapDO levelMapDO) {
        this.m_levelMapDO = levelMapDO;
    }

    public void setDepth(int n) {
        this.m_depth = n;
    }

    public int getDepth() {
        return this.m_depth;
    }

    public ArrayList<String> getAncestorKeyAndDescriptionColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        LevelMapDO levelMapDO = this.getLevelMapDO();
        arrayList.add(levelMapDO.getLongDescriptionColumnName());
        LevelDO levelDO = this;
        while (levelDO.getParentLevelDO() != null) {
            levelDO = levelDO.getParentLevelDO();
            levelMapDO = levelDO.getLevelMapDO();
            arrayList.add(levelMapDO.getColumnName());
            arrayList.add(levelMapDO.getLongDescriptionColumnName());
        }
        return arrayList;
    }

    public void setValidateReport(String string, int n) {
        this.m_validateReportDO.setValueForValidateReport(string, n);
    }

    public int getValidateReport(String string) {
        return this.m_validateReportDO.getValueForValidateReport(string);
    }

    public void setDimensionDO(DimensionDO dimensionDO) {
        this.m_dimensionDO = dimensionDO;
    }

    public DimensionDO getDimensionDO() {
        return this.m_dimensionDO;
    }

    public void setOwningDimensionName(String string) {
        this.m_owningDimensionName = string;
    }

    public String getOwningDimensionName() {
        return this.m_owningDimensionName;
    }

    public void setOwningHierarchyName(String string) {
        this.m_owningHierarchyName = string;
    }

    public String getOwningHierarchyName() {
        return this.m_owningHierarchyName;
    }

    public void setValidState(ValidStates validStates) {
        this.validState = validStates;
    }

    public ValidStates getValidState() {
        return this.validState;
    }

    public static enum ValidStates {
        VALID_OK,
        VALID_WARNING,
        VALID_ERROR;

    }
}

