/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.reader;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;
import oracle.olapdv.reader.ValidationReader;

public class ModelReader {
    private static Queries queries;
    private static final String XMLFILE = "olapdvreaderqueries.xml";
    private Logger LOG = Logger.getLogger(ModelReader.class.getName());
    private final String GET_AW_NAME_FROM_CUBE_NAME = "get_aw_name_from_cube_name";
    private final String GET_AW_NAME_FROM_DIMENSION_NAME = "get_aw_name_from_dimension_name";
    private final String GET_MODEL_NAMES = "get_model_names";
    private final String GET_MODEL_DETAILS = "get_model_details";
    private final String GET_COLUMN_DATA_TYPE = "get_column_data_type";

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), (String)XMLFILE);
                JavaXMLBind.BindToJavaStr((String)string3, (String)string2, (Object)this);
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        ModelReader.queries = queries;
    }

    public String getAwNameFromCubeName(String string, String string2) {
        Connection connection = null;
        String string3 = null;
        String string4 = this.getQuery("get_aw_name_from_cube_name");
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getAwNameFromCubeName " + sQLException);
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put("CUBE_NAME", string2);
        string3 = dBUtil.executeReturnOneCol(string4, hashMap);
        return string3;
    }

    public String getAwNameFromDimensionName(String string, String string2) {
        String string3 = this.getQuery("get_aw_name_from_dimension_name");
        Connection connection = null;
        String string4 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getAwNameFromDimensionName " + sQLException);
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put("DIMENSION_NAME", string2);
        string4 = dBUtil.executeReturnOneCol(string3, hashMap);
        return string4;
    }

    public void readValidateTable(String string, String string2) {
        Connection connection = null;
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        ValidateModelDO validateModelDO = this.populateDataValidationObjectModel(connection, string, string2);
        validateTopDO.addNewValidateModel(validateModelDO);
    }

    public ValidateModelDO populateDataValidationObjectModel(Connection connection, String string, String string2) {
        String string3 = this.getQuery("get_model_details");
        String string4 = null;
        String string5 = null;
        DimensionDO dimensionDO = null;
        HierarchyDO hierarchyDO = null;
        ValidateModelDO validateModelDO = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method populateDataValidationObjectModel, SQL Exception occurred. " + sQLException);
        }
        validateModelDO = new ValidateModelDO(string, string2);
        boolean bl = true;
        boolean bl2 = true;
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("MODEL_OWNER", string);
        hashMap.put("MODEL_NAME", string2);
        List list = dBUtil.executeReturnList(string3, hashMap);
        for (Map map : list) {
            Object object;
            Object object2;
            bl2 = false;
            LevelDO levelDO = new LevelDO((String)map.get("LEVEL_NAME"));
            levelDO.setModelName(string2);
            BigDecimal bigDecimal = (BigDecimal)map.get("DEPTH");
            levelDO.setDepth(bigDecimal.intValue());
            LevelMapDO levelMapDO = new LevelMapDO(2);
            String string6 = (String)map.get("TABLE_OWNER");
            String string7 = (String)map.get("DIMENSION_TABLE");
            String string8 = (String)map.get("MEMBER_COLUMN");
            String string9 = (String)map.get("DESCRIPTION_COLUMN");
            String string10 = (String)map.get("PARENT_JOIN_COLUMN");
            String string11 = (String)map.get("DIMENSION_TYPE");
            String string12 = (String)map.get("ATTRIBUTES");
            levelMapDO.setTableOwner(string6);
            levelMapDO.setTableName(string7);
            levelMapDO.setColumnName(string8);
            levelMapDO.setLongDescColumnName(string9);
            levelMapDO.setParentColumnName(string10);
            if (string12 != null && string12.length() > 0) {
                object2 = string12.split(",");
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    object = object2[i].split("=");
                    if (object[0].equalsIgnoreCase("END_DATE")) {
                        levelMapDO.setEndDateColumnName(object[1]);
                        continue;
                    }
                    if (!object[0].equalsIgnoreCase("TIMESPAN")) continue;
                    levelMapDO.setTimeSpanColumnName((String)object[1]);
                }
            }
            object2 = null;
            if (string7 != null && string7.length() > 0) {
                if (string8 != null && string8.length() > 0) {
                    object2 = this.getColumnDataType(connection, string6, string7, string8);
                    levelMapDO.setColumnDataType(((DataTypeInfo)object2).getDataType());
                    levelMapDO.setColumnDataTypeLength(((DataTypeInfo)object2).getDataTypeLength());
                }
                if (string9 != null && string9.length() > 0) {
                    object2 = this.getColumnDataType(connection, string6, string7, string9);
                    levelMapDO.setDescColumnDataTypeLength(((DataTypeInfo)object2).getDataTypeLength());
                    levelMapDO.setLongDescDataType(((DataTypeInfo)object2).getDataType());
                }
            }
            levelDO.setLevelMapDO(levelMapDO);
            if (bl) {
                hierarchyDO = new HierarchyDO((String)map.get("HIERARCHY_NAME"));
                hierarchyDO.addLevelDO(levelDO);
                levelDO.setHierarchyDO(hierarchyDO);
                dimensionDO = new DimensionDO((String)map.get("DIMENSION_NAME"));
                dimensionDO.addHierarchyDO(hierarchyDO);
                if (string11 != null && string11.length() > 0) {
                    dimensionDO.setDimensionType(string11);
                } else {
                    dimensionDO.setDimensionType("STANDARD");
                }
                levelDO.setDimensionDO(dimensionDO);
                string4 = (String)map.get("DIMENSION_NAME");
                string5 = (String)map.get("HIERARCHY_NAME");
                levelDO.setOwningDimensionName(string4);
                levelDO.setOwningHierarchyName(string5);
                bl = false;
                continue;
            }
            String string13 = (String)map.get("DIMENSION_NAME");
            object = (String)map.get("HIERARCHY_NAME");
            levelDO.setOwningDimensionName(string13);
            levelDO.setOwningHierarchyName((String)object);
            if (!string13.equalsIgnoreCase(string4)) {
                validateModelDO.addDimensionDO(dimensionDO);
                dimensionDO = new DimensionDO(string13);
                if (string11 != null && string11.length() > 0) {
                    dimensionDO.setDimensionType(string11);
                } else {
                    dimensionDO.setDimensionType("STANDARD");
                }
                hierarchyDO = new HierarchyDO((String)object);
                hierarchyDO.addLevelDO(levelDO);
                levelDO.setHierarchyDO(hierarchyDO);
                dimensionDO.addHierarchyDO(hierarchyDO);
                levelDO.setDimensionDO(dimensionDO);
            } else if (!((String)object).equalsIgnoreCase(string5)) {
                hierarchyDO = new HierarchyDO((String)object);
                hierarchyDO.addLevelDO(levelDO);
                levelDO.setHierarchyDO(hierarchyDO);
                dimensionDO.addHierarchyDO(hierarchyDO);
                levelDO.setDimensionDO(dimensionDO);
            } else {
                hierarchyDO.addLevelDO(levelDO);
                levelDO.setHierarchyDO(hierarchyDO);
                levelDO.setDimensionDO(dimensionDO);
            }
            string4 = (String)map.get("DIMENSION_NAME");
            string5 = (String)map.get("HIERARCHY_NAME");
        }
        if (!bl2) {
            validateModelDO.addDimensionDO(dimensionDO);
        }
        ValidationReader validationReader = new ValidationReader();
        validationReader.readValidateReport(validateModelDO);
        return validateModelDO;
    }

    public void fillInDataTypeInformationForLevel(LevelDO levelDO) {
        Connection connection = null;
        DataTypeInfo dataTypeInfo = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method fillInDataTypeInformationForLevel, SQL Exception occurred. " + sQLException);
        }
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            dataTypeInfo = this.getColumnDataType(connection, string, string2, string3);
            levelMapDO.setColumnDataType(dataTypeInfo.getDataType());
            levelMapDO.setColumnDataTypeLength(dataTypeInfo.getDataTypeLength());
        }
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string4 != null && string4.length() > 0) {
            dataTypeInfo = this.getColumnDataType(connection, string, string2, string4);
            levelMapDO.setDescColumnDataTypeLength(dataTypeInfo.getDataTypeLength());
            levelMapDO.setLongDescDataType(dataTypeInfo.getDataType());
        }
    }

    public void fillInDataTypeInformationForModel(ValidateModelDO validateModelDO) {
        Connection connection = null;
        DataTypeInfo dataTypeInfo = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method fillInDataTypeInformationForModel, SQL Exception occurred. " + sQLException);
        }
        for (DimensionDO dimensionDO : validateModelDO.getDimensionDOs()) {
            for (HierarchyDO hierarchyDO : dimensionDO.getHierarchyDOs()) {
                for (LevelDO levelDO : hierarchyDO.getLevelDOs()) {
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    String string = levelMapDO.getOwner();
                    String string2 = levelMapDO.getTableName();
                    String string3 = levelMapDO.getColumnName();
                    String string4 = levelMapDO.getLongDescriptionColumnName();
                    if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                        dataTypeInfo = this.getColumnDataType(connection, string, string2, string3);
                        levelMapDO.setColumnDataType(dataTypeInfo.getDataType());
                        levelMapDO.setColumnDataTypeLength(dataTypeInfo.getDataTypeLength());
                    }
                    if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0 || string4 == null || string4.length() <= 0) continue;
                    dataTypeInfo = this.getColumnDataType(connection, string, string2, string4);
                    levelMapDO.setDescColumnDataTypeLength(dataTypeInfo.getDataTypeLength());
                    levelMapDO.setLongDescDataType(dataTypeInfo.getDataType());
                }
            }
        }
    }

    private DataTypeInfo getColumnDataType(Connection connection, String string, String string2, String string3) {
        String string4 = this.getQuery("get_column_data_type");
        DataTypeInfo dataTypeInfo = new DataTypeInfo();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put("TABLE_NAME", string2);
        hashMap.put("COLUMN_NAME", string3);
        List list = dBUtil.executeReturnList(string4, hashMap);
        for (Map map : list) {
            dataTypeInfo.setDataType((String)map.get("DATA_TYPE"));
            BigDecimal bigDecimal = (BigDecimal)map.get("DATA_LENGTH");
            dataTypeInfo.setDataTypeLength(bigDecimal.intValue());
        }
        return dataTypeInfo;
    }

    protected static class DataTypeInfo {
        protected String m_dataType;
        protected int m_dataTypeLength;

        protected DataTypeInfo() {
        }

        protected void setDataType(String string) {
            this.m_dataType = string;
        }

        protected String getDataType() {
            return this.m_dataType;
        }

        protected void setDataTypeLength(int n) {
            this.m_dataTypeLength = n;
        }

        protected int getDataTypeLength() {
            return this.m_dataTypeLength;
        }
    }
}

