/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.util.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleStatement;
import oracle.olapdv.util.Logger;
import oracle.sql.CLOB;

public class SQLParam {
    private int m_type = 0;
    private Object m_value = null;
    private OracleStatement m_statement = null;

    public SQLParam(String string) {
        this(12, string);
    }

    public SQLParam(Long l) {
        this(-5, l);
    }

    public SQLParam(long l) {
        this(-5, new Long(l));
    }

    public SQLParam(Integer n) {
        this(4, n);
    }

    public SQLParam(int n) {
        this(4, new Integer(n));
    }

    public SQLParam(Short s) {
        this(5, s);
    }

    public SQLParam(short s) {
        this(5, new Short(s));
    }

    public SQLParam(Float f) {
        this(6, f);
    }

    public SQLParam(float f) {
        this(6, new Float(f));
    }

    public SQLParam(Double d) {
        this(8, d);
    }

    public SQLParam(double d) {
        this(8, new Double(d));
    }

    public SQLParam(BigDecimal bigDecimal) {
        this(2, bigDecimal);
    }

    public SQLParam(Timestamp timestamp) {
        this(93, timestamp);
    }

    public SQLParam(Time time) {
        this(92, time);
    }

    public SQLParam(Date date) {
        this(91, date);
    }

    public SQLParam(CLOB cLOB) {
        this(2005, cLOB);
    }

    public SQLParam(boolean bl) {
        this(16, bl);
    }

    public SQLParam(int n, Object object) {
        this.m_type = n;
        this.m_value = object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{SQLParam").append(": m_type = ").append(this.m_type).append(", m_value = ").append(this.m_value).append(", m_statement = ").append(this.m_statement).append("}");
        return stringBuffer.toString();
    }

    public Object getValue() {
        return this.m_value;
    }

    public OracleResultSet getResultSet() {
        OracleResultSet oracleResultSet = null;
        if (this.m_value instanceof OracleResultSet) {
            oracleResultSet = (OracleResultSet)this.m_value;
        }
        return oracleResultSet;
    }

    public OracleStatement getStatement() {
        return this.m_statement;
    }

    public int getType() {
        return this.m_type;
    }

    public void setValue(Object object) {
        this.m_value = object;
    }

    public void setStatement(OracleStatement oracleStatement) {
        this.m_statement = oracleStatement;
    }

    public void closeResultSet() {
        if (this.m_value instanceof OracleResultSet) {
            try {
                ((OracleResultSet)this.m_value).close();
                this.m_statement.close();
                this.m_value = null;
                this.m_statement = null;
            }
            catch (SQLException sQLException) {
                Logger.logError("SQLParam.closeResultSet", sQLException);
            }
        }
    }
}

