/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import oracle.i18n.util.LocaleMapper;
import oracle.jdbc.OracleDriver;
import oracle.sql.CLOB;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSULocale;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import oracle.xml.sql.docgen.OracleXMLDocGenLob;
import oracle.xml.sql.query.OracleXMLQuery;

public class OracleXMLStore {
    private static Connection conn;
    private static String connEnc;
    private static String encTag;
    private static final String DBENCODING = "_";
    private static final int INSERT = 1;
    private static final int UPDATE = 2;
    private static final int DELETE = 3;
    private static int maxRows;
    private static int skipRows;
    private static String rowSetTag;
    private static String rowTag;
    private static String rowIdCol;
    private static String rowIdAttr;
    private static String errorTag;
    private static final int LOWER_CASE = 1;
    private static final int UPPER_CASE = 2;
    private static final int DEFAULT_CASE = 3;
    private static int tagcase;
    private static String styleSheet;
    private static String styleSheetType;
    private static boolean nullAttrInd;
    private static String collIdAttr;
    private static boolean raiseException;
    private static boolean propagateOriginalException;
    private static int errCode;
    private static String errMsg;
    private static Vector bindNames;
    private static Vector bindValues;
    private static Reader metaHeader;
    private static Reader dataHeader;
    private static String docTag;
    private static int docType;
    private static String queryDateFormat;
    private static boolean updateQueryDateFormat;
    private static String dateFormat;
    private static boolean ignoreCase;
    private static int batchSize;
    private static int cmtBatch;
    private static String lobDuration;
    private static Vector updColList;
    private static Vector keyColList;

    public static void getXML(Connection oconn, String sqlString, int metaType, CLOB clb) throws Exception {
        try {
            conn = oconn;
            OracleXMLStore.getXML(new StringReader(sqlString), metaType, clb);
        }
        catch (OracleXMLSQLException e) {
            errCode = e.getErrorCode();
            errMsg = e.getMessage();
            Exception e2 = e.getParentException();
            throw propagateOriginalException && e2 != null ? e2 : e;
        }
    }

    public static void getXML(CLOB sqlString, int metaType, CLOB clb) throws Exception {
        if (conn == null) {
            conn = new OracleDriver().defaultConnection();
        }
        try {
            OracleXMLStore.getXML(sqlString.getCharacterStream(), metaType, clb);
        }
        catch (OracleXMLSQLException e) {
            errCode = e.getErrorCode();
            errMsg = e.getMessage();
            Exception e2 = e.getParentException();
            throw propagateOriginalException && e2 != null ? e2 : e;
        }
    }

    public static void getXML(String sqlString, int metaType, CLOB clb) throws Exception {
        if (conn == null) {
            conn = new OracleDriver().defaultConnection();
        }
        try {
            OracleXMLStore.getXML(new StringReader(sqlString), metaType, clb);
        }
        catch (OracleXMLSQLException e) {
            errCode = e.getErrorCode();
            errMsg = e.getMessage();
            Exception e2 = e.getParentException();
            throw propagateOriginalException && e2 != null ? e2 : e;
        }
    }

    private static void getXML(Reader query, int metaType, CLOB clb) throws Exception {
        Exception e = null;
        OracleXMLDataSetExtJdbc dset = null;
        try {
            dset = new OracleXMLDataSetExtJdbc(conn, new BufferedReader(query), bindNames, bindValues);
        }
        catch (Exception e2) {
            e = e2;
        }
        OracleXMLQuery qry = new OracleXMLQuery(dset);
        if (e != null) {
            qry.setException(e);
        }
        qry.setRowsetTag(rowSetTag);
        qry.setRowTag(rowTag);
        qry.setCollIdAttrName(collIdAttr);
        qry.setRaiseException(raiseException);
        qry.setErrorTag(errorTag);
        qry.useNullAttributeIndicator(nullAttrInd);
        qry.setDataHeader(dataHeader, docTag);
        qry.setMetaHeader(metaHeader);
        if (updateQueryDateFormat) {
            qry.setDateFormat(queryDateFormat);
            updateQueryDateFormat = false;
        }
        if (rowIdAttr != null) {
            qry.setRowIdAttrName(rowIdAttr);
        }
        if (rowIdCol != null) {
            qry.setRowIdAttrValue(rowIdCol);
        }
        qry.setEncoding(encTag);
        if (tagcase == 2) {
            qry.useUpperCaseTagNames();
        } else if (tagcase == 1) {
            qry.useLowerCaseTagNames();
        }
        if (styleSheet != null) {
            if (styleSheetType != null) {
                qry.setStylesheetHeader(styleSheet, styleSheetType);
            } else {
                qry.setStylesheetHeader(styleSheet);
            }
        }
        try {
            if (docType == 1) {
                qry.setMaxRows(maxRows);
                qry.setSkipRows(skipRows);
                OracleXMLDocGenLob lobgen = new OracleXMLDocGenLob(conn, clb);
                qry.getXML((OracleXMLDocGen)lobgen, metaType);
                lobgen.flush();
            } else {
                OracleXMLDocGenLob lobgen = new OracleXMLDocGenLob(conn, clb);
                if (docType == 2) {
                    qry.getXMLMetaData(metaType, true, lobgen);
                } else {
                    qry.getXMLMetaData(metaType, false, lobgen);
                }
                lobgen.flush();
            }
        }
        catch (Exception eNew) {
            throw (Exception)eNew.fillInStackTrace();
        }
        finally {
            if (qry != null) {
                qry.close();
            }
            if (dset != null) {
                dset.close();
            }
        }
    }

    public static void getXMLMetaData(String query, int metaType, int withVer, CLOB clb) throws Exception {
        docType = withVer != 0 ? 2 : 0;
        OracleXMLStore.getXML(query, metaType, clb);
        docType = 1;
    }

    public static void getXMLMetaData(CLOB query, int metaType, int withVer, CLOB clb) throws Exception {
        docType = withVer != 0 ? 2 : 0;
        OracleXMLStore.getXML(query, metaType, clb);
        docType = 1;
    }

    public static void bindValue(String bindName, String bindValue) {
        if (bindName == null) {
            return;
        }
        if (bindNames == null) {
            bindNames = new Vector(10, 10);
            bindValues = new Vector(10, 10);
        }
        bindNames.addElement(bindName);
        bindValues.addElement(bindValue);
    }

    public static void clearBindValues() {
        bindNames = null;
        bindValues = null;
    }

    private static OracleXMLSave createSaveObject(String tableName) throws SQLException {
        int i;
        int size;
        if (conn == null) {
            conn = new OracleDriver().defaultConnection();
        }
        OracleXMLSave sav = new OracleXMLSave(conn, tableName);
        if (batchSize > 0) {
            sav.setBatchSize(batchSize);
        }
        if (cmtBatch > 0) {
            sav.setCommitBatch(cmtBatch);
        }
        sav.setIgnoreCase(ignoreCase);
        sav.setDateFormat(dateFormat);
        sav.setRowTag(rowTag);
        if (keyColList != null) {
            size = keyColList.size();
            String[] keyNames = new String[size];
            for (i = 0; i < size; ++i) {
                keyNames[i] = (String)keyColList.elementAt(i);
            }
            sav.setKeyColumnList(keyNames);
        }
        if (updColList != null) {
            size = updColList.size();
            String[] colNames = new String[size];
            for (i = 0; i < size; ++i) {
                colNames[i] = (String)updColList.elementAt(i);
            }
            sav.setUpdateColumnList(colNames);
        }
        return sav;
    }

    public static void setKeyColumn(String colName) {
        if (keyColList == null) {
            keyColList = new Vector(10, 10);
        }
        keyColList.addElement(colName);
    }

    public static void clearKeyColumnList() {
        keyColList = null;
    }

    public static void setUpdateColumn(String colName) {
        if (updColList == null) {
            updColList = new Vector(10, 10);
        }
        updColList.addElement(colName);
    }

    public static void clearUpdateColumnList() {
        updColList = null;
    }

    public static int saveXML(String tableName, String xmlDoc, int dmlType) throws Exception {
        OracleXMLSave sav = null;
        try {
            sav = OracleXMLStore.createSaveObject(tableName);
            switch (dmlType) {
                case 1: {
                    int n = sav.insertXML(xmlDoc);
                    return n;
                }
                case 2: {
                    int n = sav.updateXML(xmlDoc);
                    return n;
                }
                case 3: {
                    int n = sav.deleteXML(xmlDoc);
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        catch (OracleXMLSQLException e) {
            errCode = e.getErrorCode();
            errMsg = e.getMessage();
            Exception e2 = e.getParentException();
            throw propagateOriginalException && e2 != null ? e2 : e;
        }
        finally {
            if (sav != null) {
                sav.close();
            }
        }
    }

    public static int saveXML(String tableName, CLOB xmlClob, int dmlType) throws Exception {
        OracleXMLSave sav = null;
        try {
            Reader xsrc = xmlClob.getCharacterStream();
            sav = OracleXMLStore.createSaveObject(tableName);
            switch (dmlType) {
                case 1: {
                    int n = sav.insertXML(xsrc);
                    return n;
                }
                case 2: {
                    int n = sav.updateXML(xsrc);
                    return n;
                }
                case 3: {
                    int n = sav.deleteXML(xsrc);
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        catch (OracleXMLSQLException e) {
            errCode = e.getErrorCode();
            errMsg = e.getMessage();
            Exception e2 = e.getParentException();
            throw propagateOriginalException && e2 != null ? e2 : e;
        }
        finally {
            if (sav != null) {
                sav.close();
            }
        }
    }

    public static int insertXML(String tableName, String xmlDoc) throws Exception {
        return OracleXMLStore.saveXML(tableName, xmlDoc, 1);
    }

    public static int insertXML(String tableName, CLOB xmlClob) throws Exception {
        return OracleXMLStore.saveXML(tableName, xmlClob, 1);
    }

    public static int updateXML(String tableName, String xmlDoc) throws Exception {
        return OracleXMLStore.saveXML(tableName, xmlDoc, 2);
    }

    public static int updateXML(String tableName, CLOB xmlClob) throws Exception {
        return OracleXMLStore.saveXML(tableName, xmlClob, 2);
    }

    public static int deleteXML(String tableName, String xmlDoc) throws Exception {
        return OracleXMLStore.saveXML(tableName, xmlDoc, 3);
    }

    public static int deleteXML(String tableName, CLOB xmlClob) throws Exception {
        return OracleXMLStore.saveXML(tableName, xmlClob, 3);
    }

    public static void setRowsetTag(String rowSet) {
        rowSetTag = rowSet;
    }

    public static void setRowTag(String rowtag) {
        rowTag = rowtag;
    }

    public static void setRowIdAttrName(String rowidattr) {
        rowIdAttr = rowidattr;
    }

    public static void setRowIdColumn(String colName) {
        rowIdCol = colName;
    }

    public static void setCollIdAttr(String attrName) {
        collIdAttr = attrName;
    }

    public static void setRaiseException(int raiseEx) {
        raiseException = raiseEx != 0;
    }

    public static void useNullAttributeIndicator(int use) {
        nullAttrInd = use != 0;
    }

    public static void propagateOriginalException(int orig) {
        propagateOriginalException = orig != 0;
    }

    public static void getExceptionContent(int[] no, String[] msg) {
        no[0] = errCode;
        msg[0] = errMsg;
    }

    public static void setStylesheetHeader(String styleuri) {
        styleSheet = styleuri;
    }

    public static void setStylesheetHeaderType(String styletype) {
        styleSheetType = styletype;
    }

    public static void useLowerCaseTagNames() {
        tagcase = 1;
    }

    public static void useUpperCaseTagNames() {
        tagcase = 2;
    }

    public static void useDefaultCaseTagNames() {
        tagcase = 3;
    }

    public static void ignoreTagCase(int ignore) {
        ignoreCase = ignore != 0;
    }

    public static void setErrorTag(String errortag) {
        errorTag = errortag;
    }

    public static void setMaxRows(int mRows) {
        maxRows = mRows >= 0 ? mRows : -1;
    }

    public static void setSkipRows(int sRows) {
        skipRows = sRows >= 0 ? sRows : -1;
    }

    public static void setDateFormat(String dateformat) {
        dateFormat = dateformat;
    }

    public static void setQueryDateFormat(String dateformat) {
        queryDateFormat = dateformat;
        updateQueryDateFormat = true;
    }

    public static void setBatchSize(int size) {
        batchSize = size;
    }

    public static void setCommitBatch(int size) {
        cmtBatch = size;
    }

    public static void setMetaHeader(Reader header) throws Exception {
        metaHeader = header == null ? null : header;
    }

    public static void setDataHeader(Reader header, String docT) throws Exception {
        if (header == null) {
            dataHeader = null;
        } else {
            dataHeader = header;
            docTag = docT;
        }
    }

    public static void setMetaHeader(CLOB header) throws Exception {
        metaHeader = header == null ? null : header.getCharacterStream();
    }

    public static void setDataHeader(CLOB header, String docT) throws Exception {
        if (header == null) {
            dataHeader = null;
        } else {
            dataHeader = header.getCharacterStream();
            docTag = docT;
        }
    }

    public static void setLobDuration(String duration) {
        if (duration == null) {
            return;
        }
        lobDuration = duration;
    }

    public static void setEncodingTag(String enc) {
        if (enc != null && enc.compareTo(DBENCODING) == 0) {
            if (connEnc == null) {
                connEnc = System.getProperty("file.encoding");
                try {
                    connEnc = LocaleMapper.getIANACharacterSet((int)3, (String)connEnc);
                }
                catch (NoSuchMethodError e) {
                    connEnc = XSULocale.getIANACharset(connEnc);
                }
            }
            encTag = connEnc;
        } else {
            encTag = enc;
        }
    }

    public static void resetOptions() {
        maxRows = -1;
        skipRows = 0;
        rowSetTag = "ROWSET";
        rowTag = "ROW";
        rowIdCol = null;
        rowIdAttr = "num";
        errorTag = "ERROR";
        encTag = null;
        tagcase = 3;
        styleSheet = null;
        ignoreCase = false;
        dateFormat = "MM/dd/yyyy HH:mm:ss";
        queryDateFormat = null;
        updateQueryDateFormat = false;
        OracleXMLStore.clearBindValues();
        dataHeader = null;
        metaHeader = null;
        docType = 1;
        lobDuration = "DBMS_LOB.SESSION";
        errCode = 0;
        errMsg = null;
    }

    static {
        connEnc = null;
        encTag = null;
        maxRows = -1;
        skipRows = 0;
        rowSetTag = "ROWSET";
        rowTag = "ROW";
        rowIdCol = null;
        rowIdAttr = "num";
        errorTag = "ERROR";
        tagcase = 3;
        styleSheet = null;
        styleSheetType = null;
        nullAttrInd = false;
        collIdAttr = null;
        raiseException = false;
        propagateOriginalException = false;
        errCode = 0;
        errMsg = null;
        bindNames = null;
        bindValues = null;
        metaHeader = null;
        dataHeader = null;
        docTag = "DOCUMENT";
        docType = 1;
        queryDateFormat = null;
        updateQueryDateFormat = false;
        dateFormat = "MM/dd/yyyy HH:mm:ss";
        ignoreCase = false;
        batchSize = -1;
        cmtBatch = -1;
        lobDuration = "DBMS_LOB.SESSION";
        updColList = null;
        keyColList = null;
    }
}

