/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql;

import java.sql.SQLException;

public class OracleXMLSQLException
extends RuntimeException {
    private String errorTag = "ERROR";
    int sqlErrorCode = 0;
    String sqlState = null;
    boolean errCodeSet = false;
    Exception parentE = null;

    public OracleXMLSQLException(Exception exception) {
        super(OracleXMLSQLException.getExceptionMessage(exception));
        this.setParentE(exception);
    }

    public OracleXMLSQLException(Exception exception, String string) {
        super(OracleXMLSQLException.getExceptionMessage(exception));
        this.setParentE(exception);
        this.setErrorTag(string);
    }

    public OracleXMLSQLException(String string, Exception exception, boolean bl) {
        super(string + (bl ? OracleXMLSQLException.getExceptionMessage(exception) : ""));
        this.setParentE(exception);
    }

    public OracleXMLSQLException(String string, Exception exception) {
        super(OracleXMLSQLException.getExceptionMessage(exception) + "\n Note " + string);
        this.setParentE(exception);
    }

    public OracleXMLSQLException(String string, Exception exception, String string2) {
        super(OracleXMLSQLException.getExceptionMessage(exception) + "\n Note " + string);
        this.setParentE(exception);
        this.setErrorTag(string2);
    }

    public OracleXMLSQLException(String string) {
        super(string);
    }

    public OracleXMLSQLException(String string, String string2) {
        super(string);
        this.setErrorTag(string2);
    }

    public OracleXMLSQLException(String string, int n) {
        super(string);
        this.setSqlErrorCode(n);
    }

    public OracleXMLSQLException(String string, int n, String string2) {
        super(string);
        this.setSqlErrorCode(n);
        this.setErrorTag(string2);
    }

    public String getXMLErrorString() {
        StringBuffer stringBuffer = new StringBuffer("<" + this.errorTag + ">\n");
        stringBuffer.append(this.getMessage());
        stringBuffer.append("</" + this.errorTag + ">");
        return stringBuffer.toString();
    }

    public String getXMLSQLErrorString() {
        StringBuffer stringBuffer = new StringBuffer("<" + this.errorTag + ">\n");
        stringBuffer.append("  <MESSAGE>\n    " + this.getMessage() + "  </MESSAGE>\n");
        if (this.sqlState != null) {
            stringBuffer.append("  <SQLSTATE>" + this.sqlState + "</SQLSTATE>\n");
        }
        if (this.errCodeSet) {
            stringBuffer.append("  <ERRORCODE>" + this.sqlErrorCode + "</ERRORCODE>\n");
        }
        stringBuffer.append("</" + this.errorTag + ">");
        return stringBuffer.toString();
    }

    public Exception getParentException() {
        return this.parentE;
    }

    public void setErrorTag(String string) {
        if (string != null) {
            this.errorTag = string;
        }
    }

    public int getErrorCode() {
        return this.sqlErrorCode;
    }

    private void setParentE(Exception exception) {
        this.parentE = exception;
        if (exception instanceof SQLException) {
            this.setSqlState(((SQLException)exception).getSQLState());
            this.setSqlErrorCode(((SQLException)exception).getErrorCode());
        }
    }

    private void setSqlState(String string) {
        this.sqlState = string;
    }

    private void setSqlErrorCode(int n) {
        this.sqlErrorCode = n;
        this.errCodeSet = true;
    }

    private static String getExceptionMessage(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.getClass().getName();
        }
        return string;
    }
}

