/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.query;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.jdbc.OracleDriver;
import oracle.sql.CLOB;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSULocale;
import oracle.xml.sql.XSUMesg;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import oracle.xml.sql.docgen.OracleXMLDocGenLob;
import oracle.xml.sql.query.OracleXMLQuery;

public class OracleXMLStaticQuery {
    private static final String DBENCODING = "_";
    private static Connection conn = null;
    private static String connEnc = null;
    private static Hashtable ctxPool = null;
    private static int ctxHdlSeq = 0;
    private static MutableInt ctxHdlWrap = null;
    private static XSUMesg msg = OracleXMLConvert.msg;

    public static int newContext(String string) throws SQLException, IOException {
        StringReader stringReader = new StringReader(string);
        int n = OracleXMLStaticQuery.newContext(stringReader);
        ((Reader)stringReader).close();
        return n;
    }

    public static int newContext(CLOB cLOB) throws SQLException, IOException {
        Reader reader = cLOB.getCharacterStream();
        int n = OracleXMLStaticQuery.newContext(reader);
        reader.close();
        return n;
    }

    private static int newContext(Reader reader) throws SQLException {
        if (ctxPool == null) {
            conn = new OracleDriver().defaultConnection();
            ctxPool = new Hashtable(10);
            ctxHdlWrap = new MutableInt();
        }
        QueryCtx queryCtx = new QueryCtx(reader);
        OracleXMLStaticQuery.ctxHdlWrap.value = ctxHdlSeq;
        ctxPool.put(ctxHdlWrap, queryCtx);
        return ctxHdlSeq++;
    }

    public static void closeContext(int n) throws SQLException, IOException {
        OracleXMLStaticQuery.ctxHdlWrap.value = n;
        QueryCtx queryCtx = (QueryCtx)ctxPool.remove(ctxHdlWrap);
        if (queryCtx == null) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0100"));
        }
        queryCtx.close();
    }

    private static QueryCtx getCtx(int n) {
        OracleXMLStaticQuery.ctxHdlWrap.value = n;
        QueryCtx queryCtx = (QueryCtx)ctxPool.get(ctxHdlWrap);
        if (queryCtx == null) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0100"));
        }
        return queryCtx;
    }

    public static void resetResultSet(int n) {
        OracleXMLStaticQuery.getCtx(n).query.resetResultSet();
    }

    public static void setRowsetTag(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setRowsetTag(string);
    }

    public static void setRowTag(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setRowTag(string);
    }

    public static void setErrorTag(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setErrorTag(string);
    }

    public static void setRowIdAttrName(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setRowIdAttrName(string);
    }

    public static void setRowIdAttrValue(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setRowIdAttrValue(string);
    }

    public static void setCollIdAttrName(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setCollIdAttrName(string);
    }

    public static void useTypeForCollElemTag(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).query.useTypeForCollElemTag(by != 0);
    }

    public static void useNullAttributeIndicator(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).query.useNullAttributeIndicator(by != 0);
    }

    public static void setSQLToXMLNameEscaping(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).query.setSQLToXMLNameEscaping(by != 0);
    }

    public static void setTagCase(int n, byte by) {
        if (by == 1) {
            OracleXMLStaticQuery.getCtx(n).query.useLowerCaseTagNames();
        } else if (by == 2) {
            OracleXMLStaticQuery.getCtx(n).query.useUpperCaseTagNames();
        }
    }

    public static void setDateFormat(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.setDateFormat(string);
    }

    public static void setMaxRows(int n, int n2) {
        OracleXMLStaticQuery.getCtx(n).query.setMaxRows(n2);
    }

    public static void setSkipRows(int n, int n2) {
        OracleXMLStaticQuery.getCtx(n).query.setSkipRows(n2);
    }

    public static void setStylesheetHeader(int n, String string, String string2) {
        OracleXMLStaticQuery.getCtx(n).query.setStylesheetHeader(string, string2);
    }

    public static void setXSLT(int n, String string, String string2) {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        queryCtx.xsltSet = string != null;
        queryCtx.query.setXSLT(string, string2);
    }

    public static void setXSLT(int n, CLOB cLOB, String string) throws SQLException, IOException {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        Reader reader = null;
        if (cLOB != null) {
            reader = cLOB.getCharacterStream();
            queryCtx.xsltSet = true;
        } else {
            reader = null;
            queryCtx.xsltSet = false;
        }
        queryCtx.query.setXSLT(reader, string);
        if (reader != null) {
            reader.close();
        }
    }

    public static void setXSLTParam(int n, String string, String string2) {
        OracleXMLStaticQuery.getCtx(n).query.setXSLTParam(string, string2);
    }

    public static void removeXSLTParam(int n, String string) {
        OracleXMLStaticQuery.getCtx(n).query.removeXSLTParam(string);
    }

    public static void setEncodingTag(int n, String string) {
        if (string != null && string.compareTo(DBENCODING) == 0) {
            if (connEnc == null) {
                connEnc = System.getProperty("file.encoding");
            }
            connEnc = XSULocale.getIANACharset(connEnc);
            OracleXMLStaticQuery.getCtx(n).query.setEncoding(connEnc);
        } else {
            OracleXMLStaticQuery.getCtx(n).query.setEncoding(string);
        }
    }

    public static void setBindValue(int n, String string, String string2) {
        Exception exception = null;
        try {
            OracleXMLStaticQuery.getCtx(n).dset.bindValue(string, string2);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            OracleXMLStaticQuery.getCtx(n).query.setException(exception);
        }
    }

    public static void clearBindValues(int n) {
        Exception exception = null;
        try {
            OracleXMLStaticQuery.getCtx(n).dset.clearBindValues();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            OracleXMLStaticQuery.getCtx(n).query.setException(exception);
        }
    }

    public static void setMetaHeader(int n, CLOB cLOB) throws SQLException, IOException {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        queryCtx.metaHeader = cLOB.getCharacterStream();
        queryCtx.query.setMetaHeader(queryCtx.metaHeader);
    }

    public static void setDataHeader(int n, CLOB cLOB, String string) throws SQLException, IOException {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        queryCtx.dataHeader = cLOB.getCharacterStream();
        queryCtx.query.setDataHeader(queryCtx.dataHeader, string);
    }

    public static void setRaiseException(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).query.setRaiseException(by != 0);
    }

    public static void setRaiseNoRowsException(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).query.setRaiseNoRowsException(by != 0);
    }

    public static void propagateOriginalException(int n, byte by) {
        OracleXMLStaticQuery.getCtx(n).propOriginalExc = by != 0;
    }

    public static void getExceptionContent(int n, int[] nArray, String[] stringArray) {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        nArray[0] = queryCtx.errCode;
        stringArray[0] = queryCtx.errMsg;
    }

    public static void setStrictLegalXMLCharCheck(int n, byte by) {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        if (queryCtx.query == null) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0100"));
        }
        boolean bl = by != 0;
        queryCtx.useStrictLegalXMLCharCheck = bl;
        queryCtx.query.setStrictLegalXMLCharCheck(bl);
    }

    public static void getDTD(int n, CLOB cLOB, byte by) throws Exception {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        try {
            OracleXMLDocGenLob oracleXMLDocGenLob = new OracleXMLDocGenLob(conn, cLOB);
            oracleXMLDocGenLob.setStrictLegalXMLCharCheck(queryCtx.useStrictLegalXMLCharCheck);
            queryCtx.query.getXMLMetaData(1, by != 0, oracleXMLDocGenLob);
            oracleXMLDocGenLob.flush();
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            queryCtx.errCode = oracleXMLSQLException.getErrorCode();
            queryCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw queryCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static void getXML(int n, CLOB cLOB, byte by) throws Exception {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        Writer writer = null;
        try {
            if (queryCtx.xsltSet || by == 2) {
                writer = cLOB.getCharacterOutputStream();
                queryCtx.query.getXMLStream(null, by, writer);
            } else {
                OracleXMLDocGenLob oracleXMLDocGenLob = new OracleXMLDocGenLob(conn, cLOB);
                oracleXMLDocGenLob.setStrictLegalXMLCharCheck(queryCtx.useStrictLegalXMLCharCheck);
                queryCtx.query.getXML((OracleXMLDocGen)oracleXMLDocGenLob, by);
                oracleXMLDocGenLob.flush();
            }
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            queryCtx.errCode = oracleXMLSQLException.getErrorCode();
            queryCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw queryCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static String getXML(int n, byte by) throws Exception {
        QueryCtx queryCtx = OracleXMLStaticQuery.getCtx(n);
        Object var4_3 = null;
        CLOB cLOB = OracleXMLDataSetExtJdbc.createTempCLOBFromString(conn, "hi:  \n", null);
        OracleXMLStaticQuery.getXML(n, cLOB, by);
        return cLOB.getSubString(1L, (int)cLOB.length());
    }

    public static long getNumRowsProcessed(int n) {
        return OracleXMLStaticQuery.getCtx(n).query.getNumRowsProcessed();
    }

    public static int newContext(Connection connection, String string) throws SQLException, IOException {
        conn = connection;
        if (ctxPool == null) {
            ctxPool = new Hashtable(10);
            ctxHdlWrap = new MutableInt();
        }
        StringReader stringReader = new StringReader(string);
        QueryCtx queryCtx = new QueryCtx(stringReader);
        ((Reader)stringReader).close();
        OracleXMLStaticQuery.ctxHdlWrap.value = ctxHdlSeq;
        ctxPool.put(ctxHdlWrap, queryCtx);
        return ctxHdlSeq++;
    }

    private static class QueryCtx {
        private OracleXMLQuery query = null;
        private OracleXMLDataSetExtJdbc dset = null;
        private boolean propOriginalExc = false;
        private boolean useStrictLegalXMLCharCheck = false;
        private int errCode = 0;
        private String errMsg = null;
        private boolean xsltSet = false;
        private Reader qRdr = null;
        private Reader metaHeader = null;
        private Reader dataHeader = null;

        QueryCtx(Reader reader) {
            Exception exception = null;
            try {
                this.qRdr = new BufferedReader(reader);
                this.dset = new OracleXMLDataSetExtJdbc(conn, this.qRdr);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            this.query = new OracleXMLQuery(this.dset);
            if (exception != null) {
                this.query.setException(exception);
            }
        }

        private void close() throws SQLException, IOException {
            this.query.close();
            if (this.dset != null) {
                this.dset.close();
                this.dset = null;
            }
            if (this.qRdr != null) {
                this.qRdr.close();
                this.qRdr = null;
            }
            if (this.metaHeader != null) {
                this.metaHeader.close();
                this.metaHeader = null;
            }
            if (this.dataHeader != null) {
                this.dataHeader.close();
                this.dataHeader = null;
            }
        }
    }

    private static class MutableInt {
        public int value = 0;

        private MutableInt() {
        }

        public int hashCode() {
            return this.value;
        }
    }
}

