/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.gui.DoubleWorksheet;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.gui.ScratchController;
import oracle.dbtools.migration.gui.ScratchNode;
import oracle.dbtools.migration.gui.babelfish.BabelfishDbaNavController;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationMenuManager;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.util.MenuSpec;

public class ScratchEditorAddin
extends EditorAddin {
    public static final int SCRATCH_ID = Ide.findOrCreateCmdID((String)"migration.scratcheditor");
    public static final IdeAction m_action = IdeAction.get((int)SCRATCH_ID, null, (String)StringUtils.stripMnemonic((String)SEMessages.getString("ScratchNode.2")), null, null, (Icon)SEMessages.getIcon("SCRATCH_COMMAND_ICON"), null, (boolean)true);
    private Class m_editor = DoubleWorksheet.class;
    public static final IdeAction m_installsqltranslatorAction = IdeAction.get((int)BabelfishDbaNavController.INSTALL_SQLTRANSLATOR_ID);

    public Class getEditorClass() {
        return this.m_editor;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec("hello", null, null);
    }

    public void initialize() {
        try {
            Ide.addIdeListener((IdeListener)new loadMigrationMenuLaterListener());
            Class[] classArray = new Class[]{ScratchNode.class};
            EditorManager.getEditorManager().register((EditorAddin)this, classArray);
            m_action.addController((Controller)ScratchController.getInstance());
            m_installsqltranslatorAction.addController(BabelfishDbaNavController.getInstance());
        }
        catch (RuntimeException runtimeException) {
            LogManager.getLogManager().getMsgPage().log((Object)("runtime error" + runtimeException.getLocalizedMessage()));
        }
        catch (Exception exception) {
            LogManager.getLogManager().getMsgPage().log((Object)("runtime error:" + exception.getLocalizedMessage()));
        }
    }

    private class loadMigrationMenuLaterListener
    implements IdeListener {
        private loadMigrationMenuLaterListener() {
        }

        public void addinsLoaded(IdeEvent ideEvent) {
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
            this.addToMigrationMenu();
        }

        private void addToMigrationMenu() {
            if (MigrationAddin.getMigrationMenuManager() != null) {
                JMenuItem jMenuItem = new JMenuItem((Action)m_action);
                jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)SEMessages.getString("ScratchNode.2")));
                MigrationMenuManager migrationMenuManager = MigrationAddin.getMigrationMenuManager();
                migrationMenuManager.addMenuItem(jMenuItem, false, 100);
            }
        }
    }
}

