/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

public final class TruffleStackTraceElement {
    private final Node location;
    private final RootCallTarget target;
    private final Frame frame;

    TruffleStackTraceElement(Node location, RootCallTarget target, Frame frame) {
        this.location = location;
        this.target = target;
        this.frame = frame;
    }

    public Node getLocation() {
        return this.location;
    }

    public RootCallTarget getTarget() {
        return this.target;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public static List<TruffleStackTraceElement> getStackTrace(Throwable throwable) {
        return TruffleStackTrace.find(throwable);
    }

    public static void fillIn(Throwable throwable) {
        TruffleStackTrace.fillIn(throwable);
    }
}

