/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.debug.BreakpointExceptionFilter;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebugStackTraceElement;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DebugException
extends RuntimeException {
    private static final long serialVersionUID = 5017970176581546348L;
    private final Debugger debugger;
    private final TruffleException exception;
    private final LanguageInfo preferredLanguage;
    private final Node throwLocation;
    private volatile boolean isCatchNodeComputed;
    private volatile CatchLocation catchLocation;
    private SuspendedEvent suspendedEvent;
    private List<DebugStackTraceElement> debugStackTrace;
    private StackTraceElement[] javaLikeStackTrace;

    DebugException(Debugger debugger, String message, Node throwLocation, boolean isCatchNodeComputed, CatchLocation catchLocation) {
        super(message);
        this.debugger = debugger;
        this.exception = null;
        this.preferredLanguage = null;
        this.throwLocation = throwLocation;
        this.isCatchNodeComputed = isCatchNodeComputed;
        this.catchLocation = catchLocation;
    }

    DebugException(Debugger debugger, TruffleException exception, LanguageInfo preferredLanguage, Node throwLocation, boolean isCatchNodeComputed, CatchLocation catchLocation) {
        super(((Throwable)((Object)exception)).getLocalizedMessage());
        this.debugger = debugger;
        this.exception = exception;
        this.preferredLanguage = preferredLanguage;
        this.throwLocation = throwLocation;
        this.isCatchNodeComputed = isCatchNodeComputed;
        this.catchLocation = catchLocation;
    }

    void setSuspendedEvent(SuspendedEvent suspendedEvent) {
        if (this.catchLocation != null) {
            this.catchLocation.setSuspendedEvent(suspendedEvent);
        }
        this.suspendedEvent = suspendedEvent;
    }

    TruffleException getTruffleException() {
        return this.exception;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            if (stackTrace[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (this.javaLikeStackTrace == null) {
            List<DebugStackTraceElement> debugStack = this.getDebugStackTrace();
            int size = debugStack.size();
            this.javaLikeStackTrace = new StackTraceElement[size];
            for (int i = 0; i < size; ++i) {
                this.javaLikeStackTrace[i] = debugStack.get(i).toTraceElement();
            }
        }
        return (StackTraceElement[])this.javaLikeStackTrace.clone();
    }

    public List<DebugStackTraceElement> getDebugStackTrace() {
        if (this.debugStackTrace == null) {
            if (this.exception != null) {
                TruffleStackTraceElement.fillIn((Throwable)((Object)this.exception));
                List<TruffleStackTraceElement> stackTrace = TruffleStackTraceElement.getStackTrace((Throwable)((Object)this.exception));
                int n = stackTrace.size();
                ArrayList<DebugStackTraceElement> debugStack = new ArrayList<DebugStackTraceElement>(n);
                for (int i = 0; i < n; ++i) {
                    TruffleStackTraceElement tframe = stackTrace.get(i);
                    RootNode root = tframe.getTarget().getRootNode();
                    if (root.getLanguageInfo() == null) continue;
                    debugStack.add(new DebugStackTraceElement(this.debugger, tframe));
                }
                this.debugStackTrace = Collections.unmodifiableList(debugStack);
            } else {
                this.debugStackTrace = Collections.emptyList();
            }
        }
        return this.debugStackTrace;
    }

    public boolean isInternalError() {
        return this.exception != null && this.exception.isInternalError();
    }

    public DebugValue getExceptionObject() {
        RootNode throwRoot;
        if (this.exception == null) {
            return null;
        }
        Object obj = this.exception.getExceptionObject();
        if (obj == null) {
            return null;
        }
        LanguageInfo language = this.preferredLanguage;
        if (language == null && this.throwLocation != null && (throwRoot = this.throwLocation.getRootNode()) != null) {
            language = throwRoot.getLanguageInfo();
        }
        return new DebugValue.HeapValue(this.debugger, language, null, obj);
    }

    public SourceSection getThrowLocation() {
        SourceSection location;
        if (this.exception != null && (location = this.exception.getSourceLocation()) != null) {
            return location;
        }
        if (this.throwLocation != null) {
            return this.throwLocation.getSourceSection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatchLocation getCatchLocation() {
        if (!this.isCatchNodeComputed) {
            DebugException debugException = this;
            synchronized (debugException) {
                if (!this.isCatchNodeComputed) {
                    this.catchLocation = BreakpointExceptionFilter.getCatchNode(this.debugger, this.throwLocation, (Throwable)((Object)this.exception));
                    if (this.catchLocation != null) {
                        this.catchLocation.setSuspendedEvent(this.suspendedEvent);
                    }
                    this.isCatchNodeComputed = true;
                }
            }
        }
        return this.catchLocation;
    }

    public static final class CatchLocation {
        private final SourceSection section;
        private final FrameInstance frameInstance;
        private final int depth;
        private DebugStackFrame frame;

        CatchLocation(SourceSection section, FrameInstance frameInstance, int depth) {
            this.section = section;
            this.frameInstance = frameInstance;
            this.depth = depth;
        }

        public SourceSection getSourceSection() {
            return this.section;
        }

        public DebugStackFrame getFrame() {
            return this.frame;
        }

        void setSuspendedEvent(SuspendedEvent suspendedEvent) {
            this.frame = new DebugStackFrame(suspendedEvent, this.depth == 0 ? null : this.frameInstance, this.depth);
        }
    }
}

