/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SuspendedContext;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class DebugStackFrame
implements Iterable<DebugValue> {
    final SuspendedEvent event;
    private final FrameInstance currentFrame;
    private final int depth;

    DebugStackFrame(SuspendedEvent session, FrameInstance instance, int depth) {
        this.event = session;
        this.currentFrame = instance;
        this.depth = depth;
    }

    public boolean isInternal() {
        this.verifyValidState(true);
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return true;
        }
        return root.isInternal();
    }

    public String getName() {
        this.verifyValidState(true);
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return null;
        }
        try {
            return root.getName();
        }
        catch (Throwable e) {
            try {
                assert (false);
            }
            catch (AssertionError e1) {
                throw e;
            }
            return null;
        }
    }

    public SourceSection getSourceSection() {
        this.verifyValidState(true);
        if (this.currentFrame == null) {
            SuspendedContext context = this.getContext();
            return context.getInstrumentedSourceSection();
        }
        Node callNode = this.currentFrame.getCallNode();
        if (callNode != null) {
            return callNode.getEncapsulatingSourceSection();
        }
        return null;
    }

    public DebugScope getScope() {
        this.verifyValidState(false);
        SuspendedContext context = this.getContext();
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return null;
        }
        Node node = this.currentFrame == null ? context.getInstrumentedNode() : this.currentFrame.getCallNode();
        if (node.getRootNode().getLanguageInfo() == null) {
            return null;
        }
        Debugger debugger = this.event.getSession().getDebugger();
        MaterializedFrame frame = this.findTruffleFrame();
        Iterable<Scope> scopes = debugger.getEnv().findLocalScopes(node, frame);
        Iterator<Scope> it = scopes.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return new DebugScope(it.next(), it, debugger, this.event, frame, root);
    }

    @Deprecated
    public DebugValue getValue(String name) {
        for (DebugScope scope = this.getScope(); scope != null; scope = scope.getParent()) {
            DebugValue value = scope.getDeclaredValue(name);
            if (value != null) {
                return value;
            }
            if (scope.isFunctionScope()) break;
        }
        return null;
    }

    DebugValue wrapHeapValue(Object result) {
        RootNode root = this.findCurrentRoot();
        LanguageInfo language = root != null ? root.getLanguageInfo() : null;
        return new DebugValue.HeapValue(this.event.getSession().getDebugger(), language, null, result);
    }

    public DebugValue eval(String code) throws DebugException {
        this.verifyValidState(false);
        Object result = DebuggerSession.evalInContext(this.event, code, this.currentFrame);
        return this.wrapHeapValue(result);
    }

    @Override
    @Deprecated
    public Iterator<DebugValue> iterator() {
        final DebugScope cscope = this.getScope();
        return new Iterator<DebugValue>(){
            private DebugScope scope;
            private Iterator<DebugValue> variables;
            private DebugValue nextVar;
            private Set<String> names;
            {
                this.scope = cscope;
                this.names = new HashSet<String>();
            }

            @Override
            public boolean hasNext() {
                if (this.nextVar != null) {
                    return true;
                }
                while (true) {
                    if (this.variables == null && this.scope != null) {
                        this.variables = this.scope.getDeclaredValues().iterator();
                        if (!this.variables.hasNext()) {
                            this.variables = null;
                        }
                        this.scope = this.scope.isFunctionScope() ? null : this.scope.getParent();
                        if (this.variables == null) continue;
                    }
                    if (this.variables != null && this.variables.hasNext()) {
                        this.nextVar = this.variables.next();
                        String name = this.nextVar.getName();
                        if (this.names.contains(name)) continue;
                        this.names.add(name);
                        return true;
                    }
                    this.variables = null;
                    if (this.scope == null) break;
                }
                return false;
            }

            @Override
            public DebugValue next() {
                DebugValue var;
                if (this.nextVar == null) {
                    this.hasNext();
                }
                if ((var = this.nextVar) == null) {
                    throw new NoSuchElementException();
                }
                this.nextVar = null;
                return var;
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj instanceof DebugStackFrame) {
            DebugStackFrame other = (DebugStackFrame)obj;
            return this.event == other.event && (this.currentFrame == other.currentFrame || this.currentFrame != null && other.currentFrame != null && this.currentFrame.getFrame(FrameInstance.FrameAccess.READ_ONLY) == other.currentFrame.getFrame(FrameInstance.FrameAccess.READ_ONLY));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.event, this.currentFrame);
    }

    MaterializedFrame findTruffleFrame() {
        if (this.currentFrame == null) {
            return this.event.getMaterializedFrame();
        }
        return this.currentFrame.getFrame(FrameInstance.FrameAccess.MATERIALIZE).materialize();
    }

    int getDepth() {
        return this.depth;
    }

    private SuspendedContext getContext() {
        SuspendedContext context = this.event.getContext();
        if (context == null) {
            this.verifyValidState(true);
            assert (false) : "should not be reachable";
        }
        return context;
    }

    RootNode findCurrentRoot() {
        SuspendedContext context = this.getContext();
        if (this.currentFrame == null) {
            return context.getInstrumentedNode().getRootNode();
        }
        Node callNode = this.currentFrame.getCallNode();
        if (callNode != null) {
            return callNode.getRootNode();
        }
        CallTarget target = this.currentFrame.getCallTarget();
        if (target instanceof RootCallTarget) {
            return ((RootCallTarget)target).getRootNode();
        }
        return null;
    }

    void verifyValidState(boolean allowDifferentThread) {
        this.event.verifyValidState(allowDifferentThread);
    }
}

