/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

abstract class SetThreadSuspensionEnabledNode
extends Node {
    static final int CACHE_LIMIT = 10;

    SetThreadSuspensionEnabledNode() {
    }

    public final void execute(boolean suspensionEnabled, DebuggerSession[] sessions) {
        this.execute(suspensionEnabled, sessions, Thread.currentThread().getId());
    }

    protected abstract void execute(boolean var1, DebuggerSession[] var2, long var3);

    @Specialization(guards={"sessions.length == 1", "threadId == currentThreadId"}, limit="CACHE_LIMIT")
    protected void executeCached(boolean suspensionEnabled, DebuggerSession[] sessions, long threadId, @Cached(value="currentThreadId()") long currentThreadId, @Cached(value="getThreadSuspension(sessions)") DebuggerSession.ThreadSuspension threadSuspension) {
        threadSuspension.enabled = suspensionEnabled;
    }

    @ExplodeLoop
    @Specialization(replaces={"executeCached"})
    protected void executeGeneric(boolean suspensionEnabled, DebuggerSession[] sessions, long threadId) {
        for (DebuggerSession session : sessions) {
            session.setThreadSuspendEnabled(suspensionEnabled);
        }
    }

    static long currentThreadId() {
        return Thread.currentThread().getId();
    }

    @CompilerDirectives.TruffleBoundary
    protected DebuggerSession.ThreadSuspension getThreadSuspension(DebuggerSession[] sessions) {
        assert (sessions.length == 1);
        DebuggerSession.ThreadSuspension threadSuspension = new DebuggerSession.ThreadSuspension(true);
        sessions[0].threadSuspensions.set(threadSuspension);
        return threadSuspension;
    }
}

