/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.nodes.LanguageInfo;
import java.util.AbstractList;
import java.util.List;

final class ValueInteropList
extends AbstractList<DebugValue> {
    private final Debugger debugger;
    private final LanguageInfo language;
    private final List<Object> list;

    ValueInteropList(Debugger debugger, LanguageInfo language, List<Object> list) {
        this.debugger = debugger;
        this.language = language;
        this.list = list;
    }

    @Override
    public DebugValue get(int index) {
        Object obj = this.list.get(index);
        String name = Integer.toString(index);
        DebugValue.HeapValue dv = new DebugValue.HeapValue(this.debugger, this.language, name, obj);
        return dv;
    }

    @Override
    public DebugValue set(int index, DebugValue value) {
        DebugValue old = this.get(index);
        this.list.set(index, value.get());
        return old;
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

