/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.frame;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.impl.Accessor;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;

public final class FrameDescriptor
implements Cloneable {
    private final Object defaultValue;
    private final ArrayList<FrameSlot> slots;
    private final EconomicMap<Object, FrameSlot> identifierToSlotMap;
    private Assumption version;
    private EconomicMap<Object, Assumption> identifierToNotInFrameAssumptionMap;
    private int size;
    boolean materializeCalled;
    private static final String NEVER_PART_OF_COMPILATION_MESSAGE = "interpreter-only. includes hashmap operations.";

    public FrameDescriptor() {
        this(null);
    }

    public FrameDescriptor(Object defaultValue) {
        CompilerAsserts.neverPartOfCompilation("do not create a FrameDescriptor from compiled code");
        this.defaultValue = defaultValue;
        this.slots = new ArrayList();
        this.identifierToSlotMap = EconomicMap.create();
        this.version = FrameDescriptor.createVersion();
    }

    public FrameSlot addFrameSlot(Object identifier) {
        return this.addFrameSlot(identifier, null, FrameSlotKind.Illegal);
    }

    public FrameSlot addFrameSlot(Object identifier, FrameSlotKind kind) {
        return this.addFrameSlot(identifier, null, kind);
    }

    public FrameSlot addFrameSlot(Object identifier, Object info, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(kind, "kind");
        if (this.identifierToSlotMap.containsKey(identifier)) {
            throw new IllegalArgumentException("duplicate frame slot: " + identifier);
        }
        FrameSlot slot = new FrameSlot(this, identifier, info, kind, this.size);
        ++this.size;
        this.slots.add(slot);
        this.identifierToSlotMap.put(identifier, (Object)slot);
        this.updateVersion();
        this.invalidateNotInFrameAssumption(identifier);
        return slot;
    }

    public FrameSlot findFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        return (FrameSlot)this.identifierToSlotMap.get(identifier);
    }

    public FrameSlot findOrAddFrameSlot(Object identifier) {
        FrameSlot result = this.findFrameSlot(identifier);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier);
    }

    public FrameSlot findOrAddFrameSlot(Object identifier, FrameSlotKind kind) {
        FrameSlot result = this.findFrameSlot(identifier);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier, kind);
    }

    public FrameSlot findOrAddFrameSlot(Object identifier, Object info, FrameSlotKind kind) {
        FrameSlot result = this.findFrameSlot(identifier);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier, info, kind);
    }

    public void removeFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameSlot slot = (FrameSlot)this.identifierToSlotMap.get(identifier);
        if (slot == null) {
            throw new IllegalArgumentException("no such frame slot: " + identifier);
        }
        this.slots.remove(slot);
        this.identifierToSlotMap.removeKey(identifier);
        this.updateVersion();
        this.getNotInFrameAssumption(identifier);
    }

    public int getSize() {
        return this.size;
    }

    public List<? extends FrameSlot> getSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    public Set<Object> getIdentifiers() {
        return FrameDescriptor.unmodifiableSetFromEconomicMap(this.identifierToSlotMap);
    }

    private static <K> Set<K> unmodifiableSetFromEconomicMap(final EconomicMap<K, ?> map) {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<K> it;
                    {
                        this.it = map.getKeys().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public K next() {
                        return this.it.next();
                    }
                };
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean contains(Object o) {
                return map.containsKey(o);
            }

            @Override
            public boolean add(K e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends K> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(Predicate<? super K> filter) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FrameDescriptor copy() {
        FrameDescriptor clonedFrameDescriptor = new FrameDescriptor(this.defaultValue);
        for (int i = 0; i < this.slots.size(); ++i) {
            FrameSlot slot = this.slots.get(i);
            clonedFrameDescriptor.addFrameSlot(slot.getIdentifier(), slot.getInfo(), FrameSlotKind.Illegal);
        }
        return clonedFrameDescriptor;
    }

    public FrameDescriptor shallowCopy() {
        FrameDescriptor clonedFrameDescriptor = new FrameDescriptor(this.defaultValue);
        clonedFrameDescriptor.slots.addAll(this.slots);
        clonedFrameDescriptor.identifierToSlotMap.putAll(this.identifierToSlotMap);
        clonedFrameDescriptor.size = this.size;
        return clonedFrameDescriptor;
    }

    void updateVersion() {
        this.version.invalidate();
        this.version = FrameDescriptor.createVersion();
    }

    public Assumption getVersion() {
        return this.version;
    }

    private static Assumption createVersion() {
        return Truffle.getRuntime().createAssumption("frame version");
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Assumption getNotInFrameAssumption(Object identifier) {
        Assumption assumption;
        if (this.identifierToSlotMap.containsKey(identifier)) {
            throw new IllegalArgumentException("Cannot get not-in-frame assumption for existing frame slot!");
        }
        if (this.identifierToNotInFrameAssumptionMap == null) {
            this.identifierToNotInFrameAssumptionMap = EconomicMap.create();
        } else {
            assumption = (Assumption)this.identifierToNotInFrameAssumptionMap.get(identifier);
            if (assumption != null) {
                return assumption;
            }
        }
        assumption = Truffle.getRuntime().createAssumption("identifier not in frame");
        this.identifierToNotInFrameAssumptionMap.put(identifier, (Object)assumption);
        return assumption;
    }

    private void invalidateNotInFrameAssumption(Object identifier) {
        Assumption assumption;
        if (this.identifierToNotInFrameAssumptionMap != null && (assumption = (Assumption)this.identifierToNotInFrameAssumptionMap.get(identifier)) != null) {
            assumption.invalidate();
            this.identifierToNotInFrameAssumptionMap.removeKey(identifier);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FrameDescriptor@").append(Integer.toHexString(this.hashCode()));
        sb.append("{");
        boolean comma = false;
        for (FrameSlot slot : this.slots) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(slot.getIndex()).append(":").append(slot.getIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    static {
        AccessorFrames accessorFrames = new AccessorFrames();
    }

    static final class AccessorFrames
    extends Accessor {
        AccessorFrames() {
        }

        @Override
        protected Accessor.Frames framesSupport() {
            return new FramesImpl();
        }

        static final class FramesImpl
        extends Accessor.Frames {
            FramesImpl() {
            }

            @Override
            protected void markMaterializeCalled(FrameDescriptor descriptor) {
                descriptor.materializeCalled = true;
            }

            @Override
            protected boolean getMaterializeCalled(FrameDescriptor descriptor) {
                return descriptor.materializeCalled;
            }
        }
    }
}

