/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Objects;
import java.util.function.Supplier;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

public abstract class TVMCI {
    private static volatile Object fallbackEngineData;

    protected TVMCI() {
        assert (this.checkCaller());
    }

    private boolean checkCaller() {
        String packageName = this.getClass().getPackage().getName();
        assert (packageName.equals("org.graalvm.compiler.truffle.runtime") || packageName.equals("org.graalvm.graal.truffle") || packageName.equals("com.oracle.graal.truffle") || packageName.equals("com.oracle.truffle.api.impl")) : TVMCI.class.getName() + " subclass is not in trusted package: " + this.getClass().getName();
        return true;
    }

    protected abstract void onLoopCount(Node var1, int var2);

    protected void onLoad(RootNode rootNode) {
        Accessor.InstrumentSupport support = Accessor.instrumentAccess();
        if (support != null) {
            support.onLoad(rootNode);
        }
    }

    protected void onFirstExecution(RootNode rootNode) {
        Accessor.InstrumentSupport accessor = Accessor.instrumentAccess();
        if (accessor != null) {
            accessor.onFirstExecution(rootNode);
        }
    }

    @Deprecated
    protected Class<? extends TruffleLanguage> findLanguageClass(RootNode root) {
        return root.getLanguage(TruffleLanguage.class).getClass();
    }

    protected void markFrameMaterializeCalled(FrameDescriptor descriptor) {
        Accessor.framesAccess().markMaterializeCalled(descriptor);
    }

    protected boolean getFrameMaterializeCalled(FrameDescriptor descriptor) {
        return Accessor.framesAccess().getMaterializeCalled(descriptor);
    }

    protected boolean isCloneUninitializedSupported(RootNode root) {
        return Accessor.nodesAccess().isCloneUninitializedSupported(root);
    }

    protected void onThrowable(Node callNode, RootCallTarget root, Throwable e, Frame frame) {
        Accessor.LanguageSupport language = Accessor.languageAccess();
        if (language != null) {
            language.onThrowable(callNode, root, e, frame);
        }
    }

    protected RootNode cloneUninitialized(RootNode root) {
        return Accessor.nodesAccess().cloneUninitialized(root);
    }

    protected int adoptChildrenAndCount(RootNode root) {
        return Accessor.nodesAccess().adoptChildrenAndCount(root);
    }

    protected OptionDescriptors getCompilerOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    protected OptionValues getCompilerOptionValues(RootNode rootNode) {
        Accessor.EngineSupport engine = Accessor.engineAccess();
        return engine != null ? engine.getCompilerOptionValues(rootNode) : null;
    }

    protected boolean isGuestCallStackFrame(StackTraceElement e) {
        return false;
    }

    protected void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
    }

    protected Object callProfiled(CallTarget target, Object ... args) {
        return target.call(args);
    }

    protected <T> T getOrCreateRuntimeData(RootNode rootNode, Supplier<T> constructor) {
        T runtimeData;
        Object sourceVM;
        Objects.requireNonNull(constructor);
        Accessor.Nodes nodesAccess = Accessor.nodesAccess();
        Accessor.EngineSupport engineAccess = Accessor.engineAccess();
        if (rootNode != null && nodesAccess != null && engineAccess != null && (sourceVM = nodesAccess.getSourceVM(rootNode)) != null && (runtimeData = engineAccess.getOrCreateRuntimeData(sourceVM, constructor)) != null) {
            return runtimeData;
        }
        return TVMCI.getOrCreateFallbackEngineData(constructor);
    }

    private static <T> T getOrCreateFallbackEngineData(Supplier<T> constructor) {
        if (fallbackEngineData == null) {
            fallbackEngineData = constructor.get();
        }
        return (T)fallbackEngineData;
    }

    protected void reportPolymorphicSpecialize(Node node) {
    }

    public static class TestAccessor<T extends CallTarget> {
        private final Test<T> testTvmci;

        protected TestAccessor(Test<T> testTvmci) {
            if (!this.getClass().getPackage().getName().equals("com.oracle.truffle.tck")) {
                throw new IllegalStateException();
            }
            this.testTvmci = testTvmci;
        }

        protected final T createTestCallTarget(RootNode testNode) {
            return this.testTvmci.createTestCallTarget(testNode);
        }

        protected final void finishWarmup(T callTarget, String testName) {
            this.testTvmci.finishWarmup(callTarget, testName);
        }
    }

    public static abstract class Test<T extends CallTarget> {
        protected abstract T createTestCallTarget(RootNode var1);

        protected abstract void finishWarmup(T var1, String var2);
    }
}

