/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class TruffleLocator {
    private static TruffleLocator nativeImageLocator;
    private static final AtomicBoolean NATIVE_IMAGE_LOCATOR_INITIALIZED;

    public static Set<ClassLoader> loaders() {
        TruffleLocator locator = Truffle.getRuntime().getCapability(TruffleLocator.class);
        Collection<Object> allLocators = locator != null ? Collections.singleton(locator) : Collections.emptyList();
        LinkedHashSet<ClassLoader> found = new LinkedHashSet<ClassLoader>();
        Response response = new Response(found);
        for (TruffleLocator truffleLocator : allLocators) {
            truffleLocator.locate(response);
        }
        found.add(ClassLoader.getSystemClassLoader());
        found.add(TruffleLocator.class.getClassLoader());
        return found;
    }

    static Class<?> loadClass(String name) {
        for (ClassLoader loader : TruffleLocator.loaders()) {
            if (loader == null) continue;
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    static void initializeNativeImageTruffleLocator() {
        assert (TruffleOptions.AOT) : "Only supported in AOT mode.";
        if (nativeImageLocator != null && NATIVE_IMAGE_LOCATOR_INITIALIZED.compareAndSet(false, true)) {
            nativeImageLocator.locate(new Response(new HashSet<ClassLoader>()));
        }
    }

    protected abstract void locate(Response var1);

    private static void initializeNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageLocator = Truffle.getRuntime().getCapability(TruffleLocator.class);
    }

    private static void resetNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageLocator = null;
    }

    static {
        NATIVE_IMAGE_LOCATOR_INITIALIZED = new AtomicBoolean();
    }

    public static final class Response {
        private final Set<ClassLoader> loaders;

        Response(Set<ClassLoader> loaders) {
            this.loaders = loaders;
        }

        public void registerClassLoader(ClassLoader languageLoader) {
            this.loaders.add(languageLoader);
        }
    }
}

