/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.ArrayReadNodeGen;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.util.List;

abstract class ArrayReadNode
extends Node {
    ArrayReadNode() {
    }

    protected abstract Object executeWithTarget(JavaObject var1, Object var2);

    @Specialization(guards={"receiver.isArray()"})
    protected Object doArrayIntIndex(JavaObject receiver, int index) {
        return ArrayReadNode.doArrayAccess(receiver, index);
    }

    @Specialization(guards={"receiver.isArray()", "index.getClass() == clazz"}, replaces={"doArrayIntIndex"})
    protected Object doArrayCached(JavaObject receiver, Number index, @Cached(value="index.getClass()") Class<? extends Number> clazz) {
        return ArrayReadNode.doArrayAccess(receiver, clazz.cast(index).intValue());
    }

    @Specialization(guards={"receiver.isArray()"}, replaces={"doArrayCached"})
    protected Object doArrayGeneric(JavaObject receiver, Number index) {
        return ArrayReadNode.doArrayAccess(receiver, index.intValue());
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isList(receiver)"})
    protected Object doListIntIndex(JavaObject receiver, int index) {
        try {
            return JavaInterop.toGuestValue(((List)receiver.obj).get(index), receiver.languageContext);
        }
        catch (IndexOutOfBoundsException e) {
            CompilerDirectives.transferToInterpreter();
            throw UnknownIdentifierException.raise(String.valueOf(index));
        }
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isList(receiver)"}, replaces={"doListIntIndex"})
    protected Object doListGeneric(JavaObject receiver, Number index) {
        return this.doListIntIndex(receiver, index.intValue());
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!receiver.isArray()", "!isList(receiver)"})
    protected static Object notArray(JavaObject receiver, Number index) {
        throw UnsupportedMessageException.raise(Message.READ);
    }

    private static Object doArrayAccess(JavaObject object, int index) {
        Object obj = object.obj;
        assert (object.isArray());
        Object val = null;
        try {
            val = Array.get(obj, index);
        }
        catch (ArrayIndexOutOfBoundsException outOfBounds) {
            CompilerDirectives.transferToInterpreter();
            throw UnknownIdentifierException.raise(String.valueOf(index));
        }
        return JavaInterop.toGuestValue(val, object.languageContext);
    }

    static boolean isList(JavaObject receiver) {
        return receiver.obj instanceof List;
    }

    static ArrayReadNode create() {
        return ArrayReadNodeGen.create();
    }
}

