/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.java.ArrayRemoveNode;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ArrayRemoveNode.class)
final class ArrayRemoveNodeGen
extends ArrayRemoveNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private ArrayRemoveNodeGen() {
    }

    @Override
    protected boolean executeWithTarget(JavaObject arg0Value, Object arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                if (ArrayRemoveNode.isList(arg0Value)) {
                    return this.doListIntIndex(arg0Value, arg1Value_);
                }
            }
            if ((state & 6) != 0 && arg1Value instanceof Number) {
                Number arg1Value_ = (Number)arg1Value;
                if ((state & 2) != 0 && ArrayRemoveNode.isList(arg0Value)) {
                    return this.doListGeneric(arg0Value, arg1Value_);
                }
                if ((state & 4) != 0 && !ArrayRemoveNode.isList(arg0Value)) {
                    return ArrayRemoveNode.notArray(arg0Value, arg1Value_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private boolean executeAndSpecialize(JavaObject arg0Value, Object arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0 && arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                if (ArrayRemoveNode.isList(arg0Value)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doListIntIndex(arg0Value, arg1Value_);
                    return bl;
                }
            }
            if (arg1Value instanceof Number) {
                Number arg1Value_ = (Number)arg1Value;
                if (ArrayRemoveNode.isList(arg0Value)) {
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doListGeneric(arg0Value, arg1Value_);
                    return bl;
                }
                if (!ArrayRemoveNode.isList(arg0Value)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = ArrayRemoveNode.notArray(arg0Value, arg1Value_);
                    return bl;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException(this, new Node[]{null, null}, arg0Value, arg1Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ArrayRemoveNode create() {
        return new ArrayRemoveNodeGen();
    }
}

