/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.java.ArrayWriteNode;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ArrayWriteNode.class)
final class ArrayWriteNodeGen
extends ArrayWriteNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private ArrayCachedData arrayCached_cache;

    private ArrayWriteNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected Object executeWithTarget(JavaObject arg0Value, Object arg1Value, Object arg2Value) {
        int state = this.state_;
        if (state != 0) {
            int arg1Value_;
            if ((state & 1) != 0 && arg1Value instanceof Integer) {
                arg1Value_ = (Integer)arg1Value;
                if (arg0Value.isArray()) {
                    return this.doArrayIntIndex(arg0Value, arg1Value_, arg2Value);
                }
            }
            if ((state & 6) != 0 && arg1Value instanceof Number) {
                Number arg1Value_2 = (Number)arg1Value;
                if ((state & 2) != 0 && arg0Value.isArray()) {
                    ArrayCachedData s2_ = this.arrayCached_cache;
                    while (s2_ != null) {
                        if (arg1Value_2.getClass() == s2_.clazz_) {
                            return this.doArrayCached(arg0Value, arg1Value_2, arg2Value, s2_.clazz_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0 && arg0Value.isArray()) {
                    return this.doArrayGeneric(arg0Value, arg1Value_2, arg2Value);
                }
            }
            if ((state & 8) != 0 && arg1Value instanceof Integer) {
                arg1Value_ = (Integer)arg1Value;
                if (ArrayWriteNode.isList(arg0Value)) {
                    return this.doListIntIndex(arg0Value, arg1Value_, arg2Value);
                }
            }
            if ((state & 0x30) != 0 && arg1Value instanceof Number) {
                Number arg1Value_3 = (Number)arg1Value;
                if ((state & 0x10) != 0 && ArrayWriteNode.isList(arg0Value)) {
                    return this.doListGeneric(arg0Value, arg1Value_3, arg2Value);
                }
                if ((state & 0x20) != 0 && !arg0Value.isArray() && !ArrayWriteNode.isList(arg0Value)) {
                    return ArrayWriteNode.notArray(arg0Value, arg1Value_3, arg2Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(JavaObject arg0Value, Object arg1Value, Object arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int arg1Value_;
            if (arg1Value instanceof Integer) {
                arg1Value_ = (Integer)arg1Value;
                if (arg0Value.isArray()) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doArrayIntIndex(arg0Value, arg1Value_, arg2Value);
                    return object;
                }
            }
            if (arg1Value instanceof Number) {
                Number arg1Value_2 = (Number)arg1Value;
                if ((exclude & 1) == 0 && arg0Value.isArray()) {
                    int count2_ = 0;
                    ArrayCachedData s2_ = this.arrayCached_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && arg1Value_2.getClass() != s2_.clazz_) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null) {
                        Class<?> clazz__ = arg1Value_2.getClass();
                        if (arg1Value_2.getClass() == clazz__ && count2_ < 3) {
                            s2_ = new ArrayCachedData(this.arrayCached_cache);
                            s2_.clazz_ = clazz__;
                            this.arrayCached_cache = s2_;
                            this.state_ = state |= 2;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doArrayCached(arg0Value, arg1Value_2, arg2Value, s2_.clazz_);
                        return object;
                    }
                }
                if (arg0Value.isArray()) {
                    this.exclude_ = exclude |= 1;
                    this.arrayCached_cache = null;
                    state &= 0xFFFFFFFD;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doArrayGeneric(arg0Value, arg1Value_2, arg2Value);
                    return object;
                }
            }
            if ((exclude & 2) == 0 && arg1Value instanceof Integer) {
                arg1Value_ = (Integer)arg1Value;
                if (ArrayWriteNode.isList(arg0Value)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doListIntIndex(arg0Value, arg1Value_, arg2Value);
                    return object;
                }
            }
            if (arg1Value instanceof Number) {
                Number arg1Value_3 = (Number)arg1Value;
                if (ArrayWriteNode.isList(arg0Value)) {
                    this.exclude_ = exclude |= 2;
                    state &= 0xFFFFFFF7;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doListGeneric(arg0Value, arg1Value_3, arg2Value);
                    return object;
                }
                if (!arg0Value.isArray() && !ArrayWriteNode.isList(arg0Value)) {
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    Object object = ArrayWriteNode.notArray(arg0Value, arg1Value_3, arg2Value);
                    return object;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException(this, new Node[]{null, null, null}, arg0Value, arg1Value, arg2Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        ArrayCachedData s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.arrayCached_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ArrayWriteNode create() {
        return new ArrayWriteNodeGen();
    }

    @GeneratedBy(value=ArrayWriteNode.class)
    private static final class ArrayCachedData {
        @CompilerDirectives.CompilationFinal
        ArrayCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<? extends Number> clazz_;

        ArrayCachedData(ArrayCachedData next_) {
            this.next_ = next_;
        }
    }
}

