/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.ExecuteMethodNodeGen;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.OverloadedMethodDesc;
import com.oracle.truffle.api.interop.java.SingleMethodDesc;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

abstract class ExecuteMethodNode
extends Node {
    static final int LIMIT = 3;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    ExecuteMethodNode() {
    }

    static ExecuteMethodNode create() {
        return ExecuteMethodNodeGen.create();
    }

    public final Object execute(JavaMethodDesc method, Object obj, Object[] args, Object languageContext) {
        try {
            return this.executeImpl(method, obj, args, languageContext);
        }
        catch (ClassCastException | NullPointerException e) {
            throw UnsupportedTypeException.raise(args);
        }
        catch (InteropException e) {
            throw e.raise();
        }
        catch (Throwable e) {
            throw JavaInteropReflect.rethrow(JavaInterop.wrapHostException(languageContext, e));
        }
    }

    protected abstract Object executeImpl(JavaMethodDesc var1, Object var2, Object[] var3, Object var4) throws InteropException;

    static ToJavaNode[] createToJava(int argsLength) {
        ToJavaNode[] toJava = new ToJavaNode[argsLength];
        for (int i = 0; i < argsLength; ++i) {
            toJava[i] = ToJavaNode.create();
        }
        return toJava;
    }

    @ExplodeLoop
    @Specialization(guards={"!method.isVarArgs()", "method == cachedMethod"}, limit="LIMIT")
    Object doFixed(SingleMethodDesc method, Object obj, Object[] args, Object languageContext, @Cached(value="method") SingleMethodDesc cachedMethod, @Cached(value="createToJava(method.getParameterCount())") ToJavaNode[] toJavaNodes, @Cached(value="createClassProfile()") ValueProfile receiverProfile) {
        int arity = cachedMethod.getParameterCount();
        if (args.length != arity) {
            throw ArityException.raise(arity, args.length);
        }
        Class<?>[] types = cachedMethod.getParameterTypes();
        Type[] genericTypes = cachedMethod.getGenericParameterTypes();
        Object[] convertedArguments = new Object[args.length];
        for (int i = 0; i < toJavaNodes.length; ++i) {
            convertedArguments[i] = toJavaNodes[i].execute(args[i], types[i], genericTypes[i], languageContext);
        }
        return ExecuteMethodNode.doInvoke(cachedMethod, receiverProfile.profile(obj), convertedArguments, languageContext);
    }

    @Specialization(guards={"method.isVarArgs()", "method == cachedMethod"}, limit="LIMIT")
    Object doVarArgs(SingleMethodDesc method, Object obj, Object[] args, Object languageContext, @Cached(value="method") SingleMethodDesc cachedMethod, @Cached(value="create()") ToJavaNode toJavaNode, @Cached(value="createClassProfile()") ValueProfile receiverProfile) {
        int i;
        int parameterCount = cachedMethod.getParameterCount();
        int minArity = parameterCount - 1;
        if (args.length < minArity) {
            throw ArityException.raise(minArity, args.length);
        }
        Class<?>[] types = cachedMethod.getParameterTypes();
        Type[] genericTypes = cachedMethod.getGenericParameterTypes();
        Object[] convertedArguments = new Object[args.length];
        for (i = 0; i < minArity; ++i) {
            convertedArguments[i] = toJavaNode.execute(args[i], types[i], genericTypes[i], languageContext);
        }
        if (ExecuteMethodNode.asVarArgs(args, cachedMethod)) {
            for (i = minArity; i < args.length; ++i) {
                Class<?> expectedType = types[minArity].getComponentType();
                Type expectedGenericType = ExecuteMethodNode.getGenericComponentType(genericTypes[minArity]);
                convertedArguments[i] = toJavaNode.execute(args[i], expectedType, expectedGenericType, languageContext);
            }
            convertedArguments = ExecuteMethodNode.createVarArgsArray(cachedMethod, convertedArguments, parameterCount);
        } else {
            convertedArguments[minArity] = toJavaNode.execute(args[minArity], types[minArity], genericTypes[minArity], languageContext);
        }
        return ExecuteMethodNode.doInvoke(cachedMethod, receiverProfile.profile(obj), convertedArguments, languageContext);
    }

    @Specialization(replaces={"doFixed", "doVarArgs"})
    Object doSingleUncached(SingleMethodDesc method, Object obj, Object[] args, Object languageContext, @Cached(value="create()") ToJavaNode toJavaNode, @Cached(value="createBinaryProfile()") ConditionProfile isVarArgsProfile) {
        int minArity;
        int parameterCount = method.getParameterCount();
        int n = minArity = method.isVarArgs() ? parameterCount - 1 : parameterCount;
        if (args.length < minArity) {
            throw ArityException.raise(minArity, args.length);
        }
        Object[] convertedArguments = ExecuteMethodNode.prepareArgumentsUncached(method, args, languageContext, toJavaNode, isVarArgsProfile);
        return ExecuteMethodNode.doInvoke(method, obj, convertedArguments, languageContext);
    }

    @ExplodeLoop
    @Specialization(guards={"method == cachedMethod", "checkArgTypes(args, cachedArgTypes, toJavaNode, asVarArgs)"}, limit="LIMIT")
    Object doOverloadedCached(OverloadedMethodDesc method, Object obj, Object[] args, Object languageContext, @Cached(value="method") OverloadedMethodDesc cachedMethod, @Cached(value="create()") ToJavaNode toJavaNode, @Cached(value="createArgTypesArray(args)", dimensions=1) Type[] cachedArgTypes, @Cached(value="selectOverload(method, args, languageContext, toJavaNode, cachedArgTypes)") SingleMethodDesc overload, @Cached(value="asVarArgs(args, overload)") boolean asVarArgs, @Cached(value="createClassProfile()") ValueProfile receiverProfile) {
        assert (overload == ExecuteMethodNode.selectOverload(method, args, languageContext, toJavaNode));
        Class<?>[] types = overload.getParameterTypes();
        Type[] genericTypes = overload.getGenericParameterTypes();
        Object[] convertedArguments = new Object[cachedArgTypes.length];
        if (asVarArgs) {
            assert (overload.isVarArgs());
            int parameterCount = overload.getParameterCount();
            for (int i = 0; i < cachedArgTypes.length; ++i) {
                Class<?> expectedType = i < parameterCount - 1 ? types[i] : types[parameterCount - 1].getComponentType();
                Type expectedGenericType = i < parameterCount - 1 ? genericTypes[i] : ExecuteMethodNode.getGenericComponentType(genericTypes[parameterCount - 1]);
                convertedArguments[i] = toJavaNode.execute(args[i], expectedType, expectedGenericType, languageContext);
            }
            convertedArguments = ExecuteMethodNode.createVarArgsArray(overload, convertedArguments, parameterCount);
        } else {
            for (int i = 0; i < cachedArgTypes.length; ++i) {
                convertedArguments[i] = toJavaNode.execute(args[i], types[i], genericTypes[i], languageContext);
            }
        }
        return ExecuteMethodNode.doInvoke(overload, receiverProfile.profile(obj), convertedArguments, languageContext);
    }

    @Specialization(replaces={"doOverloadedCached"})
    Object doOverloadedUncached(OverloadedMethodDesc method, Object obj, Object[] args, Object languageContext, @Cached(value="create()") ToJavaNode toJavaNode, @Cached(value="createBinaryProfile()") ConditionProfile isVarArgsProfile) {
        SingleMethodDesc overload = ExecuteMethodNode.selectOverload(method, args, languageContext, toJavaNode);
        Object[] convertedArguments = ExecuteMethodNode.prepareArgumentsUncached(overload, args, languageContext, toJavaNode, isVarArgsProfile);
        return ExecuteMethodNode.doInvoke(overload, obj, convertedArguments, languageContext);
    }

    private static Object[] prepareArgumentsUncached(SingleMethodDesc method, Object[] args, Object languageContext, ToJavaNode toJavaNode, ConditionProfile isVarArgsProfile) {
        Class<?>[] types = method.getParameterTypes();
        Type[] genericTypes = method.getGenericParameterTypes();
        Object[] convertedArguments = new Object[args.length];
        if (isVarArgsProfile.profile(method.isVarArgs()) && ExecuteMethodNode.asVarArgs(args, method)) {
            int parameterCount = method.getParameterCount();
            for (int i = 0; i < args.length; ++i) {
                Class<?> expectedType = i < parameterCount - 1 ? types[i] : types[parameterCount - 1].getComponentType();
                Type expectedGenericType = i < parameterCount - 1 ? genericTypes[i] : ExecuteMethodNode.getGenericComponentType(genericTypes[parameterCount - 1]);
                convertedArguments[i] = toJavaNode.execute(args[i], expectedType, expectedGenericType, languageContext);
            }
            convertedArguments = ExecuteMethodNode.createVarArgsArray(method, convertedArguments, parameterCount);
        } else {
            for (int i = 0; i < args.length; ++i) {
                convertedArguments[i] = toJavaNode.execute(args[i], types[i], genericTypes[i], languageContext);
            }
        }
        return convertedArguments;
    }

    static Type[] createArgTypesArray(Object[] args) {
        return new Type[args.length];
    }

    private static void fillArgTypesArray(Object[] args, Type[] cachedArgTypes, SingleMethodDesc selected, boolean varArgs, List<SingleMethodDesc> applicable, int priority) {
        if (cachedArgTypes == null) {
            return;
        }
        boolean multiple = applicable.size() > 1;
        for (int i = 0; i < args.length; ++i) {
            Type argType;
            Object arg = args[i];
            Class<?> targetType = ExecuteMethodNode.getParameterType(selected.getParameterTypes(), i, varArgs);
            if (arg == null) {
                argType = null;
            } else if (multiple && ToJavaNode.isAssignableFromTrufflePrimitiveType(targetType)) {
                Class<?> currentTargetType = targetType;
                ArrayList otherPossibleTypes = new ArrayList();
                for (SingleMethodDesc other : applicable) {
                    Class<?> paramType;
                    if (other == selected || other.isVarArgs() != varArgs || (paramType = ExecuteMethodNode.getParameterType(other.getParameterTypes(), i, varArgs)) == targetType || !ToJavaNode.isAssignableFromTrufflePrimitiveType(paramType) && !ToJavaNode.isAssignableFromTrufflePrimitiveType(targetType) || !ExecuteMethodNode.isAssignableFrom(targetType, paramType)) continue;
                    otherPossibleTypes.add(paramType);
                }
                argType = new PrimitiveType(currentTargetType, otherPossibleTypes.toArray(EMPTY_CLASS_ARRAY), priority);
            } else {
                argType = arg instanceof JavaObject ? new JavaObjectType(((JavaObject)arg).getObjectClass()) : arg.getClass();
            }
            cachedArgTypes[i] = argType;
        }
        assert (ExecuteMethodNode.checkArgTypes(args, cachedArgTypes, ToJavaNode.create(), false)) : Arrays.toString(cachedArgTypes);
    }

    @ExplodeLoop
    static boolean checkArgTypes(Object[] args, Type[] argTypes, ToJavaNode toJavaNode, boolean dummy) {
        if (args.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            Object arg = args[i];
            if (argType == null) {
                if (arg == null) continue;
                return false;
            }
            if (arg == null) {
                return false;
            }
            if (argType instanceof Class) {
                if (arg.getClass() == argType) continue;
                return false;
            }
            if (argType instanceof JavaObjectType) {
                if (arg instanceof JavaObject && ((JavaObject)arg).getObjectClass() == ((JavaObjectType)argType).clazz) continue;
                return false;
            }
            if (argType instanceof PrimitiveType) {
                if (((PrimitiveType)argType).test(arg, toJavaNode)) continue;
                return false;
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException(String.valueOf(argType));
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean asVarArgs(Object[] args, SingleMethodDesc overload) {
        if (overload.isVarArgs()) {
            int parameterCount = overload.getParameterCount();
            if (args.length == parameterCount) {
                return !ExecuteMethodNode.isSubtypeOf(args[parameterCount - 1], overload.getParameterTypes()[parameterCount - 1]);
            }
            assert (args.length != parameterCount);
            return true;
        }
        return false;
    }

    static Class<?> primitiveTypeToBoxedType(Class<?> primitiveType) {
        assert (primitiveType.isPrimitive());
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException();
    }

    static Class<?> boxedTypeToPrimitiveType(Class<?> primitiveType) {
        if (primitiveType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (primitiveType == Byte.class) {
            return Byte.TYPE;
        }
        if (primitiveType == Short.class) {
            return Short.TYPE;
        }
        if (primitiveType == Character.class) {
            return Character.TYPE;
        }
        if (primitiveType == Integer.class) {
            return Integer.TYPE;
        }
        if (primitiveType == Long.class) {
            return Long.TYPE;
        }
        if (primitiveType == Float.class) {
            return Float.TYPE;
        }
        if (primitiveType == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    static SingleMethodDesc selectOverload(OverloadedMethodDesc method, Object[] args, Object languageContext, ToJavaNode toJavaNode) {
        return ExecuteMethodNode.selectOverload(method, args, languageContext, toJavaNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    static SingleMethodDesc selectOverload(OverloadedMethodDesc method, Object[] args, Object languageContext, ToJavaNode toJavaNode, Type[] cachedArgTypes) {
        SingleMethodDesc best;
        SingleMethodDesc[] overloads = method.getOverloads();
        ArrayList<SingleMethodDesc> applicableByArity = new ArrayList<SingleMethodDesc>();
        int minOverallArity = Integer.MAX_VALUE;
        int maxOverallArity = 0;
        boolean anyVarArgs = false;
        for (SingleMethodDesc overload : overloads) {
            int paramCount = overload.getParameterCount();
            if (!overload.isVarArgs()) {
                if (args.length != paramCount) {
                    minOverallArity = Math.min(minOverallArity, paramCount);
                    maxOverallArity = Math.max(maxOverallArity, paramCount);
                    continue;
                }
            } else {
                anyVarArgs = true;
                int fixedParamCount = paramCount - 1;
                if (args.length < fixedParamCount) {
                    minOverallArity = Math.min(minOverallArity, fixedParamCount);
                    maxOverallArity = Math.max(maxOverallArity, fixedParamCount);
                    continue;
                }
            }
            applicableByArity.add(overload);
        }
        if (applicableByArity.isEmpty()) {
            throw ArityException.raise(args.length > maxOverallArity ? maxOverallArity : minOverallArity, args.length);
        }
        for (int priority : ToJavaNode.PRIORITIES) {
            best = ExecuteMethodNode.findBestCandidate(applicableByArity, args, languageContext, toJavaNode, false, priority, cachedArgTypes);
            if (best == null) continue;
            return best;
        }
        if (anyVarArgs) {
            for (int priority : ToJavaNode.PRIORITIES) {
                best = ExecuteMethodNode.findBestCandidate(applicableByArity, args, languageContext, toJavaNode, true, priority, cachedArgTypes);
                if (best == null) continue;
                return best;
            }
        }
        throw ExecuteMethodNode.noApplicableOverloadsException(overloads, args);
    }

    private static SingleMethodDesc findBestCandidate(List<SingleMethodDesc> applicableByArity, Object[] args, Object languageContext, ToJavaNode toJavaNode, boolean varArgs, int priority, Type[] cachedArgTypes) {
        ArrayList<SingleMethodDesc> candidates = new ArrayList<SingleMethodDesc>();
        if (!varArgs) {
            for (SingleMethodDesc candidate : applicableByArity) {
                int paramCount = candidate.getParameterCount();
                if (candidate.isVarArgs() && paramCount != args.length) continue;
                assert (paramCount == args.length);
                Class<?>[] parameterTypes = candidate.getParameterTypes();
                Type[] genericParameterTypes = candidate.getGenericParameterTypes();
                boolean applicable = true;
                for (int i = 0; i < paramCount; ++i) {
                    if (ExecuteMethodNode.isSubtypeOf(args[i], parameterTypes[i]) || toJavaNode.canConvert(args[i], parameterTypes[i], genericParameterTypes[i], languageContext, priority)) continue;
                    applicable = false;
                    break;
                }
                if (!applicable) continue;
                candidates.add(candidate);
            }
        } else {
            for (SingleMethodDesc candidate : applicableByArity) {
                if (!candidate.isVarArgs()) continue;
                int parameterCount = candidate.getParameterCount();
                Class<?>[] parameterTypes = candidate.getParameterTypes();
                Type[] genericParameterTypes = candidate.getGenericParameterTypes();
                boolean applicable = true;
                for (int i = 0; i < parameterCount - 1; ++i) {
                    if (ExecuteMethodNode.isSubtypeOf(args[i], parameterTypes[i]) || toJavaNode.canConvert(args[i], parameterTypes[i], genericParameterTypes[i], languageContext, priority)) continue;
                    applicable = false;
                    break;
                }
                if (!applicable) continue;
                Class<?> varArgsComponentType = parameterTypes[parameterCount - 1].getComponentType();
                Type varArgsGenericComponentType = genericParameterTypes[parameterCount - 1];
                if (varArgsGenericComponentType instanceof GenericArrayType) {
                    GenericArrayType arrayType = (GenericArrayType)varArgsGenericComponentType;
                    varArgsGenericComponentType = arrayType.getGenericComponentType();
                } else {
                    varArgsGenericComponentType = varArgsComponentType;
                }
                for (int i = parameterCount - 1; i < args.length; ++i) {
                    if (ExecuteMethodNode.isSubtypeOf(args[i], varArgsComponentType) || toJavaNode.canConvert(args[i], varArgsComponentType, varArgsGenericComponentType, languageContext, priority)) continue;
                    applicable = false;
                    break;
                }
                if (!applicable) continue;
                candidates.add(candidate);
            }
        }
        if (!candidates.isEmpty()) {
            SingleMethodDesc best;
            if (candidates.size() == 1) {
                best = (SingleMethodDesc)candidates.get(0);
                if (cachedArgTypes != null) {
                    ExecuteMethodNode.fillArgTypesArray(args, cachedArgTypes, best, varArgs, applicableByArity, priority);
                }
                return best;
            }
            best = ExecuteMethodNode.findMostSpecificOverload(candidates, args, varArgs);
            if (best != null) {
                if (cachedArgTypes != null) {
                    ExecuteMethodNode.fillArgTypesArray(args, cachedArgTypes, best, varArgs, applicableByArity, priority);
                }
                return best;
            }
            throw ExecuteMethodNode.ambiguousOverloadsException(candidates, args);
        }
        return null;
    }

    private static SingleMethodDesc findMostSpecificOverload(List<SingleMethodDesc> candidates, Object[] args, boolean varArgs) {
        assert (candidates.size() >= 2);
        if (candidates.size() == 2) {
            int res = ExecuteMethodNode.compareOverloads(candidates.get(0), candidates.get(1), args, varArgs);
            return res == 0 ? null : (res < 0 ? candidates.get(0) : candidates.get(1));
        }
        Iterator<SingleMethodDesc> candIt = candidates.iterator();
        LinkedList<SingleMethodDesc> best = new LinkedList<SingleMethodDesc>();
        best.add(candIt.next());
        while (candIt.hasNext()) {
            SingleMethodDesc cand = candIt.next();
            boolean add = false;
            Iterator bestIt = best.iterator();
            while (bestIt.hasNext()) {
                int res = ExecuteMethodNode.compareOverloads(cand, (SingleMethodDesc)bestIt.next(), args, varArgs);
                if (res == 0) {
                    add = true;
                    continue;
                }
                if (res < 0) {
                    bestIt.remove();
                    add = true;
                    continue;
                }
                assert (res > 0);
            }
            if (!add) continue;
            best.add(cand);
        }
        assert (!best.isEmpty());
        if (best.size() == 1) {
            return (SingleMethodDesc)best.get(0);
        }
        return null;
    }

    private static int compareOverloads(SingleMethodDesc m1, SingleMethodDesc m2, Object[] args, boolean varArgs) {
        int res = 0;
        int maxParamCount = Math.max(m1.getParameterCount(), m2.getParameterCount());
        assert (!varArgs || m1.isVarArgs() && m2.isVarArgs());
        assert (varArgs || m1.getParameterCount() == m2.getParameterCount() && args.length == m1.getParameterCount());
        assert (maxParamCount <= args.length);
        for (int i = 0; i < maxParamCount; ++i) {
            int r;
            Class<?> t2;
            Class<?> t1 = ExecuteMethodNode.getParameterType(m1.getParameterTypes(), i, varArgs);
            if (t1 == (t2 = ExecuteMethodNode.getParameterType(m2.getParameterTypes(), i, varArgs)) || (r = ExecuteMethodNode.compareAssignable(t1, t2)) == 0) continue;
            if (res == 0) {
                res = r;
                continue;
            }
            if (res == r) continue;
            res = 0;
            break;
        }
        return res;
    }

    private static Class<?> getParameterType(Class<?>[] parameterTypes, int i, boolean varArgs) {
        return varArgs && i >= parameterTypes.length - 1 ? parameterTypes[parameterTypes.length - 1].getComponentType() : parameterTypes[i];
    }

    private static int compareAssignable(Class<?> t1, Class<?> t2) {
        if (ExecuteMethodNode.isAssignableFrom(t1, t2)) {
            return 1;
        }
        if (ExecuteMethodNode.isAssignableFrom(t2, t1)) {
            return -1;
        }
        return 0;
    }

    private static boolean isAssignableFrom(Class<?> toType, Class<?> fromType) {
        Class<?> toAsPrimitive;
        if (toType.isAssignableFrom(fromType)) {
            return true;
        }
        boolean fromIsPrimitive = fromType.isPrimitive();
        boolean toIsPrimitive = toType.isPrimitive();
        Class<?> fromAsPrimitive = fromIsPrimitive ? fromType : ExecuteMethodNode.boxedTypeToPrimitiveType(fromType);
        Class<?> clazz = toAsPrimitive = toIsPrimitive ? toType : ExecuteMethodNode.boxedTypeToPrimitiveType(toType);
        if (toAsPrimitive != null && fromAsPrimitive != null) {
            if (toAsPrimitive == fromAsPrimitive) {
                assert (fromIsPrimitive != toIsPrimitive);
                return fromIsPrimitive;
            }
            if (ExecuteMethodNode.isWideningPrimitiveConversion(toAsPrimitive, fromAsPrimitive)) {
                return true;
            }
        } else {
            if (fromAsPrimitive == Character.TYPE && (toType == String.class || toType == CharSequence.class)) {
                return true;
            }
            if (toAsPrimitive == null && fromAsPrimitive != null && toType.isAssignableFrom(ExecuteMethodNode.primitiveTypeToBoxedType(fromAsPrimitive))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSubtypeOf(Object argument, Class<?> parameterType) {
        Class<?> boxedToPrimitive;
        Object value = argument;
        if (argument instanceof JavaObject) {
            value = ((JavaObject)argument).obj;
        }
        if (!parameterType.isPrimitive()) {
            return value == null || parameterType.isInstance(value) && !(value instanceof TruffleObject);
        }
        if (value != null && (boxedToPrimitive = ExecuteMethodNode.boxedTypeToPrimitiveType(value.getClass())) != null) {
            return boxedToPrimitive == parameterType || ExecuteMethodNode.isWideningPrimitiveConversion(parameterType, boxedToPrimitive);
        }
        return false;
    }

    private static boolean isWideningPrimitiveConversion(Class<?> toType, Class<?> fromType) {
        assert (toType.isPrimitive());
        if (fromType == Byte.TYPE) {
            return toType == Short.TYPE || toType == Integer.TYPE || toType == Long.TYPE || toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Short.TYPE) {
            return toType == Integer.TYPE || toType == Long.TYPE || toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Character.TYPE) {
            return toType == Integer.TYPE || toType == Long.TYPE || toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Integer.TYPE) {
            return toType == Long.TYPE || toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Long.TYPE) {
            return toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Float.TYPE) {
            return toType == Double.TYPE;
        }
        return false;
    }

    private static RuntimeException ambiguousOverloadsException(List<SingleMethodDesc> candidates, Object[] args) {
        String message = String.format("Multiple applicable overloads found for method name %s (candidates: %s, arguments: %s)", candidates.get(0).getName(), candidates, ExecuteMethodNode.arrayToStringWithTypes(args));
        return UnsupportedTypeException.raise(new IllegalArgumentException(message), args);
    }

    private static RuntimeException noApplicableOverloadsException(SingleMethodDesc[] overloads, Object[] args) {
        String message = String.format("no applicable overload found (overloads: %s, arguments: %s)", Arrays.toString(overloads), ExecuteMethodNode.arrayToStringWithTypes(args));
        return UnsupportedTypeException.raise(new IllegalArgumentException(message), args);
    }

    private static Type getGenericComponentType(Type type) {
        return type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : ((Class)type).getComponentType();
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] createVarArgsArray(SingleMethodDesc method, Object[] args, int parameterCount) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] arguments = new Object[parameterCount];
        for (int i = 0; i < parameterCount - 1; ++i) {
            arguments[i] = args[i];
        }
        Class<?> varArgsType = parameterTypes[parameterCount - 1].getComponentType();
        Object varArgs = Array.newInstance(varArgsType, args.length - parameterCount + 1);
        int i = parameterCount - 1;
        int j = 0;
        while (i < args.length) {
            Array.set(varArgs, j, args[i]);
            ++i;
            ++j;
        }
        arguments[parameterCount - 1] = varArgs;
        return arguments;
    }

    private static Object doInvoke(SingleMethodDesc method, Object obj, Object[] arguments, Object languageContext) {
        Object ret;
        assert (arguments.length == method.getParameterCount());
        try {
            ret = method.invoke(obj, arguments);
        }
        catch (Throwable e) {
            throw JavaInteropReflect.rethrow(JavaInterop.wrapHostException(languageContext, e));
        }
        return JavaInterop.toGuestValue(ret, languageContext);
    }

    private static String arrayToStringWithTypes(Object[] args) {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (Object arg : args) {
            sj.add(arg == null ? null : arg.toString() + " (" + arg.getClass().getSimpleName() + ")");
        }
        return sj.toString();
    }

    static class PrimitiveType
    implements Type {
        final Class<?> targetType;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Class<?>[] otherTypes;
        final int priority;

        PrimitiveType(Class<?> targetType, Class<?>[] otherTypes, int priority) {
            this.targetType = targetType;
            this.otherTypes = otherTypes;
            this.priority = priority;
        }

        public int hashCode() {
            return this.targetType == null ? 0 : this.targetType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PrimitiveType)) {
                return false;
            }
            PrimitiveType other = (PrimitiveType)obj;
            return Objects.equals(this.targetType, other.targetType) && Arrays.equals(this.otherTypes, other.otherTypes);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Primitive[");
            sb.append(this.targetType.getTypeName());
            if (this.otherTypes.length > 0) {
                for (Class<?> otherType : this.otherTypes) {
                    sb.append(", !");
                    sb.append(otherType.getTypeName());
                }
            }
            sb.append(']');
            return sb.toString();
        }

        @ExplodeLoop
        public boolean test(Object value, ToJavaNode toJavaNode) {
            for (Class<?> otherType : this.otherTypes) {
                if (!toJavaNode.canConvertToPrimitive(value, otherType, this.priority)) continue;
                return false;
            }
            return toJavaNode.canConvertToPrimitive(value, this.targetType, this.priority);
        }
    }

    static class JavaObjectType
    implements Type {
        final Class<?> clazz;

        JavaObjectType(Class<?> clazz) {
            this.clazz = clazz;
        }

        public int hashCode() {
            return this.clazz == null ? 0 : this.clazz.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JavaObjectType)) {
                return false;
            }
            JavaObjectType other = (JavaObjectType)obj;
            return Objects.equals(this.clazz, other.clazz);
        }

        public String toString() {
            return "JavaObject[" + this.clazz.getTypeName() + "]";
        }
    }
}

