/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaFunctionMessageResolutionForeign;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;

final class JavaFunctionObject
implements TruffleObject {
    final JavaMethodDesc method;
    final Object obj;
    final Object languageContext;

    JavaFunctionObject(JavaMethodDesc method, Object obj, Object languageContext) {
        this.method = method;
        this.obj = obj;
        this.languageContext = languageContext;
    }

    public static boolean isInstance(TruffleObject obj) {
        return obj instanceof JavaFunctionObject;
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return JavaFunctionMessageResolutionForeign.ACCESS;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaFunctionObject) {
            JavaFunctionObject other = (JavaFunctionObject)o;
            return this.method == other.method && this.obj == other.obj && this.languageContext == other.languageContext;
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    String getDescription() {
        if (this.obj == null) {
            return "null";
        }
        String typeName = this.obj.getClass().getTypeName();
        return typeName + "." + this.method.getName();
    }
}

