/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.TruffleFunction;
import com.oracle.truffle.api.interop.java.TruffleList;
import com.oracle.truffle.api.interop.java.TruffleMap;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Map;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;

@Deprecated
public final class JavaInterop {
    private JavaInterop() {
    }

    @Deprecated
    public static <T> T asJavaObject(Class<T> type, TruffleObject foreignObject) {
        if (foreignObject instanceof JavaObject) {
            JavaObject javaObject = (JavaObject)foreignObject;
            if (type.isInstance(javaObject.obj)) {
                return type.cast(javaObject.obj);
            }
        }
        return JavaInterop.convertToJavaObject(type, foreignObject);
    }

    @Deprecated
    public static Object asJavaObject(TruffleObject foreignObject) {
        JavaObject javaObject = (JavaObject)foreignObject;
        return javaObject.obj;
    }

    @CompilerDirectives.TruffleBoundary
    private static <T> T convertToJavaObject(Class<T> type, TruffleObject foreignObject) {
        TemporaryConvertRoot root = new TemporaryConvertRoot(ToJavaNode.create(), foreignObject, type);
        Object convertedValue = Truffle.getRuntime().createCallTarget(root).call(new Object[0]);
        return (T)convertedValue;
    }

    @Deprecated
    public static boolean isJavaObject(Class<?> type, TruffleObject foreignObject) {
        if (foreignObject instanceof JavaObject) {
            JavaObject javaObject = (JavaObject)foreignObject;
            return type.isInstance(javaObject.obj);
        }
        return false;
    }

    @Deprecated
    public static boolean isJavaObject(TruffleObject foreignObject) {
        return foreignObject instanceof JavaObject;
    }

    @Deprecated
    public static boolean isJavaObject(Object object) {
        return object instanceof JavaObject;
    }

    @Deprecated
    public static TruffleObject asTruffleObject(Object obj) {
        return JavaInterop.asTruffleObject(obj, JavaInterop.currentPolyglotContext(), true);
    }

    static TruffleObject asTruffleObject(Object obj, Object languageContext) {
        return JavaInterop.asTruffleObject(obj, languageContext, false);
    }

    static TruffleObject asTruffleObject(Object obj, Object languageContext, boolean asStaticClass) {
        if (obj instanceof TruffleObject) {
            return (TruffleObject)obj;
        }
        if (obj instanceof Class) {
            if (asStaticClass) {
                return JavaObject.forStaticClass((Class)obj, languageContext);
            }
            return JavaObject.forClass((Class)obj, languageContext);
        }
        if (obj == null) {
            return JavaObject.NULL;
        }
        if (obj.getClass().isArray()) {
            return JavaObject.forObject(obj, languageContext);
        }
        if (obj instanceof TruffleList) {
            return ((TruffleList)obj).guestObject;
        }
        if (obj instanceof TruffleMap) {
            return ((TruffleMap)obj).guestObject;
        }
        if (obj instanceof TruffleFunction) {
            return ((TruffleFunction)obj).guestObject;
        }
        if (TruffleOptions.AOT) {
            return JavaObject.forObject(obj, languageContext);
        }
        return JavaInteropReflect.asTruffleViaReflection(obj, languageContext);
    }

    @Deprecated
    public static Object asTruffleValue(Object obj) {
        return JavaInterop.isPrimitive(obj) ? obj : JavaInterop.asTruffleObject(obj);
    }

    @Deprecated
    public static boolean isPrimitive(Object obj) {
        if (obj instanceof TruffleObject) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof Boolean || obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Character || obj instanceof String;
    }

    @Deprecated
    public static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function) {
        TemporaryConvertRoot root = new TemporaryConvertRoot(ToJavaNode.create(), function, functionalType);
        return functionalType.cast(Truffle.getRuntime().createCallTarget(root).call(new Object[0]));
    }

    @Deprecated
    public static <T> TruffleObject asTruffleFunction(Class<T> functionalType, T implementation) {
        if (TruffleOptions.AOT) {
            throw new IllegalArgumentException();
        }
        return JavaInteropReflect.asTruffleFunction(functionalType, implementation, JavaInterop.currentPolyglotContext());
    }

    @Deprecated
    public static <K, V> Map<K, V> getMapView(Map<K, V> map, boolean includeInternal) throws IllegalArgumentException {
        if (!(map instanceof TruffleMap)) {
            throw new IllegalArgumentException(map.getClass().getCanonicalName());
        }
        TruffleMap tmap = (TruffleMap)map;
        return tmap.cloneInternal(includeInternal);
    }

    @Deprecated
    public static TruffleObject toJavaClass(TruffleObject obj) {
        if (obj instanceof JavaObject) {
            JavaObject receiver = (JavaObject)obj;
            if (receiver.obj == null) {
                return JavaObject.NULL;
            }
            return JavaObject.forClass(receiver.obj.getClass(), receiver.languageContext);
        }
        return null;
    }

    @Deprecated
    public static boolean isHostException(Throwable exception) {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine == null) {
            return false;
        }
        return engine.isHostException(exception);
    }

    @Deprecated
    public static Throwable asHostException(Throwable exception) {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine != null && engine.isHostException(exception)) {
            return engine.asHostException(exception);
        }
        throw new IllegalArgumentException("Not a HostException");
    }

    static boolean isJavaFunction(Object o) {
        if (TruffleOptions.AOT) {
            return false;
        }
        return o instanceof JavaFunctionObject;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isJavaFunctionInterface(Class<?> type) {
        if (!type.isInterface() || type == TruffleObject.class) {
            return false;
        }
        return type.getAnnotation(FunctionalInterface.class) != null;
    }

    static Value toHostValue(Object obj, Object languageContext) {
        return JavaInteropAccessor.ACCESSOR.engine().toHostValue(obj, languageContext);
    }

    static Object toGuestValue(Object obj, Object languageContext) {
        if (JavaInterop.isPrimitive(obj)) {
            return obj;
        }
        return JavaInterop.toGuestObject(obj, languageContext);
    }

    static Object toGuestObject(Object obj, Object languageContext) {
        assert (!JavaInterop.isPrimitive(obj));
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine == null || languageContext == null) {
            assert (!(obj instanceof Value) && !(obj instanceof Proxy));
            return JavaInterop.asTruffleObject(obj, languageContext);
        }
        return engine.toGuestValue(obj, languageContext);
    }

    static Object findOriginalObject(Object truffleObject) {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine == null) {
            return truffleObject;
        }
        return engine.findOriginalObject(truffleObject);
    }

    static Throwable wrapHostException(Object languageContext, Throwable exception) {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine == null) {
            return exception;
        }
        if (exception instanceof TruffleException) {
            return exception;
        }
        return engine.wrapHostException(languageContext, exception);
    }

    static Object currentPolyglotContext() {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine == null) {
            return null;
        }
        return engine.getCurrentHostContext();
    }

    private static class TemporaryConvertRoot
    extends RootNode {
        @Node.Child
        private ToJavaNode node;
        private final Object value;
        private final Class<?> type;

        TemporaryConvertRoot(ToJavaNode node, Object value, Class<?> type) {
            super(null);
            this.node = node;
            this.value = value;
            this.type = type;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(this.value, this.type, null, JavaInterop.currentPolyglotContext());
        }
    }
}

