/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Type;

final class JavaInteropAccessor
extends Accessor {
    static final JavaInteropAccessor ACCESSOR = new JavaInteropAccessor();

    JavaInteropAccessor() {
    }

    Accessor.EngineSupport engine() {
        return this.engineSupport();
    }

    static boolean isGuestPrimitive(Object obj) {
        return obj instanceof Boolean || obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Character || obj instanceof String;
    }

    @Override
    protected Accessor.JavaInteropSupport javaInteropSupport() {
        return new Accessor.JavaInteropSupport(){

            @Override
            public Node createToJavaNode() {
                return ToJavaNode.create();
            }

            @Override
            public Object toJava(Node javaNode, Class<?> rawType, Type genericType, Object value, Object polyglotContext) {
                ToJavaNode toJavaNode = (ToJavaNode)javaNode;
                return toJavaNode.execute(value, rawType, genericType, polyglotContext);
            }

            @Override
            public boolean isHostObject(Object object) {
                return object instanceof JavaObject;
            }

            @Override
            public Object asHostObject(Object obj) {
                assert (this.isHostObject(obj));
                JavaObject javaObject = (JavaObject)obj;
                return javaObject.obj;
            }

            @Override
            public Object toGuestObject(Object obj, Object languageContext) {
                return JavaInterop.asTruffleObject(obj, languageContext);
            }

            @Override
            public Object asBoxedGuestValue(Object hostObject, Object languageContext) {
                if (JavaInteropAccessor.isGuestPrimitive(hostObject)) {
                    return JavaObject.forObject(hostObject, languageContext);
                }
                if (hostObject instanceof TruffleObject) {
                    return hostObject;
                }
                CompilerDirectives.transferToInterpreter();
                throw new IllegalArgumentException("Provided value not an interop value.");
            }

            @Override
            public boolean isHostFunction(Object object) {
                if (TruffleOptions.AOT) {
                    return false;
                }
                return object instanceof JavaFunctionObject;
            }

            @Override
            public String javaGuestFunctionToString(Object object) {
                if (TruffleOptions.AOT) {
                    return "";
                }
                return ((JavaFunctionObject)object).getDescription();
            }

            @Override
            public Object asStaticClassObject(Class<?> clazz, Object hostLanguageContext) {
                return JavaObject.forStaticClass(clazz, hostLanguageContext);
            }
        };
    }

    Accessor.InteropSupport interop() {
        return this.interopSupport();
    }
}

