/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.FunctionProxyHandler;
import com.oracle.truffle.api.interop.java.JavaClassDesc;
import com.oracle.truffle.api.interop.java.JavaFieldDesc;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ObjectProxyHandler;
import com.oracle.truffle.api.interop.java.OverloadedMethodDesc;
import com.oracle.truffle.api.interop.java.SingleMethodDesc;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import org.graalvm.collections.EconomicSet;

final class JavaInteropReflect {
    static final Object[] EMPTY = new Object[0];

    private JavaInteropReflect() {
    }

    @CompilerDirectives.TruffleBoundary
    static Class<?> findInnerClass(Class<?> clazz, String name) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            for (Class<?> t : clazz.getClasses()) {
                if (!JavaInteropReflect.isStaticTypeOrInterface(t) || !t.getSimpleName().equals(name)) continue;
                return t;
            }
        }
        return null;
    }

    static boolean isJNIName(String name) {
        return name.contains("__");
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isApplicableByArity(JavaMethodDesc method, int nArgs) {
        SingleMethodDesc[] overloads;
        if (method instanceof SingleMethodDesc) {
            return nArgs == ((SingleMethodDesc)method).getParameterCount() || ((SingleMethodDesc)method).isVarArgs() && nArgs >= ((SingleMethodDesc)method).getParameterCount() - 1;
        }
        for (SingleMethodDesc overload : overloads = ((OverloadedMethodDesc)method).getOverloads()) {
            if (!JavaInteropReflect.isApplicableByArity(overload, nArgs)) continue;
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    static JavaMethodDesc findMethod(Class<?> clazz, String name, boolean onlyStatic) {
        if (TruffleOptions.AOT) {
            return null;
        }
        JavaClassDesc classDesc = JavaClassDesc.forClass(clazz);
        JavaMethodDesc foundMethod = classDesc.lookupMethod(name, onlyStatic);
        if (foundMethod == null && JavaInteropReflect.isJNIName(name)) {
            foundMethod = classDesc.lookupMethodByJNIName(name, onlyStatic);
        }
        return foundMethod;
    }

    @CompilerDirectives.TruffleBoundary
    static JavaFieldDesc findField(Class<?> clazz, String name, boolean onlyStatic) {
        JavaClassDesc classDesc = JavaClassDesc.forClass(clazz);
        return classDesc.lookupField(name, onlyStatic);
    }

    @CompilerDirectives.TruffleBoundary
    static int findKeyInfo(Class<?> clazz, String name, boolean onlyStatic) {
        JavaFieldDesc foundField;
        if (TruffleOptions.AOT) {
            return 0;
        }
        boolean readable = false;
        boolean writable = false;
        boolean invocable = false;
        boolean internal = false;
        JavaClassDesc classDesc = JavaClassDesc.forClass(clazz);
        JavaMethodDesc foundMethod = classDesc.lookupMethod(name, onlyStatic);
        if (foundMethod != null) {
            readable = true;
            invocable = true;
        } else if (JavaInteropReflect.isJNIName(name) && (foundMethod = classDesc.lookupMethodByJNIName(name, onlyStatic)) != null) {
            readable = true;
            invocable = true;
            internal = true;
        }
        if (!readable && (foundField = classDesc.lookupField(name, onlyStatic)) != null) {
            readable = true;
            writable = true;
        }
        if (onlyStatic) {
            Class<?> innerClass;
            if (!readable && "class".equals(name)) {
                readable = true;
            }
            if (!readable && (innerClass = JavaInteropReflect.findInnerClass(clazz, name)) != null) {
                readable = true;
            }
        }
        if (readable) {
            return 2 | (writable ? 4 : 0) | (invocable ? 8 : 0) | (internal ? 16 : 0);
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function, Object languageContext) {
        assert (JavaInterop.isJavaFunctionInterface(functionalType));
        Method functionalInterfaceMethod = JavaInteropReflect.functionalInterfaceMethod(functionalType);
        FunctionProxyHandler handler = new FunctionProxyHandler(function, functionalInterfaceMethod, languageContext);
        Object obj = Proxy.newProxyInstance(functionalType.getClassLoader(), new Class[]{functionalType}, (InvocationHandler)handler);
        return functionalType.cast(obj);
    }

    static <T> TruffleObject asTruffleFunction(Class<T> functionalInterface, T implementation, Object languageContext) {
        Method method = JavaInteropReflect.functionalInterfaceMethod(functionalInterface);
        if (method == null) {
            throw new IllegalArgumentException();
        }
        return new JavaFunctionObject(SingleMethodDesc.unreflect(method), implementation, languageContext);
    }

    static Method functionalInterfaceMethod(Class<?> functionalInterface) {
        if (!functionalInterface.isInterface()) {
            return null;
        }
        Method[] methods = functionalInterface.getMethods();
        if (methods.length == 1) {
            return methods[0];
        }
        Method found = null;
        for (Method m : methods) {
            if (!Modifier.isAbstract(m.getModifiers()) || JavaClassDesc.isObjectMethodOverride(m)) continue;
            if (found != null) {
                return null;
            }
            found = m;
        }
        return found;
    }

    static TruffleObject asTruffleViaReflection(Object obj, Object languageContext) {
        if (obj instanceof Proxy) {
            return JavaInteropReflect.asTruffleObjectProxy(obj, languageContext);
        }
        return JavaObject.forObject(obj, languageContext);
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleObject asTruffleObjectProxy(Object obj, Object languageContext) {
        if (Proxy.isProxyClass(obj.getClass())) {
            InvocationHandler h = Proxy.getInvocationHandler(obj);
            if (h instanceof FunctionProxyHandler) {
                return ((FunctionProxyHandler)h).functionObj;
            }
            if (h instanceof ObjectProxyHandler) {
                return ((ObjectProxyHandler)h).obj;
            }
        }
        return JavaObject.forObject(obj, languageContext);
    }

    static Object newProxyInstance(Class<?> clazz, TruffleObject obj, Object languageContext) throws IllegalArgumentException {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ObjectProxyHandler(obj, languageContext, clazz));
    }

    static boolean isStaticTypeOrInterface(Class<?> t) {
        return Modifier.isPublic(t.getModifiers()) && (t.isInterface() || t.isEnum() || Modifier.isStatic(t.getModifiers()));
    }

    @CompilerDirectives.TruffleBoundary
    static String[] findUniquePublicMemberNames(Class<?> clazz, boolean onlyStatic, boolean includeInternal) throws SecurityException {
        JavaClassDesc classDesc = JavaClassDesc.forClass(clazz);
        EconomicSet names = EconomicSet.create();
        names.addAll(classDesc.getFieldNames(onlyStatic));
        names.addAll(classDesc.getMethodNames(onlyStatic, includeInternal));
        if (onlyStatic) {
            names.add((Object)"class");
            if (Modifier.isPublic(clazz.getModifiers())) {
                for (Class<?> t : clazz.getClasses()) {
                    if (!JavaInteropReflect.isStaticTypeOrInterface(t)) continue;
                    names.add((Object)t.getSimpleName());
                }
            }
        }
        return (String[])names.toArray((Object[])new String[names.size()]);
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public static Class<?> getMethodReturnType(Method method) {
        if (method == null || method.getReturnType() == Void.TYPE) {
            return Object.class;
        }
        return method.getReturnType();
    }

    public static Type getMethodGenericReturnType(Method method) {
        if (method == null || method.getReturnType() == Void.TYPE) {
            return Object.class;
        }
        return method.getGenericReturnType();
    }

    static String jniName(Method m) {
        StringBuilder sb = new StringBuilder();
        JavaInteropReflect.noUnderscore(sb, m.getName()).append("__");
        JavaInteropReflect.appendType(sb, m.getReturnType());
        Class<?>[] arr = m.getParameterTypes();
        for (int i = 0; i < arr.length; ++i) {
            JavaInteropReflect.appendType(sb, arr[i]);
        }
        return sb.toString();
    }

    private static StringBuilder noUnderscore(StringBuilder sb, String name) {
        return sb.append(name.replace("_", "_1").replace('.', '_'));
    }

    private static void appendType(StringBuilder sb, Class<?> type) {
        if (type == Integer.TYPE) {
            sb.append('I');
            return;
        }
        if (type == Long.TYPE) {
            sb.append('J');
            return;
        }
        if (type == Double.TYPE) {
            sb.append('D');
            return;
        }
        if (type == Float.TYPE) {
            sb.append('F');
            return;
        }
        if (type == Byte.TYPE) {
            sb.append('B');
            return;
        }
        if (type == Boolean.TYPE) {
            sb.append('Z');
            return;
        }
        if (type == Short.TYPE) {
            sb.append('S');
            return;
        }
        if (type == Void.TYPE) {
            sb.append('V');
            return;
        }
        if (type == Character.TYPE) {
            sb.append('C');
            return;
        }
        if (type.isArray()) {
            sb.append("_3");
            JavaInteropReflect.appendType(sb, type.getComponentType());
            return;
        }
        JavaInteropReflect.noUnderscore(sb.append('L'), type.getName());
        sb.append("_2");
    }
}

