/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.ArrayReadNode;
import com.oracle.truffle.api.interop.java.ArrayRemoveNode;
import com.oracle.truffle.api.interop.java.ArrayWriteNode;
import com.oracle.truffle.api.interop.java.ExecuteMethodNode;
import com.oracle.truffle.api.interop.java.JavaFieldDesc;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.KeyInfoCacheNode;
import com.oracle.truffle.api.interop.java.LookupConstructorNode;
import com.oracle.truffle.api.interop.java.LookupFieldNode;
import com.oracle.truffle.api.interop.java.LookupFunctionalMethodNode;
import com.oracle.truffle.api.interop.java.LookupInnerClassNode;
import com.oracle.truffle.api.interop.java.LookupMethodNode;
import com.oracle.truffle.api.interop.java.MapRemoveNode;
import com.oracle.truffle.api.interop.java.ReadFieldNode;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.ToPrimitiveNode;
import com.oracle.truffle.api.interop.java.WriteFieldNode;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.util.List;

class JavaObjectMessageResolution {
    JavaObjectMessageResolution() {
    }

    static abstract class ExecuteObjectNode
    extends Node {
        private static final Message EXECUTE = Message.createExecute(0);
        @Node.Child
        private LookupFunctionalMethodNode lookupMethod;
        @Node.Child
        private ExecuteMethodNode doExecute;

        ExecuteObjectNode() {
        }

        public Object access(JavaObject receiver, Object[] args) {
            JavaMethodDesc method;
            if (TruffleOptions.AOT) {
                throw UnsupportedMessageException.raise(EXECUTE);
            }
            if (receiver.obj != null && !receiver.isClass() && (method = this.lookupFunctionalInterfaceMethod(receiver)) != null) {
                if (this.doExecute == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.doExecute = this.insert(ExecuteMethodNode.create());
                }
                return this.doExecute.execute(method, receiver.obj, args, receiver.languageContext);
            }
            throw UnsupportedMessageException.raise(EXECUTE);
        }

        private JavaMethodDesc lookupFunctionalInterfaceMethod(JavaObject receiver) {
            if (this.lookupMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupMethod = this.insert(LookupFunctionalMethodNode.create());
            }
            return this.lookupMethod.execute(receiver.getLookupClass());
        }
    }

    static abstract class IsExecutableObjectNode
    extends Node {
        @Node.Child
        private LookupFunctionalMethodNode lookupMethod;

        IsExecutableObjectNode() {
        }

        public Object access(JavaObject receiver) {
            if (TruffleOptions.AOT) {
                return false;
            }
            return receiver.obj != null && !receiver.isClass() && this.lookupFunctionalInterfaceMethod(receiver) != null;
        }

        private JavaMethodDesc lookupFunctionalInterfaceMethod(JavaObject receiver) {
            if (this.lookupMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupMethod = this.insert(LookupFunctionalMethodNode.create());
            }
            return this.lookupMethod.execute(receiver.getLookupClass());
        }
    }

    static abstract class KeyInfoNode
    extends Node {
        @Node.Child
        private KeyInfoCacheNode keyInfoCache;

        KeyInfoNode() {
        }

        public int access(JavaObject receiver, int index) {
            if (index < 0) {
                return 0;
            }
            if (receiver.isArray()) {
                int length = Array.getLength(receiver.obj);
                if (index < length) {
                    return 6;
                }
            } else if (receiver.obj instanceof List) {
                int length = KeyInfoNode.listSize((List)receiver.obj);
                if (index < length) {
                    return 38;
                }
                if (index == length) {
                    return 64;
                }
            }
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        public int access(JavaObject receiver, Number index) {
            int i = index.intValue();
            if ((double)i != index.doubleValue()) {
                return 0;
            }
            return this.access(receiver, i);
        }

        @CompilerDirectives.TruffleBoundary
        private static int listSize(List<?> list) {
            return list.size();
        }

        public int access(JavaObject receiver, String name) {
            if (receiver.isNull()) {
                throw UnsupportedMessageException.raise(Message.KEY_INFO);
            }
            if (TruffleOptions.AOT) {
                return 0;
            }
            return this.keyInfoCache().execute(receiver.getLookupClass(), name, receiver.isStaticClass());
        }

        private KeyInfoCacheNode keyInfoCache() {
            if (this.keyInfoCache == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.keyInfoCache = this.insert(KeyInfoCacheNode.create());
            }
            return this.keyInfoCache;
        }
    }

    static abstract class KeysNode
    extends Node {
        KeysNode() {
        }

        @CompilerDirectives.TruffleBoundary
        public Object access(JavaObject receiver, boolean includeInternal) {
            if (receiver.isNull()) {
                throw UnsupportedMessageException.raise(Message.KEYS);
            }
            String[] fields = TruffleOptions.AOT ? new String[]{} : JavaInteropReflect.findUniquePublicMemberNames(receiver.getLookupClass(), receiver.isStaticClass(), includeInternal);
            return JavaObject.forObject(fields, receiver.languageContext);
        }
    }

    static abstract class HasKeysNode
    extends Node {
        HasKeysNode() {
        }

        public Object access(JavaObject receiver) {
            return !receiver.isNull();
        }
    }

    static abstract class RemoveNode
    extends Node {
        @Node.Child
        private ArrayRemoveNode arrayRemove;
        @Node.Child
        private MapRemoveNode mapRemove;

        RemoveNode() {
        }

        public Object access(JavaObject receiver, Number index) {
            if (this.arrayRemove == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayRemove = this.insert(ArrayRemoveNode.create());
            }
            return this.arrayRemove.executeWithTarget(receiver, index);
        }

        public Object access(JavaObject receiver, String name) {
            if (this.mapRemove == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.mapRemove = this.insert(MapRemoveNode.create());
            }
            return this.mapRemove.executeWithTarget(receiver, name);
        }
    }

    static abstract class WriteNode
    extends Node {
        @Node.Child
        private ArrayWriteNode arrayWrite;
        @Node.Child
        private LookupFieldNode lookupField;
        @Node.Child
        private WriteFieldNode writeField;

        WriteNode() {
        }

        public Object access(JavaObject receiver, Number index, Object value) {
            if (this.arrayWrite == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayWrite = this.insert(ArrayWriteNode.create());
            }
            try {
                return this.arrayWrite.executeWithTarget(receiver, index, value);
            }
            catch (ClassCastException | NullPointerException e) {
                throw UnsupportedTypeException.raise(e, new Object[]{value});
            }
        }

        public Object access(JavaObject receiver, String name, Object value) {
            if (TruffleOptions.AOT || receiver.isNull()) {
                throw UnsupportedMessageException.raise(Message.WRITE);
            }
            JavaFieldDesc f = this.lookupField().execute(receiver.getLookupClass(), name, receiver.isStaticClass());
            if (f == null) {
                throw UnknownIdentifierException.raise(name);
            }
            try {
                this.writeField().execute(f, receiver, value);
            }
            catch (ClassCastException | NullPointerException e) {
                throw UnsupportedTypeException.raise(e, new Object[]{value});
            }
            return JavaObject.NULL;
        }

        private LookupFieldNode lookupField() {
            if (this.lookupField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupField = this.insert(LookupFieldNode.create());
            }
            return this.lookupField;
        }

        private WriteFieldNode writeField() {
            if (this.writeField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeField = this.insert(WriteFieldNode.create());
            }
            return this.writeField;
        }
    }

    static abstract class ReadNode
    extends Node {
        @Node.Child
        private ArrayReadNode arrayRead;
        @Node.Child
        private LookupFieldNode lookupField;
        @Node.Child
        private ReadFieldNode readField;
        @Node.Child
        private LookupMethodNode lookupMethod;
        @Node.Child
        private LookupInnerClassNode lookupInnerClass;

        ReadNode() {
        }

        public Object access(JavaObject object, Number index) {
            if (this.arrayRead == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayRead = this.insert(ArrayReadNode.create());
            }
            return this.arrayRead.executeWithTarget(object, index);
        }

        public Object access(JavaObject object, String name) {
            if (TruffleOptions.AOT || object.isNull()) {
                throw UnsupportedMessageException.raise(Message.READ);
            }
            boolean isStatic = object.isStaticClass();
            Class<?> lookupClass = object.getLookupClass();
            JavaFieldDesc foundField = this.lookupField().execute(lookupClass, name, isStatic);
            if (foundField != null) {
                return this.readField().execute(foundField, object);
            }
            JavaMethodDesc foundMethod = this.lookupMethod().execute(lookupClass, name, isStatic);
            if (foundMethod != null) {
                return new JavaFunctionObject(foundMethod, object.obj, object.languageContext);
            }
            if (isStatic) {
                LookupInnerClassNode lookupInnerClassNode = this.lookupInnerClass();
                if ("class".equals(name)) {
                    return JavaObject.forClass(lookupClass, object.languageContext);
                }
                Class<?> innerclass = lookupInnerClassNode.execute(lookupClass, name);
                if (innerclass != null) {
                    return JavaObject.forStaticClass(innerclass, object.languageContext);
                }
            }
            throw UnknownIdentifierException.raise(name);
        }

        private ReadFieldNode readField() {
            if (this.readField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readField = this.insert(ReadFieldNode.create());
            }
            return this.readField;
        }

        private LookupFieldNode lookupField() {
            if (this.lookupField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupField = this.insert(LookupFieldNode.create());
            }
            return this.lookupField;
        }

        private LookupMethodNode lookupMethod() {
            if (this.lookupMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupMethod = this.insert(LookupMethodNode.create());
            }
            return this.lookupMethod;
        }

        private LookupInnerClassNode lookupInnerClass() {
            if (this.lookupInnerClass == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupInnerClass = this.insert(LookupInnerClassNode.create());
            }
            return this.lookupInnerClass;
        }
    }

    static abstract class UnboxNode
    extends Node {
        @Node.Child
        private ToPrimitiveNode primitive = ToPrimitiveNode.create();

        UnboxNode() {
        }

        public Object access(JavaObject object) {
            if (JavaInteropAccessor.isGuestPrimitive(object.obj)) {
                return object.obj;
            }
            return UnsupportedMessageException.raise(Message.UNBOX);
        }
    }

    static abstract class BoxedCheckNode
    extends Node {
        @Node.Child
        private ToPrimitiveNode primitive = ToPrimitiveNode.create();

        BoxedCheckNode() {
        }

        public Object access(JavaObject object) {
            return JavaInteropAccessor.isGuestPrimitive(object.obj);
        }
    }

    static abstract class NullCheckNode
    extends Node {
        NullCheckNode() {
        }

        public Object access(JavaObject object) {
            return object.isNull();
        }
    }

    static abstract class NewNode
    extends Node {
        private static final Message NEW = Message.createNew(0);
        @Node.Child
        private LookupConstructorNode lookupConstructor;
        @Node.Child
        private ExecuteMethodNode executeMethod;
        @Node.Child
        private ToJavaNode toJava;

        NewNode() {
        }

        public Object access(JavaObject receiver, Object[] args) {
            if (TruffleOptions.AOT) {
                throw UnsupportedMessageException.raise(NEW);
            }
            if (receiver.isClass()) {
                Class<?> javaClass = receiver.asClass();
                if (javaClass.isArray()) {
                    return this.newArray(receiver, args);
                }
                JavaMethodDesc constructor = this.lookupConstructor().execute(javaClass);
                if (constructor != null) {
                    return this.executeMethod().execute(constructor, null, args, receiver.languageContext);
                }
            }
            throw UnsupportedMessageException.raise(NEW);
        }

        private Object newArray(JavaObject receiver, Object[] args) {
            int length;
            if (args.length != 1) {
                throw ArityException.raise(1, args.length);
            }
            if (this.toJava == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toJava = this.insert(ToJavaNode.create());
            }
            try {
                length = (Integer)this.toJava.execute(args[0], Integer.TYPE, null, receiver.languageContext);
            }
            catch (ClassCastException | NullPointerException e) {
                throw UnsupportedTypeException.raise(e, args);
            }
            Object array = Array.newInstance(receiver.asClass().getComponentType(), length);
            return JavaObject.forObject(array, receiver.languageContext);
        }

        private LookupConstructorNode lookupConstructor() {
            if (this.lookupConstructor == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupConstructor = this.insert(LookupConstructorNode.create());
            }
            return this.lookupConstructor;
        }

        private ExecuteMethodNode executeMethod() {
            if (this.executeMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeMethod = this.insert(ExecuteMethodNode.create());
            }
            return this.executeMethod;
        }
    }

    static abstract class IsInstantiableObjectNode
    extends Node {
        @Node.Child
        private LookupConstructorNode lookupConstructor;

        IsInstantiableObjectNode() {
        }

        public Object access(JavaObject receiver) {
            if (TruffleOptions.AOT) {
                return false;
            }
            return receiver.isClass() && this.lookupConstructor().execute(receiver.asClass()) != null;
        }

        private LookupConstructorNode lookupConstructor() {
            if (this.lookupConstructor == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupConstructor = this.insert(LookupConstructorNode.create());
            }
            return this.lookupConstructor;
        }
    }

    static abstract class InvokeNode
    extends Node {
        private static final Message INVOKE = Message.createInvoke(0);
        @Node.Child
        private LookupMethodNode lookupMethod;
        @Node.Child
        private ExecuteMethodNode executeMethod;
        @Node.Child
        private LookupFieldNode lookupField;
        @Node.Child
        private ReadFieldNode readField;
        @Node.Child
        private Node sendIsExecutableNode;
        @Node.Child
        private Node sendExecuteNode;

        InvokeNode() {
        }

        public Object access(JavaObject object, String name, Object[] args) {
            Object fieldValue;
            if (TruffleOptions.AOT || object.isNull()) {
                throw UnsupportedMessageException.raise(INVOKE);
            }
            boolean isStatic = object.isStaticClass();
            Class<?> lookupClass = object.getLookupClass();
            JavaMethodDesc foundMethod = this.lookupMethod().execute(lookupClass, name, isStatic);
            if (foundMethod != null) {
                return this.executeMethod().execute(foundMethod, object.obj, args, object.languageContext);
            }
            JavaFieldDesc foundField = this.lookupField().execute(lookupClass, name, isStatic);
            if (foundField != null && (fieldValue = this.readField().execute(foundField, object)) instanceof TruffleObject) {
                boolean isExecutable;
                TruffleObject fieldObject = (TruffleObject)fieldValue;
                if (this.sendIsExecutableNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.sendIsExecutableNode = this.insert(Message.IS_EXECUTABLE.createNode());
                }
                if (isExecutable = ForeignAccess.sendIsExecutable(this.sendIsExecutableNode, fieldObject)) {
                    if (this.sendExecuteNode == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.sendExecuteNode = this.insert(Message.createExecute(args.length).createNode());
                    }
                    try {
                        return ForeignAccess.sendExecute(this.sendExecuteNode, fieldObject, args);
                    }
                    catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                        throw e.raise();
                    }
                }
            }
            throw UnknownIdentifierException.raise(name);
        }

        private LookupMethodNode lookupMethod() {
            if (this.lookupMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupMethod = this.insert(LookupMethodNode.create());
            }
            return this.lookupMethod;
        }

        private ExecuteMethodNode executeMethod() {
            if (this.executeMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeMethod = this.insert(ExecuteMethodNode.create());
            }
            return this.executeMethod;
        }

        private LookupFieldNode lookupField() {
            if (this.lookupField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupField = this.insert(LookupFieldNode.create());
            }
            return this.lookupField;
        }

        private ReadFieldNode readField() {
            if (this.readField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readField = this.insert(ReadFieldNode.create());
            }
            return this.readField;
        }
    }

    static abstract class ArrayHasSizeNode
    extends Node {
        ArrayHasSizeNode() {
        }

        public Object access(JavaObject receiver) {
            Object obj = receiver.obj;
            if (obj == null) {
                return false;
            }
            return obj.getClass().isArray() || obj instanceof List;
        }
    }

    static abstract class ArrayGetSizeNode
    extends Node {
        ArrayGetSizeNode() {
        }

        public Object access(JavaObject receiver) {
            Object obj = receiver.obj;
            if (obj != null) {
                if (obj.getClass().isArray()) {
                    return Array.getLength(obj);
                }
                if (obj instanceof List) {
                    return ((List)obj).size();
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.raise(Message.GET_SIZE);
        }
    }
}

