/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.KeyInfoCacheNodeGen;
import com.oracle.truffle.api.nodes.Node;

abstract class KeyInfoCacheNode
extends Node {
    static final int LIMIT = 3;

    KeyInfoCacheNode() {
    }

    static KeyInfoCacheNode create() {
        return KeyInfoCacheNodeGen.create();
    }

    public abstract int execute(Class<?> var1, String var2, boolean var3);

    @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
    static int doCached(Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name, onlyStatic)") int cachedKeyInfo) {
        assert (cachedKeyInfo == KeyInfoCacheNode.doUncached(clazz, name, onlyStatic));
        return cachedKeyInfo;
    }

    @Specialization(replaces={"doCached"})
    static int doUncached(Class<?> clazz, String name, boolean onlyStatic) {
        return JavaInteropReflect.findKeyInfo(clazz, name, onlyStatic);
    }
}

