/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.JavaClassDesc;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.LookupConstructorNodeGen;
import com.oracle.truffle.api.nodes.Node;

abstract class LookupConstructorNode
extends Node {
    static final int LIMIT = 3;

    LookupConstructorNode() {
    }

    static LookupConstructorNode create() {
        return LookupConstructorNodeGen.create();
    }

    public abstract JavaMethodDesc execute(Class<?> var1);

    @Specialization(guards={"clazz == cachedClazz"}, limit="LIMIT")
    static JavaMethodDesc doCached(Class<?> clazz, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="doUncached(clazz)") JavaMethodDesc cachedMethod) {
        assert (cachedMethod == LookupConstructorNode.doUncached(clazz));
        return cachedMethod;
    }

    @Specialization(replaces={"doCached"})
    static JavaMethodDesc doUncached(Class<?> clazz) {
        return JavaClassDesc.forClass(clazz).lookupConstructor();
    }
}

