/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.LookupMethodNodeGen;
import com.oracle.truffle.api.nodes.Node;

abstract class LookupMethodNode
extends Node {
    static final int LIMIT = 3;

    LookupMethodNode() {
    }

    static LookupMethodNode create() {
        return LookupMethodNodeGen.create();
    }

    public abstract JavaMethodDesc execute(Class<?> var1, String var2, boolean var3);

    @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
    static JavaMethodDesc doCached(Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name, onlyStatic)") JavaMethodDesc cachedMethod) {
        assert (cachedMethod == JavaInteropReflect.findMethod(clazz, name, onlyStatic));
        return cachedMethod;
    }

    @Specialization(replaces={"doCached"})
    static JavaMethodDesc doUncached(Class<?> clazz, String name, boolean onlyStatic) {
        return JavaInteropReflect.findMethod(clazz, name, onlyStatic);
    }
}

